/*
 * Decompiled with CFR 0.152.
 */
package marmot.util.edit;

import java.util.List;
import java.util.Random;
import lemming.lemma.LemmaInstance;
import marmot.util.Counter;
import marmot.util.edit.EditTree;
import marmot.util.edit.EditTreeBuilder;

public class EditTreeBuilderTrainer {
    private Random random_;
    private int num_iterations_;
    private int max_depth_;

    public EditTreeBuilderTrainer(Random random, int num_iterations, int max_depth) {
        this.random_ = random;
        this.num_iterations_ = num_iterations;
        this.max_depth_ = max_depth;
    }

    public EditTreeBuilder train(List<LemmaInstance> instances) {
        EditTreeBuilder builder = new EditTreeBuilder(this.random_, this.max_depth_);
        for (int iter = 0; iter < this.num_iterations_; ++iter) {
            Counter<String> counter = new Counter<String>();
            for (LemmaInstance instance : instances) {
                EditTree tree = builder.build(instance.getForm(), instance.getLemma());
                tree.increment(counter);
            }
            builder.setCounter(counter);
        }
        return builder;
    }
}

