/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.index;

import de.ids_mannheim.korap.index.MultiTerm;
import de.ids_mannheim.korap.index.MultiTermToken;
import de.ids_mannheim.korap.util.CorpusDataException;
import java.io.IOException;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PayloadAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.util.BytesRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiTermTokenStream
extends TokenStream {
    private CharTermAttribute charTermAttr;
    private PositionIncrementAttribute posIncrAttr;
    private PayloadAttribute payloadAttr;
    private static final Pattern pattern = Pattern.compile("\\[(?:\\([0-9]+-[0-9]+\\))?([^\\]]+?)\\]");
    public static final boolean DEBUG = false;
    private final Logger log = LoggerFactory.getLogger(MultiTermTokenStream.class);
    private List<MultiTermToken> multiTermTokens;
    private int mttIndex = 0;
    private int mtIndex = 0;
    private short i = 0;
    private ByteBuffer payload = ByteBuffer.allocate(36);

    public MultiTermTokenStream() {
        this.charTermAttr = this.addAttribute(CharTermAttribute.class);
        this.posIncrAttr = this.addAttribute(PositionIncrementAttribute.class);
        this.payloadAttr = this.addAttribute(PayloadAttribute.class);
        this.multiTermTokens = new ArrayList<MultiTermToken>(100);
    }

    public MultiTermTokenStream(String stream) {
        this();
        try {
            this._fromString(stream);
        }
        catch (CorpusDataException cde) {
            this.log.error("{}: {}", (Object)cde.getErrorCode(), (Object)cde.getMessage());
        }
    }

    public MultiTermTokenStream(Reader stream) throws IOException {
        this();
        int j;
        StringBuilder sb = new StringBuilder(4096);
        char[] buf = new char[128];
        while ((j = stream.read(buf)) > 0) {
            sb.append(buf, 0, j);
        }
        try {
            this._fromString(sb.toString());
        }
        catch (CorpusDataException cde) {
            this.log.error("{}: {}", (Object)cde.getErrorCode(), (Object)cde.getMessage());
        }
    }

    public MultiTermTokenStream addMultiTermToken(MultiTermToken mtt) {
        this.multiTermTokens.add(mtt);
        return this;
    }

    public MultiTermTokenStream addMultiTermToken(MultiTerm mts, MultiTerm ... moreTerms) {
        return this.addMultiTermToken(new MultiTermToken(mts, moreTerms));
    }

    public MultiTermTokenStream addMultiTermToken(char prefix, String surface) {
        return this.addMultiTermToken(new MultiTermToken(prefix, surface));
    }

    public MultiTermTokenStream addMultiTermToken(String surface, String ... moreTerms) {
        try {
            this.addMultiTermToken(new MultiTermToken(surface, moreTerms));
        }
        catch (CorpusDataException cde) {
            this.log.error("{}: {}", (Object)cde.getErrorCode(), (Object)cde.getMessage());
        }
        return this;
    }

    public MultiTermTokenStream addMeta(String key, String value) {
        try {
            MultiTerm mt = new MultiTerm('-', key);
            mt.setPayload(value);
            this.multiTermTokens.get(0).add(mt);
        }
        catch (CorpusDataException cde) {
            this.log.error("{}: {}", (Object)cde.getErrorCode(), (Object)cde.getMessage());
        }
        return this;
    }

    public MultiTermTokenStream addMeta(String key, byte[] value) {
        try {
            MultiTerm mt = new MultiTerm('-', key);
            mt.setPayload(value);
            this.multiTermTokens.get(0).add(mt);
        }
        catch (CorpusDataException cde) {
            this.log.error("{}: {}", (Object)cde.getErrorCode(), (Object)cde.getMessage());
        }
        return this;
    }

    public MultiTermTokenStream addMeta(String key, short value) {
        try {
            MultiTerm mt = new MultiTerm('-', key);
            mt.setPayload(value);
            this.multiTermTokens.get(0).add(mt);
        }
        catch (CorpusDataException cde) {
            this.log.error("{}: {}", (Object)cde.getErrorCode(), (Object)cde.getMessage());
        }
        return this;
    }

    public MultiTermTokenStream addMeta(String key, long value) {
        try {
            MultiTerm mt = new MultiTerm('-', key);
            mt.setPayload(value);
            this.multiTermTokens.get(0).add(mt);
        }
        catch (CorpusDataException cde) {
            this.log.error("{}: {}", (Object)cde.getErrorCode(), (Object)cde.getMessage());
        }
        return this;
    }

    public MultiTermTokenStream addMeta(String key, int value) {
        try {
            MultiTerm mt = new MultiTerm('-', key);
            mt.setPayload(value);
            this.multiTermTokens.get(0).add(mt);
        }
        catch (CorpusDataException cde) {
            this.log.error("{}: {}", (Object)cde.getErrorCode(), (Object)cde.getMessage());
        }
        return this;
    }

    public MultiTermToken get(int index) {
        return this.multiTermTokens.get(index);
    }

    public int getSize() {
        return this.multiTermTokens.size();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (MultiTermToken mtt : this.multiTermTokens) {
            sb.append(mtt.toString());
        }
        return sb.toString();
    }

    private void _fromString(String stream) throws CorpusDataException {
        Matcher matcher = pattern.matcher(stream);
        while (matcher.find()) {
            String[] seg = matcher.group(1).split("\\|");
            MultiTermToken mtt = new MultiTermToken(seg[0], new String[0]);
            this.i = 1;
            while (this.i < seg.length) {
                mtt.add(seg[this.i]);
                this.i = (short)(this.i + 1);
            }
            this.addMultiTermToken(mtt);
        }
    }

    @Override
    public final boolean incrementToken() throws IOException {
        this.payloadAttr.setPayload(null);
        if (this.multiTermTokens.size() == this.mttIndex) {
            this.reset();
            return false;
        }
        MultiTermToken mtt = this.multiTermTokens.get(this.mttIndex);
        mtt.sort();
        if (mtt.terms.size() == this.mtIndex) {
            this.mtIndex = 0;
            ++this.mttIndex;
            if (this.multiTermTokens.size() == this.mttIndex) {
                this.reset();
                return false;
            }
            mtt = this.multiTermTokens.get(this.mttIndex);
        }
        MultiTerm mt = mtt.terms.get(this.mtIndex);
        this.posIncrAttr.setPositionIncrement(this.mtIndex == 0 ? 1 : 0);
        this.charTermAttr.setEmpty();
        this.charTermAttr.append(mt.term);
        this.payload.rewind();
        if (mt.start != mt.end) {
            this.payload.putInt(mt.start);
            this.payload.putInt(mt.end);
        }
        if (mt.payload != null) {
            this.payload.put(mt.payload.bytes);
        }
        if (this.payload.position() > 0) {
            if (this.payload.hasArray()) {
                this.payloadAttr.setPayload(new BytesRef(Arrays.copyOfRange(this.payload.array(), this.payload.arrayOffset(), this.payload.arrayOffset() + this.payload.position())));
            } else {
                this.log.error("This should never happen!");
            }
        }
        ++this.mtIndex;
        return true;
    }

    @Override
    public void reset() {
        this.mttIndex = 0;
        this.mtIndex = 0;
    }
}

