/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.mchange.v2.c3p0.ComboPooledDataSource;
import de.ids_mannheim.korap.Krill;
import de.ids_mannheim.korap.KrillCollection;
import de.ids_mannheim.korap.KrillIndex;
import de.ids_mannheim.korap.index.FieldDocument;
import de.ids_mannheim.korap.response.MatchCollector;
import de.ids_mannheim.korap.response.Response;
import de.ids_mannheim.korap.response.Result;
import de.ids_mannheim.korap.response.collector.MatchCollectorDB;
import de.ids_mannheim.korap.server.Node;
import de.ids_mannheim.korap.util.QueryException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.UriInfo;
import jakarta.ws.rs.ext.ReaderInterceptor;
import jakarta.ws.rs.ext.ReaderInterceptorContext;
import jakarta.ws.rs.ext.WriterInterceptor;
import jakarta.ws.rs.ext.WriterInterceptorContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
public class Resource {
    private String version;
    private static final Logger log = LoggerFactory.getLogger(Node.class);
    public static final boolean DEBUG = false;
    private static final Pattern p = Pattern.compile("\\s*(?i:false|no|inactive|disabled|off|n|neg(?:ative)?|not|null|undef)\\s*");
    private KrillIndex index;

    @GET
    @Produces(value={"application/json"})
    public String info() {
        Response kresp = this._initResponse();
        if (kresp.hasErrors()) {
            return kresp.toJsonString();
        }
        kresp.addMessage(680, "Server is up and running!", new String[0]);
        return kresp.toJsonString();
    }

    @PUT
    @Path(value="/index/{textID}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public String add(@PathParam(value="textID") Integer uid, @Context UriInfo uri, String json) {
        Response kresp = this._initResponse();
        if (kresp.hasErrors()) {
            return kresp.toJsonString();
        }
        this.index = Node.getIndex();
        FieldDocument fd = this.index.addDoc(uid, json);
        if (fd == null) {
            kresp.addError(602, "Unable to add document to index", new String[0]);
            return kresp.toJsonString();
        }
        kresp.addMessage(681, "Document was added successfully", fd.getID() != null ? fd.getID() : "Unknown");
        kresp.addJsonNode("text", (ObjectNode)fd.toJsonNode());
        return kresp.toJsonString();
    }

    @GET
    @Path(value="/index/{textID}")
    @Produces(value={"application/json"})
    public String get(@PathParam(value="textID") String uid, @Context UriInfo uri) {
        Response kresp = this._initResponse();
        if (kresp.hasErrors()) {
            return kresp.toJsonString();
        }
        this.index = Node.getIndex();
        return this.index.getDoc(uid).toJsonString();
    }

    @POST
    @Path(value="/index")
    @Produces(value={"application/json"})
    public String commit() {
        Response kresp = this._initResponse();
        if (kresp.hasErrors()) {
            return kresp.toJsonString();
        }
        try {
            Node.getIndex().commit();
            kresp.addMessage(683, "Staged data committed", new String[0]);
        }
        catch (IOException e) {
            kresp.addError(603, "Unable to commit staged data to index", new String[0]);
            return kresp.toJsonString();
        }
        return kresp.toJsonString();
    }

    @GET
    @Path(value="/corpus")
    @Produces(value={"application/json"})
    public String getCorpus(@Context UriInfo uri) {
        ObjectMapper mapper = new ObjectMapper();
        Response kresp = this._initResponse();
        if (kresp.hasErrors()) {
            return kresp.toJsonString();
        }
        KrillIndex ki = Node.getIndex();
        ObjectNode obj = mapper.createObjectNode();
        obj.put("tokens", ki.numberOf("tokens"));
        obj.put("base/texts", ki.numberOf("base/texts"));
        obj.put("base/sentences", ki.numberOf("base/sentences"));
        obj.put("base/paragraphs", ki.numberOf("base/paragraphs"));
        obj.put("sentences", ki.numberOf("sentences"));
        obj.put("paragraphs", ki.numberOf("paragraphs"));
        kresp.addJsonNode("stats", obj);
        return kresp.toJsonString();
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public String find(String json, @Context UriInfo uri) {
        Response kresp = this._initResponse();
        if (kresp.hasErrors()) {
            return kresp.toJsonString();
        }
        Krill ks = new Krill(json);
        MultivaluedMap<String, String> qp = uri.getQueryParameters();
        if (qp.get("uid") == null) {
            kresp.addError(610, "Missing request parameters", "No unique IDs were given");
            return kresp.toJsonString();
        }
        List uids = (List)qp.get("uid");
        KrillCollection kc = new KrillCollection();
        kc.filterUIDs(uids.toArray(new String[uids.size()]));
        ks.setCollection(kc);
        ks.getMeta().setItemsPerResource(1);
        return ks.apply(Node.getIndex()).toJsonString();
    }

    @PUT
    @Path(value="/collect/{resultID}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public String collect(String json, @PathParam(value="resultID") String resultID, @Context UriInfo uri) {
        Response kresp = this._initResponse();
        if (kresp.hasErrors()) {
            return kresp.toJsonString();
        }
        try {
            MatchCollectorDB mc = new MatchCollectorDB(1000, "Res_" + resultID);
            ComboPooledDataSource pool = Node.getDBPool();
            mc.setDBPool("mysql", pool, pool.getConnection());
            Krill ks = new Krill(json);
            MatchCollector result = Node.getIndex().collect(ks, mc);
            result.setNode(Node.getName());
            return result.toJsonString();
        }
        catch (SQLException e) {
            log.error(e.getLocalizedMessage());
            kresp.addError(604, "Unable to connect to database", new String[0]);
            return kresp.toJsonString();
        }
    }

    @POST
    @Path(value="/search")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public String search(String json) {
        Response kresp = this._initResponse();
        if (kresp.hasErrors()) {
            return kresp.toJsonString();
        }
        Result kr = new Krill(json).apply(Node.getIndex());
        return kr.toJsonString();
    }

    @GET
    @Path(value="/match/{matchID}")
    @Produces(value={"application/json"})
    public String match(@PathParam(value="matchID") String id, @Context UriInfo uri) {
        String highlights;
        Response kresp = this._initResponse();
        if (kresp.hasErrors()) {
            return kresp.toJsonString();
        }
        KrillIndex index = Node.getIndex();
        MultivaluedMap<String, String> qp = uri.getQueryParameters();
        boolean includeSpans = false;
        boolean includeHighlights = true;
        boolean extendToSentence = false;
        boolean info = false;
        if (!Resource._isNull(qp.getFirst("info"))) {
            info = true;
        }
        if (!Resource._isNull(qp.getFirst("spans"))) {
            includeSpans = true;
            info = true;
        }
        if ((highlights = qp.getFirst("highlights")) != null && Resource._isNull(highlights)) {
            includeHighlights = false;
        }
        if (!Resource._isNull(qp.getFirst("extended"))) {
            extendToSentence = true;
        }
        List foundries = (List)qp.get("foundry");
        List layers = (List)qp.get("layer");
        try {
            return index.getMatchInfo(id, "tokens", info, foundries, layers, includeSpans, includeHighlights, extendToSentence).toJsonString();
        }
        catch (QueryException qe) {
            kresp.addError(qe.getErrorCode(), qe.getMessage(), new String[0]);
            return kresp.toJsonString();
        }
    }

    @POST
    @Path(value="/collection")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public String collection(String json) {
        KrillIndex index = Node.getIndex();
        if (index == null) {
            return "{\"documents\" : -1, error\" : \"No index given\" }";
        }
        return "{}";
    }

    private Response _initResponse() {
        Response kresp = new Response();
        kresp.setNode(Node.getName());
        kresp.setListener(Node.getListener());
        KrillIndex index = Node.getIndex();
        if (index == null) {
            kresp.addError(601, "Unable to find index", new String[0]);
            return kresp;
        }
        kresp.setVersion(index.getVersion());
        kresp.setName(index.getName());
        return kresp;
    }

    private static boolean _isNull(String value) {
        if (value == null) {
            return true;
        }
        Matcher m = p.matcher(value);
        return m.matches();
    }

    public class GZIPWriterInterceptor
    implements WriterInterceptor {
        @Override
        public void aroundWriteTo(WriterInterceptorContext context) throws IOException, WebApplicationException {
            OutputStream outputStream = context.getOutputStream();
            context.setOutputStream(new GZIPOutputStream(outputStream));
            context.proceed();
        }
    }

    public class GZIPReaderInterceptor
    implements ReaderInterceptor {
        @Override
        public Object aroundReadFrom(ReaderInterceptorContext context) throws IOException, WebApplicationException {
            InputStream originalInputStream = context.getInputStream();
            context.setInputStream(new GZIPInputStream(originalInputStream));
            return context.proceed();
        }
    }
}

