/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema.sdoc;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.ee.schema.PreparedSchema;
import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.SingleNamespaceSchema;
import com.saxonica.ee.schema.sdoc.AnnotationParent;
import com.saxonica.ee.schema.sdoc.SchemaDocument;
import com.saxonica.ee.schema.sdoc.SchemaReader;
import com.saxonica.ee.schema.sdoc.XSDSchema;
import java.io.IOException;
import java.net.URISyntaxException;
import javax.xml.transform.Source;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.functions.ResolveURI;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.type.SchemaException;

public class XSDInclude
extends AnnotationParent {
    private PreparedSchema includedSchema;

    @Override
    protected void prepareAttributes() throws SchemaException {
        AttributeMap atts = this.attributes();
        String[] allowed = new String[]{"id", "schemaLocation"};
        this.allowAttributes(atts, allowed);
        this.processId();
        String schemaLocation = atts.getValue(NamespaceUri.NULL, "schemaLocation");
        if (schemaLocation == null) {
            this.missingAttribute("schemaLocation");
            return;
        }
        SchemaCompiler compiler = this.getXSDSchema().getSchemaCompiler();
        String documentBase = this.getBaseURI();
        try {
            String location = ResolveURI.makeAbsolute(schemaLocation, documentBase).toString();
            XSDSchema existing = compiler.getExistingSchemaDocument(location, this.getXSDSchema().getTargetNamespace());
            if (existing != null) {
                this.includedSchema = existing.getSchema();
                return;
            }
        }
        catch (URISyntaxException location) {
            // empty catch block
        }
        Source source = null;
        try {
            source = SchemaReader.getSource(this.getBaseURI(), schemaLocation, compiler, null);
        }
        catch (SchemaException e) {
            this.handleSchemaException(schemaLocation, e);
        }
        if (source == null) {
            this.warning("Failed to locate included schema document " + schemaLocation);
            this.includedSchema = new SingleNamespaceSchema((EnterpriseConfiguration)this.getConfiguration(), NamespaceUri.NULL);
        } else {
            if (compiler.isBeingRead(source.getSystemId())) {
                this.warning("Module " + source.getSystemId() + " includes itself recursively");
                return;
            }
            try {
                PipelineConfiguration pipe = this.getSchemaNodeFactory().getPipelineConfiguration();
                SchemaDocument inc = SchemaReader.read(source, compiler, pipe, this);
                XSDSchema includedXSDSchema = inc.getXSDSchema();
                includedXSDSchema.setReferrer(this);
                this.includedSchema = includedXSDSchema.getSchema();
                compiler.markAsRead(source.getSystemId(), includedXSDSchema);
            }
            catch (SchemaException e) {
                this.handleSchemaException(schemaLocation, e);
            }
        }
    }

    private void handleSchemaException(String schemaLocation, SchemaException e) throws SchemaException {
        Throwable cause = e.getException();
        if (!XSDInclude.isFileNotFoundException(cause)) {
            this.error("Failed to process included schema document " + schemaLocation);
            throw e;
        }
        this.warning("Included schema document " + schemaLocation + " cannot be located: " + cause.getClass().getName() + " (" + cause.getMessage() + ")");
        this.includedSchema = new SingleNamespaceSchema((EnterpriseConfiguration)this.getConfiguration(), NamespaceUri.NULL);
    }

    public static boolean isFileNotFoundException(Throwable cause) {
        return cause instanceof IOException;
    }

    public PreparedSchema getIncludedSchema() {
        return this.includedSchema;
    }
}

