/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.feed;

import com.saxonica.ee.stream.feed.AtomicItemFeed;
import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.watch.Terminator;
import com.saxonica.ee.stream.watch.WatchManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.saxon.event.Outputter;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.GeneralComparison;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.AtomicMatchKey;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.BuiltInType;
import net.sf.saxon.type.Converter;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.z.IntHashMap;
import net.sf.saxon.z.IntIterator;

public class GeneralComparisonEqualityFeed
extends AtomicItemFeed {
    private WatchManager watchManager;
    private final StringCollator collator;
    private IntHashMap<Set<AtomicMatchKey>> lookupTable;
    private List<StringValue> untypedValues;
    private boolean done = false;
    private final Expression pullOperand;
    private final int implicitTimezone;
    private boolean closed;

    public GeneralComparisonEqualityFeed(WatchManager watchManager, Expression expr, int pushedArg, ItemFeed result, XPathContext context) {
        super(expr, result, context);
        this.watchManager = watchManager;
        GeneralComparison gc = (GeneralComparison)this.getExpression();
        this.collator = gc.getStringCollator();
        this.pullOperand = pushedArg == 0 ? gc.getRhsExpression() : gc.getLhsExpression();
        this.implicitTimezone = context.getImplicitTimezone();
    }

    @Override
    public void open(Terminator terminator) throws XPathException {
        super.open(terminator);
        this.done = false;
        this.lookupTable = null;
    }

    @Override
    public void append(Item item) throws XPathException {
        block12: {
            IntIterator types;
            BuiltInAtomicType matchType;
            AtomicMatchKey k1;
            AtomicValue next;
            ConversionRules rules;
            block14: {
                block13: {
                    AtomicValue val;
                    if (this.done) break block12;
                    XPathContext context = this.getContext();
                    rules = context.getConfiguration().getConversionRules();
                    next = (AtomicValue)item;
                    k1 = next.getXPathMatchKey(this.collator, this.implicitTimezone);
                    matchType = next instanceof NumericValue ? BuiltInAtomicType.DOUBLE : ((AtomicValue)item).getPrimitiveType();
                    if (this.lookupTable != null) break block13;
                    this.lookupTable = new IntHashMap(4);
                    this.untypedValues = new ArrayList<StringValue>(4);
                    HashSet<AtomicMatchKey> strings = new HashSet<AtomicMatchKey>(10);
                    this.lookupTable.put(631, strings);
                    Object typed = null;
                    if (!next.isUntypedAtomic()) {
                        typed = new HashSet(10);
                        this.lookupTable.put(matchType.getFingerprint(), (Set<AtomicMatchKey>)typed);
                    }
                    SequenceIterator comparand = this.pullOperand.iterate(context);
                    while ((val = (AtomicValue)comparand.next()) != null) {
                        if (val.isUntypedAtomic()) {
                            this.untypedValues.add((StringValue)val);
                            strings.add(((StringValue)val).getXPathMatchKey(this.collator, this.implicitTimezone));
                            if (typed == null) continue;
                            AtomicValue cval = Converter.convert(val, matchType, rules);
                            typed.add(cval.getXPathMatchKey(this.collator, this.implicitTimezone));
                            if (matchType == BuiltInAtomicType.UNTYPED_ATOMIC) continue;
                            strings.add(val.getXPathMatchKey(this.collator, this.implicitTimezone));
                            continue;
                        }
                        BuiltInAtomicType prim = val instanceof NumericValue ? BuiltInAtomicType.DOUBLE : val.getPrimitiveType();
                        Set<AtomicMatchKey> keys = this.lookupTable.get(prim.getFingerprint());
                        if (keys == null) {
                            keys = new HashSet<AtomicMatchKey>(10);
                            this.lookupTable.put(prim.getFingerprint(), keys);
                        }
                        keys.add(val.getXPathMatchKey(this.collator, this.implicitTimezone));
                    }
                    for (StringValue untypedVal : this.untypedValues) {
                        IntIterator types2 = this.lookupTable.keyIterator();
                        while (types2.hasNext()) {
                            int type = types2.next();
                            Set<AtomicMatchKey> keys = this.lookupTable.get(type);
                            BuiltInAtomicType atomicType = (BuiltInAtomicType)BuiltInType.getSchemaType(type);
                            keys.add(Converter.convert(untypedVal, atomicType, rules).getXPathMatchKey(this.collator, this.implicitTimezone));
                        }
                    }
                    if (this.lookupTable.size() != 0 || !this.untypedValues.isEmpty()) break block14;
                    Outputter out = this.getNextOutputter();
                    this.done = true;
                    out.append(BooleanValue.FALSE);
                    this.lookupTable = null;
                    if (!this.watchManager.allowsEarlyExit()) break block14;
                    this.closed = true;
                    out.close();
                    this.getTerminator().terminate();
                    break block14;
                }
                Set<AtomicMatchKey> typed = this.lookupTable.get(matchType.getFingerprint());
                if (typed == null) {
                    typed = new HashSet<AtomicMatchKey>(10);
                    this.lookupTable.put(matchType.getFingerprint(), typed);
                    for (StringValue val : this.untypedValues) {
                        AtomicValue cval = Converter.convert(val, matchType, rules);
                        typed.add(cval.getXPathMatchKey(this.collator, this.implicitTimezone));
                    }
                }
            }
            Set<AtomicMatchKey> lookup = this.lookupTable.get(matchType.getFingerprint());
            if (next.isUntypedAtomic()) {
                types = this.lookupTable.keyIterator();
                while (types.hasNext() && !this.done) {
                    int t = types.next();
                    AtomicValue converted = Converter.convert(next, (AtomicType)BuiltInType.getSchemaType(t), rules);
                    lookup = this.lookupTable.get(t);
                    if (lookup == null) continue;
                    this.testValue(lookup, converted.getXPathMatchKey(this.collator, this.implicitTimezone));
                }
            } else {
                types = this.lookupTable.keyIterator();
                while (types.hasNext() && !this.done) {
                    BuiltInAtomicType u;
                    int t = types.next();
                    if (t == 631 || matchType == (u = (BuiltInAtomicType)BuiltInType.getSchemaType(t)) || Type.isGuaranteedComparable(matchType, u, false)) continue;
                    throw new XPathException("Comparison between " + matchType.getDisplayName() + " and " + u.getDisplayName() + " is not allowed", "XPTY0004", this.getExpression().getLocation());
                }
                this.testValue(lookup, k1);
            }
        }
    }

    private void testValue(Set<AtomicMatchKey> lookup, AtomicMatchKey k) throws XPathException {
        Outputter out = this.getNextOutputter();
        if (lookup.contains(k)) {
            this.done = true;
            out.append(BooleanValue.TRUE);
            this.lookupTable = null;
            if (this.watchManager.allowsEarlyExit()) {
                this.closed = true;
                out.close();
                this.getTerminator().terminate();
            }
        }
    }

    @Override
    public void close() throws XPathException {
        if (!this.done) {
            this.getNextOutputter().append(BooleanValue.FALSE);
        }
        if (!this.closed) {
            super.close();
            this.lookupTable = null;
        }
    }
}

