/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.extfn;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceCollector;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.event.Sink;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.DummyNamespaceResolver;
import net.sf.saxon.expr.parser.Loc;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.Invalidity;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.lib.StandardInvalidityHandler;
import net.sf.saxon.ma.map.DictionaryMap;
import net.sf.saxon.ma.map.KeyValuePair;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.om.AbsolutePath;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.NameOfNode;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.Orphan;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.type.ValidationParams;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.StringValue;

public class ValidateFn
extends SystemFunction {
    @Override
    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        ArrayList<Invalidity> errorList = new ArrayList<Invalidity>(5);
        boolean returnTreeOnFailure = false;
        NodeInfo resultNode = null;
        Configuration config = context.getConfiguration();
        NodeInfo input = (NodeInfo)arguments[0].head();
        if (input == null) {
            return EmptySequence.getInstance();
        }
        SchemaType schemaType = null;
        int validation = 1;
        boolean expand = true;
        boolean buildTree = true;
        if (arguments.length >= 2) {
            MapItem options = (MapItem)arguments[1].head();
            GroundedValue val = options.get(StringValue.bmp("buildTree"));
            if (val != null && val.head() != null) {
                if (val instanceof BooleanValue) {
                    returnTreeOnFailure = buildTree = ((BooleanValue)val).getBooleanValue();
                } else {
                    throw new XPathException("buildTree must be true() or false() or ()");
                }
            }
            if ((val = options.get(StringValue.bmp("type"))) != null) {
                if (val instanceof QNameValue) {
                    schemaType = config.getSchemaType(((QNameValue)val).getStructuredQName());
                    if (schemaType == null) {
                        throw new XPathException("Unknown type " + val, "XPTY0004");
                    }
                } else {
                    throw new XPathException("'type' option in second argument of saxon:validate() must be a QName", "XPTY0004");
                }
            }
            if ((val = options.get(StringValue.bmp("processContents"))) != null) {
                if (val instanceof StringValue) {
                    Object s;
                    switch (s = ((StringValue)val).getStringValue()) {
                        case "strict": {
                            break;
                        }
                        case "lax": {
                            validation = 2;
                            break;
                        }
                        default: {
                            throw new XPathException("processContents must be 'strict' or 'lax'");
                        }
                    }
                } else {
                    throw new XPathException("'processContents' option in second argument of saxon:validate() must be a string", "XPTY0004");
                }
            }
            if ((val = options.get(StringValue.bmp("expandDefaults"))) != null) {
                if (val instanceof BooleanValue) {
                    expand = ((BooleanValue)val).getBooleanValue();
                } else {
                    throw new XPathException("processContents must be true() or false()");
                }
            }
        }
        ValidationParams params = new ValidationParams();
        if (arguments.length >= 3) {
            MapItem rawParams = (MapItem)arguments[2].head();
            for (KeyValuePair pair : rawParams.keyValuePairs()) {
                QNameValue qKey;
                AtomicValue key = pair.key;
                if (key instanceof QNameValue) {
                    qKey = (QNameValue)key;
                } else if (key instanceof StringValue) {
                    qKey = new QNameValue("", NamespaceUri.NULL, key.getStringValue());
                } else {
                    throw new XPathException("key value in third argument to saxon:validate must be a string or QName");
                }
                params.put(qKey.getStructuredQName(), pair.value);
            }
        } else {
            params = new ValidationParams();
        }
        ParseOptions parseOptions = new ParseOptions().withValidationParams(params).withSchemaValidationMode(validation).withTopLevelType(schemaType).withExpandAttributeDefaults(expand).withContinueAfterValidationErrors(true);
        ArrayList<NodeInfo> currentErrorNode = new ArrayList<NodeInfo>(1);
        PipelineConfiguration pipe = context.getController().makePipelineConfiguration();
        pipe.setParseOptions(parseOptions);
        pipe.setXPathContext(context);
        pipe.setCopyInformee(element -> {
            currentErrorNode.clear();
            currentErrorNode.add((NodeInfo)element);
            return null;
        });
        parseOptions = parseOptions.withInvalidityHandler(new LocalInvalidityHandler(config, currentErrorNode, errorList));
        int kind = input.getNodeKind();
        switch (kind) {
            case 9: {
                SequenceReceiver out = buildTree ? new SequenceCollector(pipe) : new Sink(pipe);
                Receiver val = config.getDocumentValidator(out, input.getBaseURI(), parseOptions, null);
                val.setPipelineConfiguration(out.getPipelineConfiguration());
                val.setSystemId(input.getBaseURI());
                input.copy(val, 2, Loc.NONE);
                resultNode = buildTree ? (NodeInfo)((SequenceCollector)out).getFirstItem() : null;
                break;
            }
            case 1: {
                SequenceReceiver out = buildTree ? new SequenceCollector(pipe) : new Sink(pipe);
                parseOptions = parseOptions.withTopLevelElement(NameOfNode.makeName(input).getStructuredQName());
                Receiver val = config.getElementValidator(out, parseOptions, Loc.NONE);
                val.setPipelineConfiguration(out.getPipelineConfiguration());
                val.setSystemId(input.getBaseURI());
                input.copy(val, 2, Loc.NONE);
                resultNode = buildTree ? (NodeInfo)((SequenceCollector)out).getFirstItem() : null;
                break;
            }
            case 2: {
                SimpleType simpleType = BuiltInAtomicType.UNTYPED_ATOMIC;
                if (schemaType instanceof SimpleType) {
                    simpleType = (SimpleType)schemaType;
                    ValidationFailure err = simpleType.validateContent(input.getUnicodeStringValue(), DummyNamespaceResolver.getInstance(), context.getConfiguration().getConversionRules());
                    if (err != null) {
                        ValidationFailure ve = new ValidationFailure("Attribute value " + Err.wrap(input.getUnicodeStringValue(), 4) + " does not match the required type " + schemaType.getDescription() + ". " + err.getMessage());
                        ve.setErrorCode("XTTE1540");
                        ve.setSchemaType(schemaType);
                        ve.setPath(AbsolutePath.pathToNode(input));
                        errorList.add(ve);
                    }
                } else if (validation == 1 || validation == 2) {
                    try {
                        simpleType = config.validateAttribute(NameOfNode.makeName(input).getStructuredQName(), input.getUnicodeStringValue(), validation);
                    }
                    catch (ValidationException e) {
                        ValidationFailure vf = e.getValidationFailure();
                        vf.setInvalidNode(input);
                        errorList.add(vf);
                    }
                } else {
                    resultNode = input;
                    break;
                }
                if (buildTree) {
                    Orphan orphan = new Orphan(config);
                    orphan.setNodeKind((short)2);
                    orphan.setNodeName(NameOfNode.makeName(input));
                    orphan.setStringValue(input.getUnicodeStringValue());
                    orphan.setTypeAnnotation(simpleType);
                    resultNode = orphan;
                    break;
                }
                resultNode = null;
                break;
            }
            default: {
                throw new XPathException("Input to saxon:validate must be a document, element, or attribute node", "XPTY0004");
            }
        }
        DictionaryMap result = new DictionaryMap();
        if (errorList.isEmpty()) {
            if (buildTree) {
                result.initialPut("node", resultNode);
            }
            result.initialPut("valid", BooleanValue.TRUE);
            return result;
        }
        result.initialPut("valid", BooleanValue.FALSE);
        if (returnTreeOnFailure) {
            result.initialPut("node", resultNode);
        }
        ArrayList<DictionaryMap> errors = new ArrayList<DictionaryMap>(errorList.size());
        for (Invalidity te : errorList) {
            ValidationFailure v = (ValidationFailure)te;
            DictionaryMap im = new DictionaryMap();
            if (v.getErrorCodeQName() != null) {
                im.initialPut("code", new QNameValue(v.getErrorCodeQName(), BuiltInAtomicType.QNAME));
            }
            im.initialPut("message", new StringValue(v.getMessage()));
            if (v.getSchemaPart() != -1) {
                im.initialPut("specPart", new Int64Value(v.getSchemaPart()));
            }
            if (v.getConstraintName() != null) {
                im.initialPut("constraint", new StringValue(v.getConstraintName()));
            }
            if (v.getConstraintClauseNumber() != null) {
                im.initialPut("clause", new StringValue(v.getConstraintClauseNumber()));
            }
            if (v.getLineNumber() != -1) {
                im.initialPut("line", new Int64Value(v.getLineNumber()));
            }
            if (v.getColumnNumber() != -1) {
                im.initialPut("colummn", new Int64Value(v.getColumnNumber()));
            }
            if (v.getSystemId() != null) {
                im.initialPut("systemId", new StringValue(v.getSystemId()));
            }
            if (v.getPublicId() != null) {
                im.initialPut("publicId", new StringValue(v.getPublicId()));
            }
            if (v.getInvalidNode() != null) {
                im.initialPut("node", v.getInvalidNode());
            }
            if (v.getPath() != null) {
                im.initialPut("path", new StringValue(v.getPath().getPathUsingUris()));
            }
            errors.add(im);
        }
        result.initialPut("errors", SequenceExtent.makeSequenceExtent(errors));
        return result;
    }

    private static class LocalInvalidityHandler
    extends StandardInvalidityHandler {
        List<NodeInfo> currentErrorNode;
        List<Invalidity> errorList;

        public LocalInvalidityHandler(Configuration config, List<NodeInfo> currentErrorNode, List<Invalidity> errorList) {
            super(config);
            this.errorList = errorList;
            this.currentErrorNode = currentErrorNode;
        }

        @Override
        public void startReporting(String systemId) {
        }

        @Override
        public void reportInvalidity(Invalidity failure) {
            if (!this.currentErrorNode.isEmpty()) {
                ((ValidationFailure)failure).setSourceLocator(this.currentErrorNode.get(0));
                ((ValidationFailure)failure).setPath(AbsolutePath.pathToNode(this.currentErrorNode.get(0)));
                ((ValidationFailure)failure).setInvalidNode(this.currentErrorNode.get(0));
            }
            this.errorList.add(failure);
        }

        @Override
        public Sequence endReporting() {
            return null;
        }
    }
}

