/*
 * Decompiled with CFR 0.152.
 */
package lemming.lemma.cmd;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.List;
import java.util.logging.Logger;
import lemming.lemma.BackupLemmatizer;
import lemming.lemma.LemmaInstance;
import lemming.lemma.LemmaOptions;
import lemming.lemma.LemmaResult;
import lemming.lemma.Lemmatizer;
import lemming.lemma.LemmatizerGenerator;
import lemming.lemma.LemmatizerTrainer;
import lemming.lemma.SimpleLemmatizerTrainer;
import marmot.core.Sequence;
import marmot.core.Token;
import marmot.morph.Word;
import marmot.morph.io.SentenceReader;
import marmot.util.FileUtils;

public class Trainer {
    public static void main(String[] args2) {
        if (args2.length < 4 || args2.length % 2 != 0) {
            System.err.format("Usage: Trainer <model_type> <options_string> <model_file> <train_file> [<test_file> <pred_file>]\n", new Object[0]);
            System.exit(1);
        }
        String model_type = args2[0];
        String options_string = args2[1];
        String output_file = args2[2];
        String train_file = args2[3];
        Lemmatizer lemmatizer = Trainer.train(model_type, options_string, train_file, true);
        for (int i = 4; i < args2.length; i += 2) {
            String test_file = args2[i];
            String pred_file = args2[i + 1];
            Trainer.annotate(lemmatizer, test_file, pred_file);
        }
        FileUtils.saveToFile((Serializable)lemmatizer, output_file);
    }

    static void annotate(Lemmatizer lemmatizer, String test_file, String pred_file) {
        try {
            Writer writer = FileUtils.openFileWriter(pred_file);
            for (Sequence sequence : new SentenceReader(test_file)) {
                int nr = 1;
                for (Token token2 : sequence) {
                    LemmaInstance instance = LemmaInstance.getInstance((Word)token2);
                    String plemma = lemmatizer.lemmatize(instance);
                    writer.write(String.format("%d\t%s\t%s\t%s\t_\t%s\t_\t%s\n", nr, instance.getForm(), instance.getLemma(), plemma, instance.getPosTag(), instance.getMorphTag()));
                    ++nr;
                }
                writer.write(10);
            }
            writer.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Lemmatizer train(String model_type, String options_string, String train_file, boolean use_backup) {
        LemmatizerTrainer trainer;
        try {
            Class<?> trainer_class = Class.forName(model_type);
            trainer = (LemmatizerTrainer)trainer_class.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        LemmaOptions options = trainer.getOptions();
        options.readArguments(options_string);
        Logger logger = Logger.getLogger(Trainer.class.getName());
        logger.info(options.report());
        List<LemmaInstance> training_instances = LemmaInstance.getInstances(new SentenceReader(train_file), options.getLimit());
        Lemmatizer lemmatizer = trainer.train(training_instances, null);
        if (use_backup) {
            SimpleLemmatizerTrainer simple_trainer = new SimpleLemmatizerTrainer();
            simple_trainer.getOptions().setOption("use-backup", false).setOption("handle-unseen", false);
            Lemmatizer simple = simple_trainer.train(training_instances, null);
            BackupLemmatizer backup = new BackupLemmatizer((LemmatizerGenerator)simple, (LemmatizerGenerator)lemmatizer);
            return backup;
        }
        return lemmatizer;
    }

    public static void test(Lemmatizer lemmatizer, String test_file) {
        LemmaResult.logTest(lemmatizer, test_file, 50);
    }
}

