/*
 * Decompiled with CFR 0.152.
 */
package marmot.tokenize.rules;

import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import marmot.tokenize.rules.CzechRuleProvider;
import marmot.tokenize.rules.EnglishRuleProvider;
import marmot.tokenize.rules.GermanRuleProvider;
import marmot.tokenize.rules.Rule;
import marmot.tokenize.rules.RulebasedTransformator;
import marmot.tokenize.rules.SpanishRuleProvider;

public abstract class RuleProvider {
    public abstract Collection<Rule> getTokRules();

    public abstract Collection<Rule> getUnTokRules();

    public static RuleProvider createRuleProvider(String lang) {
        if (lang.equalsIgnoreCase("cs")) {
            return new CzechRuleProvider();
        }
        if (lang.equalsIgnoreCase("de")) {
            return new GermanRuleProvider();
        }
        if (lang.equalsIgnoreCase("en")) {
            return new EnglishRuleProvider();
        }
        if (lang.equalsIgnoreCase("es")) {
            return new SpanishRuleProvider();
        }
        return null;
    }

    public void addSimpleRule(String a, String b, List<Rule> rules) {
        rules.add(new Rule(Pattern.compile("\\P{L}(" + a + ")\\P{L}", 2), b));
        rules.add(new Rule(Pattern.compile("^(" + a + ")\\P{L}", 2), b));
        rules.add(new Rule(Pattern.compile("\\P{L}(" + a + ")$", 2), b));
        rules.add(new Rule(Pattern.compile("^(" + a + ")$", 2), b));
    }

    public RulebasedTransformator getTokTransformator() {
        if (this.getTokRules() == null) {
            return null;
        }
        return new RulebasedTransformator(this.getTokRules());
    }

    public RulebasedTransformator getUnTokTransformator() {
        if (this.getUnTokRules() == null) {
            return null;
        }
        return new RulebasedTransformator(this.getUnTokRules());
    }
}

