/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.ids_mannheim.korap.Krill;
import de.ids_mannheim.korap.response.Notifications;
import de.ids_mannheim.korap.response.SearchContext;
import de.ids_mannheim.korap.util.QueryException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KrillMeta
extends Notifications {
    private boolean cutOff = false;
    private int limit = 0;
    private short count = (short)25;
    private short countMax = (short)50;
    private int startIndex = 0;
    private short itemsPerResource = 0;
    private SearchContext context;
    private boolean snippets = true;
    private boolean tokens = false;
    private ArrayList<String> fields = new ArrayList(16);
    HashSet<Integer> highlights;
    private long timeout = 120000L;
    private static final Logger log = LoggerFactory.getLogger(Krill.class);

    public KrillMeta() {
        for (String field : new String[]{"ID", "UID", "textSigle", "corpusID", "author", "title", "subTitle", "textClass", "pubPlace", "pubDate", "availability", "layerInfos", "docSigle", "corpusSigle"}) {
            this.fields.add(field);
        }
        this.highlights = new HashSet(3);
        this.context = new SearchContext();
    }

    public KrillMeta(JsonNode json) {
        for (String field : new String[]{"ID", "UID", "textSigle", "corpusID", "author", "title", "subTitle", "textClass", "pubPlace", "pubDate", "availability", "layerInfos", "docSigle", "corpusSigle"}) {
            this.fields.add(field);
        }
        this.highlights = new HashSet(3);
        this.context = new SearchContext();
        this.fromJson(json);
    }

    public KrillMeta(String json) {
        for (String field : new String[]{"ID", "UID", "textSigle", "corpusID", "author", "title", "subTitle", "textClass", "pubPlace", "pubDate", "availability", "layerInfos", "docSigle", "corpusSigle"}) {
            this.fields.add(field);
        }
        this.highlights = new HashSet(3);
        this.context = new SearchContext();
        try {
            this.fromJson(json);
        }
        catch (QueryException q) {
            this.addError(q.getErrorCode(), q.getMessage(), new String[0]);
        }
    }

    public KrillMeta fromJson(String json) throws QueryException {
        JsonNode jsonN;
        try {
            jsonN = new ObjectMapper().readValue(json, JsonNode.class);
        }
        catch (IOException e) {
            String msg = e.getMessage();
            log.warn("Unable to parse JSON: " + msg.split("\n")[0]);
            throw new QueryException(621, "Unable to parse JSON");
        }
        return this.fromJson(jsonN);
    }

    public KrillMeta fromJson(JsonNode json) {
        if (!json.has("@type") && json.has("meta")) {
            json = json.get("meta");
        }
        if (json.has("cutOff")) {
            this.setCutOff(json.get("cutOff").asBoolean());
        }
        if (json.has("count")) {
            this.setCount(json.get("count").asInt());
        }
        if (json.has("startIndex")) {
            this.setStartIndex(json.get("startIndex").asInt());
        }
        if (json.has("startPage")) {
            this.setStartPage(json.get("startPage").asInt());
        }
        if (json.has("timeout")) {
            this.setTimeOut(json.get("timeout").asLong());
        }
        if (json.has("itemsPerResource")) {
            this.setItemsPerResource(json.get("itemsPerResource").asInt());
        }
        if (json.has("snippets")) {
            this.snippets = json.get("snippets").asBoolean();
        }
        if (json.has("tokens")) {
            this.tokens = json.get("tokens").asBoolean();
        }
        if (json.has("context")) {
            this.context.fromJson(json.get("context"));
        }
        if (json.has("highlight")) {
            if (json.get("highlight").isArray()) {
                for (JsonNode highlight : json.get("highlight")) {
                    this.addHighlight(highlight.asInt());
                }
            } else {
                this.addHighlight(json.get("highlight").asInt());
            }
        }
        if (json.has("fields")) {
            this.fields.clear();
            if (json.get("fields").isArray()) {
                for (JsonNode field : json.get("fields")) {
                    this.addField(field.asText());
                }
            } else {
                this.addField(json.get("fields").asText());
            }
        }
        return this;
    }

    public short getCount() {
        return this.count;
    }

    public KrillMeta setCount(int value) {
        this.setCount((short)value);
        return this;
    }

    public KrillMeta setCount(short value) {
        if (value >= 0) {
            this.count = value <= this.countMax ? value : this.countMax;
        }
        return this;
    }

    public short getCountMax() {
        return this.countMax;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public KrillMeta setStartIndex(int value) {
        this.startIndex = value >= 0 ? value : 0;
        return this;
    }

    public KrillMeta setStartPage(int value) {
        if (value >= 0) {
            this.setStartIndex(value * this.getCount() - this.getCount());
        } else {
            this.startIndex = 0;
        }
        return this;
    }

    public long getTimeOut() {
        return this.timeout;
    }

    public void setTimeOut(long timeout) {
        this.timeout = timeout;
    }

    public KrillMeta setItemsPerResource(short value) {
        if (value >= 0) {
            this.itemsPerResource = value;
        }
        return this;
    }

    public KrillMeta setItemsPerResource(int value) {
        return this.setItemsPerResource((short)value);
    }

    public short getItemsPerResource() {
        return this.itemsPerResource;
    }

    public SearchContext getContext() {
        return this.context;
    }

    public KrillMeta setContext(SearchContext context) {
        this.context = context;
        return this;
    }

    public boolean hasSnippets() {
        return this.snippets;
    }

    public KrillMeta setSnippets(boolean snippets) {
        this.snippets = snippets;
        return this;
    }

    public boolean hasTokens() {
        return this.tokens;
    }

    public KrillMeta setTokens(boolean tokens) {
        this.tokens = tokens;
        return this;
    }

    public ArrayList<String> getFields() {
        return this.fields;
    }

    public KrillMeta addField(String field) {
        this.fields.add(field);
        return this;
    }

    public KrillMeta addHighlight(int classNumber) {
        this.highlights.add(classNumber);
        return this;
    }

    @Deprecated
    public boolean doCutOff() {
        return this.cutOff;
    }

    @Deprecated
    public KrillMeta setCutOff(boolean cutOff) {
        this.cutOff = cutOff;
        return this;
    }

    @Deprecated
    public int getLimit() {
        return this.limit;
    }

    @Deprecated
    public KrillMeta setLimit(int limit) {
        if (limit > 0) {
            this.limit = limit;
        }
        return this;
    }

    @Override
    public JsonNode toJsonNode() {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode json = mapper.createObjectNode();
        if (this.cutOff) {
            json.put("cutOff", this.doCutOff());
        }
        if (this.limit > 0) {
            json.put("limit", this.getLimit());
        }
        json.put("count", this.getCount());
        json.put("startIndex", this.getStartIndex());
        json.put("timeout", this.getTimeOut());
        json.set("context", this.getContext().toJsonNode());
        ArrayNode fieldNode = mapper.createArrayNode();
        Iterator<String> field = this.fields.iterator();
        while (field.hasNext()) {
            fieldNode.add(field.next());
        }
        json.set("fields", fieldNode);
        if (this.itemsPerResource > 0) {
            json.put("itemsPerResource", (int)this.getItemsPerResource());
        }
        if (!this.highlights.isEmpty()) {
            ArrayNode highlightNode = mapper.createArrayNode();
            highlightNode.addPOJO(this.highlights);
            json.set("highlight", highlightNode);
        }
        return json;
    }
}

