/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import opennlp.tools.cmdline.CmdLineUtil;

public class TrainingParameters {
    public static final String ALGORITHM_PARAM = "Algorithm";
    public static final String TRAINER_TYPE_PARAM = "TrainerType";
    public static final String ITERATIONS_PARAM = "Iterations";
    public static final String CUTOFF_PARAM = "Cutoff";
    public static final String THREADS_PARAM = "Threads";
    public static final int ITERATIONS_DEFAULT_VALUE = 100;
    public static final int CUTOFF_DEFAULT_VALUE = 5;
    private final Map<String, Object> parameters = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);

    public TrainingParameters() {
    }

    public TrainingParameters(TrainingParameters trainingParameters) {
        this.parameters.putAll(trainingParameters.parameters);
    }

    public TrainingParameters(Map<String, Object> map2) {
        this.parameters.putAll(map2);
    }

    public TrainingParameters(InputStream in) throws IOException {
        Properties properties = new Properties();
        properties.load(in);
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            this.parameters.put((String)entry.getKey(), entry.getValue());
        }
    }

    public String algorithm(String namespace) {
        return (String)this.parameters.get(TrainingParameters.getKey(namespace, ALGORITHM_PARAM));
    }

    public String algorithm() {
        return (String)this.parameters.get(ALGORITHM_PARAM);
    }

    private static String getStringValue(Object value) {
        if (value instanceof Integer) {
            return Integer.toString((Integer)value);
        }
        if (value instanceof Double) {
            return Double.toString((Double)value);
        }
        if (value instanceof Boolean) {
            return Boolean.toString((Boolean)value);
        }
        return (String)value;
    }

    public Map<String, Object> getObjectSettings(String namespace) {
        HashMap<String, Object> trainingParams = new HashMap<String, Object>();
        String prefix = namespace + ".";
        for (Map.Entry<String, Object> entry : this.parameters.entrySet()) {
            String key = entry.getKey();
            if (namespace != null) {
                if (!key.startsWith(prefix)) continue;
                trainingParams.put(key.substring(prefix.length()), entry.getValue());
                continue;
            }
            if (key.contains(".")) continue;
            trainingParams.put(key, entry.getValue());
        }
        return Collections.unmodifiableMap(trainingParams);
    }

    public Map<String, Object> getObjectSettings() {
        return this.getObjectSettings(null);
    }

    public TrainingParameters getParameters(String namespace) {
        TrainingParameters params = new TrainingParameters();
        Map<String, Object> settings = this.getObjectSettings(namespace);
        for (Map.Entry<String, Object> entry : settings.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Integer) {
                params.put(key, (Integer)value);
                continue;
            }
            if (value instanceof Double) {
                params.put(key, (Double)value);
                continue;
            }
            if (value instanceof Boolean) {
                params.put(key, (Boolean)value);
                continue;
            }
            params.put(key, (String)value);
        }
        return params;
    }

    public void putIfAbsent(String namespace, String key, String value) {
        this.parameters.putIfAbsent(TrainingParameters.getKey(namespace, key), value);
    }

    public void putIfAbsent(String key, String value) {
        this.putIfAbsent(null, key, value);
    }

    public void putIfAbsent(String namespace, String key, int value) {
        this.parameters.putIfAbsent(TrainingParameters.getKey(namespace, key), value);
    }

    public void putIfAbsent(String key, int value) {
        this.putIfAbsent((String)null, key, value);
    }

    public void putIfAbsent(String namespace, String key, double value) {
        this.parameters.putIfAbsent(TrainingParameters.getKey(namespace, key), value);
    }

    public void putIfAbsent(String key, double value) {
        this.putIfAbsent(null, key, value);
    }

    public void putIfAbsent(String namespace, String key, boolean value) {
        this.parameters.putIfAbsent(TrainingParameters.getKey(namespace, key), value);
    }

    public void putIfAbsent(String key, boolean value) {
        this.putIfAbsent(null, key, value);
    }

    public void put(String namespace, String key, String value) {
        this.parameters.put(TrainingParameters.getKey(namespace, key), value);
    }

    public void put(String key, String value) {
        this.put(null, key, value);
    }

    public void put(String namespace, String key, int value) {
        this.parameters.put(TrainingParameters.getKey(namespace, key), value);
    }

    public void put(String key, int value) {
        this.put((String)null, key, value);
    }

    public void put(String namespace, String key, double value) {
        this.parameters.put(TrainingParameters.getKey(namespace, key), value);
    }

    public void put(String key, double value) {
        this.put(null, key, value);
    }

    public void put(String namespace, String key, boolean value) {
        this.parameters.put(TrainingParameters.getKey(namespace, key), value);
    }

    public void put(String key, boolean value) {
        this.put(null, key, value);
    }

    public void serialize(OutputStream out) throws IOException {
        Properties properties = new Properties();
        properties.putAll(this.parameters);
        properties.store(out, null);
    }

    public String getStringParameter(String key, String defaultValue) {
        return this.getStringParameter(null, key, defaultValue);
    }

    public String getStringParameter(String namespace, String key, String defaultValue) {
        Object value = this.parameters.get(TrainingParameters.getKey(namespace, key));
        if (value == null) {
            return defaultValue;
        }
        return (String)value;
    }

    public int getIntParameter(String key, int defaultValue) {
        return this.getIntParameter(null, key, defaultValue);
    }

    public int getIntParameter(String namespace, String key, int defaultValue) {
        Object value = this.parameters.get(TrainingParameters.getKey(namespace, key));
        if (value == null) {
            return defaultValue;
        }
        try {
            return (Integer)value;
        }
        catch (ClassCastException e) {
            return Integer.parseInt((String)value);
        }
    }

    public double getDoubleParameter(String key, double defaultValue) {
        return this.getDoubleParameter(null, key, defaultValue);
    }

    public double getDoubleParameter(String namespace, String key, double defaultValue) {
        Object value = this.parameters.get(TrainingParameters.getKey(namespace, key));
        if (value == null) {
            return defaultValue;
        }
        try {
            return (Double)value;
        }
        catch (ClassCastException e) {
            return Double.parseDouble((String)value);
        }
    }

    public boolean getBooleanParameter(String key, boolean defaultValue) {
        return this.getBooleanParameter(null, key, defaultValue);
    }

    public boolean getBooleanParameter(String namespace, String key, boolean defaultValue) {
        Object value = this.parameters.get(TrainingParameters.getKey(namespace, key));
        if (value == null) {
            return defaultValue;
        }
        try {
            return (Boolean)value;
        }
        catch (ClassCastException e) {
            return Boolean.parseBoolean((String)value);
        }
    }

    public static TrainingParameters defaultParams() {
        TrainingParameters mlParams = new TrainingParameters();
        mlParams.put(ALGORITHM_PARAM, "MAXENT");
        mlParams.put(TRAINER_TYPE_PARAM, "Event");
        mlParams.put(ITERATIONS_PARAM, 100);
        mlParams.put(CUTOFF_PARAM, 5);
        return mlParams;
    }

    public static TrainingParameters setParams(String[] params) {
        TrainingParameters mlParams = new TrainingParameters();
        mlParams.put(ALGORITHM_PARAM, "MAXENT");
        mlParams.put(TRAINER_TYPE_PARAM, "Event");
        mlParams.put(ITERATIONS_PARAM, null != CmdLineUtil.getIntParameter("-" + ITERATIONS_PARAM.toLowerCase(), params) ? CmdLineUtil.getIntParameter("-" + ITERATIONS_PARAM.toLowerCase(), params) : 100);
        mlParams.put(CUTOFF_PARAM, null != CmdLineUtil.getIntParameter("-" + CUTOFF_PARAM.toLowerCase(), params) ? CmdLineUtil.getIntParameter("-" + CUTOFF_PARAM.toLowerCase(), params) : 5);
        return mlParams;
    }

    static String getKey(String namespace, String key) {
        if (namespace == null) {
            return key;
        }
        return namespace + "." + key;
    }
}

