/*
 * Decompiled with CFR 0.152.
 */
package marmot.util;

import java.util.LinkedList;
import java.util.List;

public class LevenshteinLattice {
    protected int[][] cost_lattice_;
    protected short[][] op_lattice_;
    protected static final short START = 1;
    protected static final short INSERT = 2;
    protected static final short DELETE = 4;
    protected static final short COPY = 8;
    protected static final short REPLACE = 16;
    protected String input_;
    protected String output_;
    protected int replace_cost_;
    protected int insert_cost_;
    protected int delete_cost_;
    private boolean initialized_;

    public LevenshteinLattice(String input, String output) {
        this(input, output, 1, 1, 2);
    }

    public LevenshteinLattice(String input, String output, int insert_cost, int delete_cost, int replace_cost) {
        this.input_ = input;
        this.output_ = output;
        this.replace_cost_ = replace_cost;
        this.insert_cost_ = insert_cost;
        this.delete_cost_ = delete_cost;
        this.initialized_ = false;
    }

    protected void init() {
        if (!this.initialized_) {
            this.fillLattice();
        }
        this.initialized_ = true;
    }

    protected int min(int a, int b, int c) {
        return Math.min(a, Math.min(b, c));
    }

    protected void fillLattice() {
        int input_index;
        int input_length = this.input_.length();
        int output_length = this.output_.length();
        this.cost_lattice_ = new int[input_length + 1][output_length + 1];
        this.op_lattice_ = new short[input_length + 1][output_length + 1];
        this.op_lattice_[0][0] = 1;
        for (input_index = 1; input_index <= input_length; ++input_index) {
            this.cost_lattice_[input_index][0] = this.delete_cost_ * input_index;
            this.op_lattice_[input_index][0] = 4;
        }
        for (int output_index = 1; output_index <= output_length; ++output_index) {
            this.cost_lattice_[0][output_index] = this.insert_cost_ * output_index;
            this.op_lattice_[0][output_index] = 2;
        }
        for (input_index = 1; input_index <= input_length; ++input_index) {
            char current_input = this.input_.charAt(input_index - 1);
            for (int output_index = 1; output_index <= output_length; ++output_index) {
                int minimal_cost;
                int diag_cost;
                int diag_op;
                char current_output = this.output_.charAt(output_index - 1);
                if (current_input == current_output) {
                    diag_op = 8;
                    diag_cost = this.getCopyCost(input_index);
                } else {
                    diag_op = 16;
                    diag_cost = this.getReplaceCost(current_input, current_output);
                }
                int minimal_diag_cost = this.cost_lattice_[input_index - 1][output_index - 1] + diag_cost;
                int minimal_delete_cost = this.cost_lattice_[input_index - 1][output_index] + this.delete_cost_;
                int minimal_insert_cost = this.cost_lattice_[input_index][output_index - 1] + this.insert_cost_;
                this.cost_lattice_[input_index][output_index] = minimal_cost = this.min(minimal_delete_cost, minimal_insert_cost, minimal_diag_cost);
                int minimal_cost_op = 0;
                if (minimal_cost == minimal_diag_cost) {
                    minimal_cost_op = (short)(minimal_cost_op | diag_op);
                }
                if (minimal_cost == minimal_delete_cost) {
                    minimal_cost_op = (short)(minimal_cost_op | 4);
                }
                if (minimal_cost == minimal_insert_cost) {
                    minimal_cost_op = (short)(minimal_cost_op | 2);
                }
                this.op_lattice_[input_index][output_index] = minimal_cost_op;
            }
        }
    }

    protected int getCopyCost(int input_index) {
        return 0;
    }

    protected int getReplaceCost(char input, char output) {
        return this.replace_cost_;
    }

    public String searchOperationSequence() {
        this.init();
        StringBuilder sb = new StringBuilder();
        int input_index = this.input_.length();
        int output_index = this.output_.length();
        boolean stop = false;
        while (!stop) {
            short op = this.op_lattice_[input_index][output_index];
            if ((op & 1) > 0) {
                stop = true;
                assert (op == 1);
                continue;
            }
            if ((op & 8) > 0) {
                sb.append('C');
                --output_index;
                --input_index;
                continue;
            }
            if ((op & 0x10) > 0) {
                sb.append('R');
                --output_index;
                --input_index;
                continue;
            }
            if ((op & 2) > 0) {
                sb.append('I');
                --output_index;
                continue;
            }
            if ((op & 4) > 0) {
                sb.append('D');
                --input_index;
                continue;
            }
            throw new RuntimeException("Unexpected operation code: " + Integer.toBinaryString(op));
        }
        sb.reverse();
        return sb.toString();
    }

    public List<List<Character>> searchOperationSequences(boolean remove_redundant) {
        this.init();
        int input_index = this.input_.length();
        int output_index = this.output_.length();
        List<List<Character>> lists = this.searchOperationSequences(input_index, output_index);
        if (remove_redundant) {
            lists.removeIf(this::redundant);
        }
        return lists;
    }

    public List<List<Character>> searchOperationSequences() {
        return this.searchOperationSequences(false);
    }

    public List<List<Character>> searchOperationSequences(int input_index, int output_index) {
        this.init();
        short op = this.op_lattice_[input_index][output_index];
        LinkedList<List<Character>> lists = new LinkedList<List<Character>>();
        if ((op & 1) > 0) {
            assert (op == 1);
            lists.add(new LinkedList());
        } else {
            if ((op & 8) > 0) {
                lists.addAll(this.appendToList(this.searchOperationSequences(input_index - 1, output_index - 1), 'C'));
            }
            if ((op & 0x10) > 0) {
                lists.addAll(this.appendToList(this.searchOperationSequences(input_index - 1, output_index - 1), 'R'));
            }
            if ((op & 2) > 0) {
                lists.addAll(this.appendToList(this.searchOperationSequences(input_index, output_index - 1), 'I'));
            }
            if ((op & 4) > 0) {
                lists.addAll(this.appendToList(this.searchOperationSequences(input_index - 1, output_index), 'D'));
            }
            if (lists.isEmpty()) {
                throw new RuntimeException("Unexpected operation code: " + Integer.toBinaryString(op));
            }
        }
        return lists;
    }

    protected List<List<Character>> appendToList(List<List<Character>> lists, char c) {
        for (List<Character> list : lists) {
            list.add(Character.valueOf(c));
        }
        return lists;
    }

    public int getDistance() {
        this.init();
        return this.cost_lattice_[this.input_.length()][this.output_.length()];
    }

    public boolean redundant(List<Character> seq) {
        int last_c = 83;
        for (char c : seq) {
            if (c == 'R' && last_c == 68) {
                return true;
            }
            if (c == 'R' && last_c == 73) {
                return true;
            }
            if (c == 'I' && last_c == 68) {
                return true;
            }
            if (c == 'D' && last_c == 73) {
                return true;
            }
            last_c = c;
        }
        return false;
    }
}

