/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.collection;

import de.ids_mannheim.korap.KrillCollection;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.BitsFilteredDocIdSet;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.BitDocIdSet;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.FixedBitSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BooleanGroupFilter
extends Filter {
    private boolean isOptional;
    private static final Logger log = LoggerFactory.getLogger(KrillCollection.class);
    public static final boolean DEBUG = false;
    private final List<GroupFilterOperand> operands = new ArrayList<GroupFilterOperand>(3);

    public BooleanGroupFilter(boolean optional) {
        this.isOptional = optional;
    }

    public final void with(Filter filter) {
        this.operands.add(new GroupFilterOperand(filter, false));
    }

    public final void without(Filter filter) {
        this.operands.add(new GroupFilterOperand(filter, true));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        BooleanGroupFilter other = (BooleanGroupFilter)obj;
        return this.operands.equals(other.operands);
    }

    public int hashCode() {
        return 0x272B5EB7 ^ this.operands.hashCode();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(this.isOptional ? "OrGroup(" : "AndGroup(");
        boolean first = true;
        for (GroupFilterOperand operand : this.operands) {
            if (first) {
                first = false;
            } else {
                buffer.append(" ");
            }
            if (operand.isNegative) {
                buffer.append('-');
            }
            buffer.append(operand.filter.toString());
        }
        return buffer.append(')').toString();
    }

    @Override
    public DocIdSet getDocIdSet(LeafReaderContext atomic, Bits acceptDocs) throws IOException {
        LeafReader reader = atomic.reader();
        int maxDoc = reader.maxDoc();
        FixedBitSet bitset = new FixedBitSet(maxDoc);
        FixedBitSet combinator = new FixedBitSet(maxDoc);
        boolean init = true;
        for (GroupFilterOperand operand : this.operands) {
            DocIdSetIterator filterIter;
            DocIdSet docids = operand.filter.getDocIdSet(atomic, null);
            DocIdSetIterator docIdSetIterator = filterIter = docids == null ? null : docids.iterator();
            if (filterIter == null) {
                if (operand.isNegative) {
                    if (this.isOptional) {
                        bitset.set(0, maxDoc);
                        return BitsFilteredDocIdSet.wrap(new BitDocIdSet(bitset), acceptDocs);
                    }
                    if (init) {
                        bitset.set(0, maxDoc);
                    }
                } else if (!this.isOptional) {
                    return null;
                }
            } else if (init) {
                bitset.or(filterIter);
                if (operand.isNegative) {
                    bitset.flip(0, maxDoc);
                }
            } else if (operand.isNegative) {
                if (this.isOptional) {
                    combinator.or(filterIter);
                    combinator.flip(0, maxDoc);
                    bitset.or(combinator);
                    combinator.clear(0, maxDoc);
                } else {
                    bitset.andNot(filterIter);
                }
            } else if (this.isOptional) {
                bitset.or(filterIter);
            } else {
                bitset.and(filterIter);
            }
            init = false;
        }
        return BitsFilteredDocIdSet.wrap(new BitDocIdSet(bitset), acceptDocs);
    }

    private class GroupFilterOperand {
        public Filter filter;
        public boolean isNegative;

        public GroupFilterOperand(Filter filter, boolean negative) {
            this.filter = filter;
            this.isNegative = negative;
        }
    }
}

