/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.query;

import de.ids_mannheim.korap.constants.RelationDirection;
import de.ids_mannheim.korap.query.SimpleSpanQuery;
import de.ids_mannheim.korap.query.spans.RelationSpans;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.ToStringUtils;

public class SpanRelationQuery
extends SimpleSpanQuery {
    private RelationDirection direction;
    private byte tempSourceNum = 1;
    private byte tempTargetNum = (byte)2;
    private byte sourceClass;
    private byte targetClass;
    private List<Byte> tempClassNumbers = Arrays.asList(this.tempSourceNum, this.tempTargetNum);

    public SpanRelationQuery(SpanQuery firstClause, boolean collectPayloads, RelationDirection direction) {
        super(firstClause, collectPayloads);
        this.direction = direction;
    }

    @Override
    public SimpleSpanQuery clone() {
        SpanRelationQuery sq = new SpanRelationQuery((SpanQuery)this.firstClause.clone(), this.collectPayloads, this.direction);
        return sq;
    }

    @Override
    public Spans getSpans(LeafReaderContext context, Bits acceptDocs, Map<Term, TermContext> termContexts) throws IOException {
        return new RelationSpans(this, context, acceptDocs, termContexts);
    }

    @Override
    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        if (this.sourceClass > 0) {
            sb.append("{");
            sb.append(this.sourceClass);
            sb.append(": source:");
        }
        if (this.targetClass > 0) {
            sb.append("{");
            sb.append(this.targetClass);
            sb.append(": target:");
        }
        sb.append("spanRelation(");
        sb.append(this.firstClause.toString(field));
        sb.append(")");
        if (this.sourceClass > 0) {
            sb.append("}");
        }
        if (this.targetClass > 0) {
            sb.append("}");
        }
        sb.append(ToStringUtils.boost(this.getBoost()));
        return sb.toString();
    }

    public RelationDirection getDirection() {
        return this.direction;
    }

    public void setDirection(RelationDirection direction) {
        this.direction = direction;
    }

    public List<Byte> getTempClassNumbers() {
        return this.tempClassNumbers;
    }

    public void setTempClassNumbers(List<Byte> classNumbers) {
        this.tempClassNumbers = classNumbers;
    }

    public byte getTempSourceNum() {
        return this.tempSourceNum;
    }

    public void setTempSourceNum(byte sourceNum) {
        this.tempSourceNum = sourceNum;
    }

    public byte getTempTargetNum() {
        return this.tempTargetNum;
    }

    public void setTempTargetNum(byte targetNum) {
        this.tempTargetNum = targetNum;
    }

    public byte getSourceClass() {
        return this.sourceClass;
    }

    public void setSourceClass(byte sourceClass) throws IllegalArgumentException {
        if (sourceClass < 1) {
            throw new IllegalArgumentException("Class number must be bigger than 0.");
        }
        this.sourceClass = sourceClass;
    }

    public byte getTargetClass() {
        return this.targetClass;
    }

    public void setTargetClass(byte targetClass) throws IllegalArgumentException {
        if (targetClass < 1) {
            throw new IllegalArgumentException("Class number must be bigger than 0.");
        }
        this.targetClass = targetClass;
    }
}

