/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.watch;

import com.saxonica.ee.stream.ManualGroupIterator;
import com.saxonica.ee.stream.adjunct.FeedToEventBuffer;
import com.saxonica.ee.stream.feed.FilteringFeed;
import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.feed.NoCloseFeed;
import com.saxonica.ee.stream.feed.NoOpenOrCloseFeed;
import com.saxonica.ee.stream.om.FleetingParentNode;
import com.saxonica.ee.stream.watch.ForEachAction;
import com.saxonica.ee.stream.watch.Terminator;
import com.saxonica.ee.stream.watch.Trigger;
import com.saxonica.ee.stream.watch.Watch;
import com.saxonica.ee.stream.watch.WatchManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.TeeOutputter;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.expr.instruct.ForEachGroup;
import net.sf.saxon.expr.sort.AtomicMatchKey;
import net.sf.saxon.expr.sort.CompositeAtomicKey;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.AtomicArray;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.pattern.AncestorQualifiedPattern;
import net.sf.saxon.pattern.AnchorPattern;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ManualIterator;
import net.sf.saxon.value.AtomicValue;

public class ForEachGroupParallelAction
extends ForEachAction {
    private final HashMap<CompositeAtomicKey, GroupInfo> groups = new HashMap();
    private final List<GroupInfo> groupList = new ArrayList<GroupInfo>();
    private int groupSequence = 1;
    private final XPathContext populationContext;
    private final StringCollator collator;
    private final int implicitTimezone;
    private ItemFeed currentItemFeed;
    private final boolean compositeKeys;
    private NodeInfo anchorNode;

    public ForEachGroupParallelAction(WatchManager watchManager, ForEachGroup expression, ItemFeed result, XPathContext context) {
        super(watchManager, expression, result, context);
        this.populationContext = context.newMinorContext();
        this.collator = expression.getCollation();
        this.implicitTimezone = context.getImplicitTimezone();
        this.compositeKeys = expression.isComposite();
    }

    @Override
    public void open(Terminator terminator) throws XPathException {
        super.open(terminator);
        this.populationContext.setCurrentIterator(new ManualIterator());
    }

    private AtomicArray getGroupingKey(Item node, List<AtomicMatchKey> comparisonKey) throws XPathException {
        if (this.currentItemFeed != null) {
            throw new XPathException("xsl:for-each-group can't handle overlapping (crawling) nodes");
        }
        ManualIterator popIter = (ManualIterator)this.populationContext.getCurrentIterator();
        popIter.setContextItem(node);
        popIter.incrementPosition();
        Expression groupingKey = ((ForEachGroup)this.getExpression()).getGroupingKey();
        SequenceIterator iter = groupingKey.iterate(this.populationContext);
        AtomicArray key = new AtomicArray(iter);
        for (AtomicValue val : key) {
            comparisonKey.add(val.getXPathMatchKey(this.collator, this.implicitTimezone));
        }
        return key;
    }

    @Override
    public Receiver startSelectedParentNode(FleetingParentNode node, Location locationId) throws XPathException {
        ArrayList<CompositeAtomicKey> separateKeys;
        ArrayList<AtomicMatchKey> comparisonKeyParts = new ArrayList<AtomicMatchKey>();
        AtomicArray key = this.getGroupingKey(node, comparisonKeyParts);
        this.anchorNode = node;
        ArrayList<AtomicValue> distinctKeys = null;
        if (this.compositeKeys) {
            separateKeys = new ArrayList<CompositeAtomicKey>(1);
            separateKeys.add(new CompositeAtomicKey(comparisonKeyParts));
        } else {
            separateKeys = new ArrayList(comparisonKeyParts.size());
            distinctKeys = new ArrayList<AtomicValue>();
            HashSet<AtomicMatchKey> duplicates = new HashSet<AtomicMatchKey>();
            int kk = 0;
            for (AtomicMatchKey oneKey : comparisonKeyParts) {
                if (duplicates.add(oneKey)) {
                    ArrayList<AtomicMatchKey> singleKey = new ArrayList<AtomicMatchKey>(1);
                    singleKey.add(oneKey);
                    separateKeys.add(new CompositeAtomicKey(singleKey));
                    distinctKeys.add(key.itemAt(kk));
                }
                ++kk;
            }
        }
        Receiver result = null;
        ArrayList<ItemFeed> groupFeeds = new ArrayList<ItemFeed>();
        int k = 0;
        for (CompositeAtomicKey groupingKey : separateKeys) {
            WatchManager.GroupingScope scope;
            boolean newGroup;
            GroupInfo gp;
            block18: {
                block14: {
                    block17: {
                        block15: {
                            ItemFeed actionFeed;
                            Pattern pattern;
                            Trigger watch;
                            block16: {
                                AtomicArray actualKey = this.compositeKeys ? key : (AtomicSequence)distinctKeys.get(k++);
                                gp = this.groups.get(groupingKey);
                                newGroup = gp == null;
                                scope = this.getWatchManager().startGroupingScope();
                                this.getWatchManager().startCapturingGroupingWatches(scope);
                                if (newGroup) {
                                    gp = this.makeNewGroup(node, groupingKey, actualKey);
                                } else {
                                    ((ManualGroupIterator)gp.bodyContext.getCurrentGroupIterator()).appendToCurrentGroup(node);
                                }
                                gp.scope = scope;
                                if (!this.isActionConsuming()) break block14;
                                if (!newGroup) break block15;
                                FeedToEventBuffer toOutputter = gp.outputter;
                                NoOpenOrCloseFeed thisFeed = new NoOpenOrCloseFeed(toOutputter, gp.bodyContext);
                                watch = this.getInversion().getWatch(this.getWatchManager(), thisFeed, gp.bodyContext);
                                pattern = watch.getSelection();
                                actionFeed = watch.getAction();
                                if (!(pattern instanceof AnchorPattern)) break block16;
                                gp.feed = actionFeed;
                                gp.feed.open(this.getTerminator());
                                break block17;
                            }
                            FilteringFeed.FilterLambda filter = new FilteringFeed.FilterLambda((item, position) -> pattern.matchesBeneathAnchor((NodeInfo)item, this.anchorNode, this.bodyContext) ? FilteringFeed.FilterResult.MATCHES : FilteringFeed.FilterResult.SKIP);
                            gp.feed = new FilteringFeed(this.watchManager, actionFeed, this.getContext(), filter);
                            if (!(pattern instanceof AncestorQualifiedPattern)) break block17;
                            this.getWatchManager().addWatch(watch, true);
                            gp.feed = new NoCloseFeed(gp.feed, this.getContext());
                            break block17;
                        }
                        if (gp.watchList != null) {
                            for (Watch w : gp.watchList) {
                                w.setAnchorNode(node);
                            }
                        }
                    }
                    groupFeeds.add(gp.feed);
                    break block18;
                }
                if (newGroup) {
                    Expression action = ((ForEachGroup)this.getExpression()).getActionExpression();
                    FeedToEventBuffer out = gp.outputter;
                    action.process(out, gp.bodyContext);
                }
            }
            if (newGroup) {
                gp.watchList = gp.scope.watches;
            }
            this.getWatchManager().stopCapturingGroupingWatches(scope);
        }
        if (!groupFeeds.isEmpty()) {
            if (groupFeeds.size() == 1) {
                this.currentItemFeed = (ItemFeed)groupFeeds.get(0);
                result = this.currentItemFeed.startSelectedParentNode(node, locationId);
            } else {
                this.currentItemFeed = new ForkingFeed(groupFeeds, this.getResultFeed(), this.getContext());
                result = this.currentItemFeed.startSelectedParentNode(node, locationId);
            }
        }
        return result;
    }

    private GroupInfo makeNewGroup(Item node, CompositeAtomicKey comparisonKey, AtomicSequence key) {
        GroupInfo gp = new GroupInfo();
        gp.outputter = new FeedToEventBuffer(this.getNextOutputter(), (ItemFeed)this, this.getContext());
        gp.outputter.setPipelineConfiguration(this.getPipelineConfiguration());
        XPathContextMajor bodyContext = XPathContextMajor.newThreadContext((XPathContextMinor)this.getContext());
        ManualGroupIterator mgi = new ManualGroupIterator(node, this.groupSequence++);
        mgi.setCurrentGroupingKey(key);
        mgi.startNewCurrentGroup(node);
        bodyContext.setCurrentIterator(mgi);
        bodyContext.setCurrentGroupIterator(mgi);
        gp.bodyContext = bodyContext;
        this.groups.put(comparisonKey, gp);
        this.groupList.add(gp);
        return gp;
    }

    @Override
    public void append(Item node) throws XPathException {
        ArrayList<CompositeAtomicKey> separateKeys;
        ArrayList<AtomicMatchKey> comparisonKeyParts = new ArrayList<AtomicMatchKey>();
        AtomicArray key = this.getGroupingKey(node, comparisonKeyParts);
        if (this.compositeKeys) {
            separateKeys = new ArrayList<CompositeAtomicKey>(1);
            separateKeys.add(new CompositeAtomicKey(comparisonKeyParts));
        } else {
            separateKeys = new ArrayList(comparisonKeyParts.size());
            HashSet<AtomicMatchKey> duplicates = new HashSet<AtomicMatchKey>();
            for (AtomicMatchKey oneKey : comparisonKeyParts) {
                if (!duplicates.add(oneKey)) continue;
                ArrayList<AtomicMatchKey> singleKey = new ArrayList<AtomicMatchKey>(1);
                singleKey.add(oneKey);
                separateKeys.add(new CompositeAtomicKey(singleKey));
            }
        }
        int k = 0;
        for (CompositeAtomicKey groupingKey : separateKeys) {
            boolean newGroup;
            AtomicArray actualKey = this.compositeKeys ? key : key.itemAt(k++);
            GroupInfo gp = this.groups.get(groupingKey);
            boolean bl = newGroup = gp == null;
            if (newGroup) {
                gp = this.makeNewGroup(node, groupingKey, actualKey);
            }
            if (this.isActionConsuming()) {
                if (newGroup) {
                    NoOpenOrCloseFeed thisFeed = new NoOpenOrCloseFeed(this.getResultFeed(), this.getBodyContext());
                    Trigger watch = this.getInversion().getWatch(this.getWatchManager(), thisFeed, gp.bodyContext);
                    gp.feed = watch.getAction();
                    gp.feed.open(this.getTerminator());
                }
                gp.feed.append(node);
                continue;
            }
            if (!newGroup) continue;
            Expression action = ((ForEachGroup)this.getExpression()).getActionExpression();
            SequenceTool.supply(action.iterate(gp.bodyContext), item -> this.getResultFeed().append(item));
        }
    }

    @Override
    public void endSelectedParentNode(Location locationId) throws XPathException {
        if (this.isActionConsuming()) {
            this.currentItemFeed.endSelectedParentNode(locationId);
            this.currentItemFeed = null;
        }
    }

    @Override
    public void close() throws XPathException {
        for (GroupInfo gp : this.groupList) {
            if (gp.watchList != null) {
                for (Watch w : gp.watchList) {
                    w.close();
                }
            }
            if (gp.feed != null) {
                gp.feed.close();
            }
            FeedToEventBuffer out = gp.outputter;
            out.replay(this.getNextOutputter());
        }
        super.close();
    }

    private static class ForkingFeed
    extends ItemFeed {
        private final List<ItemFeed> prongs;

        public ForkingFeed(List<ItemFeed> prongs, ItemFeed result, XPathContext context) {
            super(result, context);
            this.prongs = prongs;
        }

        @Override
        public void close() throws XPathException {
            for (ItemFeed prong : this.prongs) {
                prong.close();
            }
        }

        @Override
        public PipelineConfiguration getPipelineConfiguration() {
            return null;
        }

        @Override
        public void open(Terminator terminator) throws XPathException {
            for (ItemFeed prong : this.prongs) {
                prong.open(terminator);
            }
        }

        @Override
        public Receiver startSelectedParentNode(FleetingParentNode node, Location locationId) throws XPathException {
            Receiver result = null;
            for (ItemFeed prong : this.prongs) {
                Receiver r = prong.startSelectedParentNode(node, locationId);
                if (r == null) continue;
                result = result == null ? r : new TeeOutputter(result, r);
            }
            return result;
        }

        @Override
        public void endSelectedParentNode(Location locationId) throws XPathException {
            for (ItemFeed prong : this.prongs) {
                prong.endSelectedParentNode(locationId);
            }
        }

        @Override
        public void append(Item item) throws XPathException {
            for (ItemFeed prong : this.prongs) {
                prong.append(item);
            }
        }
    }

    private static class GroupInfo {
        public XPathContext bodyContext;
        public ItemFeed feed;
        public FeedToEventBuffer outputter;
        public List<Watch> watchList;
        public WatchManager.GroupingScope scope;

        private GroupInfo() {
        }
    }
}

