/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.collection;

import de.ids_mannheim.korap.IndexInfo;
import de.ids_mannheim.korap.KrillCollection;
import de.ids_mannheim.korap.collection.BooleanGroupFilter;
import de.ids_mannheim.korap.collection.VirtualCorpusFilter;
import de.ids_mannheim.korap.index.TextPrependedTokenStream;
import de.ids_mannheim.korap.util.KrillDate;
import de.ids_mannheim.korap.util.QueryException;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.queries.TermsFilter;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.NumericRangeFilter;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.QueryWrapperFilter;
import org.apache.lucene.search.RegexpQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionBuilder {
    private static final Logger log = LoggerFactory.getLogger(KrillCollection.class);
    public static final boolean DEBUG = false;
    protected IndexInfo indexInfo;

    public CollectionBuilder() {
    }

    public CollectionBuilder(IndexInfo indexInfo) {
        this.indexInfo = indexInfo;
    }

    public Interface term(String field, String term) {
        return new Term(field, term);
    }

    public Interface re(String field, String term) {
        return new Term(field, term, true);
    }

    public Interface text(String field, String text) {
        return new Text(field, text);
    }

    public Interface since(String field, String date) {
        int since = new KrillDate(date).floor();
        if (since == 0 || since == 0) {
            return null;
        }
        return new Range(field, since, 99999999);
    }

    public Interface nothing() {
        return new Term("0---", "0");
    }

    public Interface till(String field, String date) {
        try {
            int till = new KrillDate(date).ceil();
            if (till == 0 || till == 99999999) {
                return null;
            }
            return new Range(field, 0, till);
        }
        catch (NumberFormatException e) {
            log.warn("Parameter of till(date) is invalid");
            return null;
        }
    }

    public Interface between(String field, String start, String end) {
        Interface startObj = this.since(field, start);
        if (startObj == null) {
            return null;
        }
        Interface endObj = this.till(field, end);
        if (endObj == null) {
            return null;
        }
        return this.andGroup().with(startObj).with(endObj);
    }

    public Interface date(String field, String date) {
        KrillDate dateDF = new KrillDate(date);
        if (dateDF.year == 0) {
            return null;
        }
        if (dateDF.day == 0 || dateDF.month == 0) {
            int begin = dateDF.floor();
            int end = dateDF.ceil();
            if (end == 0 || begin == 0 && end == 99999999) {
                return null;
            }
            return new Range(field, begin, end);
        }
        return new Range(field, dateDF.floor(), dateDF.ceil());
    }

    public Interface referTo(String reference) {
        return new VirtualCorpusReference(reference);
    }

    public Group andGroup() {
        return new Group(false);
    }

    public Group orGroup() {
        return new Group(true);
    }

    public class Term
    implements Interface {
        private boolean isNegative = false;
        private boolean regex = false;
        private String field;
        private String term;

        public Term(String field, String term) {
            this.field = field;
            this.term = term;
        }

        public Term(String field, String term, boolean regex) {
            this.field = field;
            this.term = term;
            this.regex = regex;
        }

        @Override
        public Filter toFilter() {
            if (this.regex) {
                return new QueryWrapperFilter(new RegexpQuery(new org.apache.lucene.index.Term(this.field, this.term)));
            }
            return new TermsFilter(new org.apache.lucene.index.Term(this.field, this.term));
        }

        @Override
        public String toString() {
            Filter filter = this.toFilter();
            if (filter == null) {
                return "";
            }
            return filter.toString();
        }

        @Override
        public boolean isNegative() {
            return this.isNegative;
        }

        @Override
        public Interface not() {
            this.isNegative = true;
            return this;
        }
    }

    public class Text
    implements Interface {
        private boolean isNegative = false;
        private String field;
        private String text;

        public Text(String field, String text) {
            this.field = field;
            this.text = text;
        }

        @Override
        public Filter toFilter() {
            PhraseQuery pq = new PhraseQuery();
            int pos = 0;
            try {
                TextPrependedTokenStream tpts = new TextPrependedTokenStream(this.text);
                tpts.doNotPrepend();
                tpts.reset();
                while (tpts.incrementToken()) {
                    CharTermAttribute term = tpts.getAttribute(CharTermAttribute.class);
                    pq.add(new org.apache.lucene.index.Term(this.field, term.toString()), pos++);
                }
                tpts.close();
            }
            catch (IOException ie) {
                System.err.println(ie);
                return null;
            }
            return new QueryWrapperFilter(pq);
        }

        @Override
        public String toString() {
            Filter filter = this.toFilter();
            if (filter == null) {
                return "";
            }
            return filter.toString();
        }

        @Override
        public boolean isNegative() {
            return this.isNegative;
        }

        @Override
        public Interface not() {
            this.isNegative = true;
            return this;
        }
    }

    public class Range
    implements Interface {
        private boolean isNegative = false;
        private String field;
        private int start;
        private int end;

        public Range(String field, int start, int end) {
            this.field = field;
            this.start = start;
            this.end = end;
        }

        @Override
        public boolean isNegative() {
            return this.isNegative;
        }

        @Override
        public String toString() {
            Filter filter = this.toFilter();
            if (filter == null) {
                return "";
            }
            return filter.toString();
        }

        @Override
        public Filter toFilter() {
            return NumericRangeFilter.newIntRange(this.field, this.start, this.end, true, true);
        }

        @Override
        public Interface not() {
            this.isNegative = true;
            return this;
        }
    }

    public static interface Interface {
        public String toString();

        public Filter toFilter() throws QueryException;

        public boolean isNegative();

        public Interface not();
    }

    public class Group
    implements Interface {
        private boolean isOptional = false;
        private boolean isNegative = false;
        private ArrayList<Interface> operands;

        @Override
        public boolean isNegative() {
            return this.isNegative;
        }

        public void setNegative(boolean isNegative) {
            this.isNegative = isNegative;
        }

        public boolean isOptional() {
            return this.isOptional;
        }

        public Group(boolean optional) {
            this.isOptional = optional;
            this.operands = new ArrayList(3);
        }

        public Group with(Interface cb) {
            if (cb == null) {
                return this;
            }
            this.operands.add(cb);
            return this;
        }

        public Group with(String field, String term) {
            if (field == null || term == null) {
                return this;
            }
            return this.with(new Term(field, term));
        }

        @Override
        public Filter toFilter() throws QueryException {
            if (this.operands == null || this.operands.isEmpty()) {
                return null;
            }
            if (this.operands.size() == 1) {
                return this.operands.get(0).toFilter();
            }
            BooleanGroupFilter bool = new BooleanGroupFilter(this.isOptional);
            for (Interface cb : this.operands) {
                if (cb.isNegative()) {
                    bool.without(cb.toFilter());
                    continue;
                }
                bool.with(cb.toFilter());
            }
            return bool;
        }

        @Override
        public String toString() {
            try {
                Filter filter = this.toFilter();
                if (filter == null) {
                    return "";
                }
                return filter.toString();
            }
            catch (QueryException qe) {
                log.warn(qe.getLocalizedMessage());
                return "";
            }
        }

        @Override
        public Interface not() {
            this.isNegative = true;
            return this;
        }
    }

    public class VirtualCorpusReference
    implements Interface {
        private boolean isNegative = false;
        private String vcId;
        private VirtualCorpusFilter vcFilter;

        public VirtualCorpusReference(String vcId) {
            this.vcId = vcId;
            this.vcFilter = new VirtualCorpusFilter(vcId);
        }

        @Override
        public Filter toFilter() throws QueryException {
            return this.vcFilter;
        }

        @Override
        public String toString() {
            return "referTo(" + this.vcId + ")";
        }

        @Override
        public boolean isNegative() {
            return this.isNegative;
        }

        @Override
        public Interface not() {
            this.isNegative = true;
            return this;
        }
    }
}

