/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KrillProperties {
    public static final String defaultPropertiesLocation = "krill.properties";
    public static final String defaultInfoLocation = "krill.info";
    private static Properties prop;
    private static Properties info;
    private static final Logger log;

    public static Properties loadDefaultProperties() {
        if (prop != null) {
            return prop;
        }
        prop = KrillProperties.loadProperties(defaultPropertiesLocation);
        return prop;
    }

    public static Properties loadProperties(String propFile) {
        if (propFile == null) {
            return KrillProperties.loadDefaultProperties();
        }
        try {
            FileInputStream iFile = new FileInputStream(propFile);
            prop = new Properties();
            prop.load(iFile);
        }
        catch (IOException t) {
            try {
                InputStream iFile = KrillProperties.class.getClassLoader().getResourceAsStream(propFile);
                if (iFile == null) {
                    log.warn("Cannot find {}. Please create it using \"src/main/resources/krill.properties.info\" as template.", (Object)propFile, (Object)propFile);
                    return null;
                }
                prop = new Properties();
                prop.load(iFile);
                iFile.close();
            }
            catch (IOException e) {
                log.error(e.getLocalizedMessage());
                return null;
            }
        }
        return prop;
    }

    public static Properties loadInfo() {
        try {
            info = new Properties();
            InputStream iFile = KrillProperties.class.getClassLoader().getResourceAsStream(defaultInfoLocation);
            if (iFile == null) {
                log.error("Cannot find {}.", (Object)defaultInfoLocation);
                return null;
            }
            info.load(iFile);
            iFile.close();
        }
        catch (IOException e) {
            log.error(e.getLocalizedMessage());
            return null;
        }
        return info;
    }

    public static void setProp(Properties prop) {
        KrillProperties.prop = prop;
    }

    static {
        log = LoggerFactory.getLogger(KrillProperties.class);
    }
}

