/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema.sdoc;

import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.SingleNamespaceSchema;
import com.saxonica.ee.schema.UserComplexType;
import com.saxonica.ee.schema.Wildcard;
import com.saxonica.ee.schema.sdoc.SchemaNodeFactory;
import com.saxonica.ee.schema.sdoc.SimpleTypeDefinition;
import com.saxonica.ee.schema.sdoc.XSDComplexType;
import com.saxonica.ee.schema.sdoc.XSDOverride;
import com.saxonica.ee.schema.sdoc.XSDRedefine;
import com.saxonica.ee.schema.sdoc.XSDSchema;
import com.saxonica.ee.schema.sdoc.XSDSimpleType;
import java.util.Arrays;
import java.util.StringTokenizer;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.functions.registry.ConstructorFunctionLibrary;
import net.sf.saxon.functions.registry.XPath20FunctionSet;
import net.sf.saxon.lib.ErrorReporter;
import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeSelector;
import net.sf.saxon.str.StringView;
import net.sf.saxon.sxpath.IndependentContext;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.XmlProcessingException;
import net.sf.saxon.trans.XmlProcessingIncident;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.linked.ElementImpl;
import net.sf.saxon.tree.linked.NodeImpl;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.Whitespace;

public abstract class SchemaElement
extends ElementImpl {
    private SchemaNodeFactory factory;
    public static final int USE_DEFAULT_NS = 0;
    public static final int REQUIRE_TARGET_NS = 1;
    public static final int REQUIRE_NULL_NS = 2;
    public static final int USE_DEFAULT_NS_WITHOUT_IMPORT = 3;
    protected static final String NAMESPACE_ANY = "##any";
    protected static final String NAMESPACE_LOCAL = "##local";
    protected static final String NAMESPACE_OTHER = "##other";
    protected static final String NAMESPACE_TARGET = "##targetNamespace";

    protected boolean isTopLevel() {
        NodeImpl parent = this.getParent();
        return parent instanceof XSDSchema || parent instanceof XSDRedefine || parent instanceof XSDOverride;
    }

    public void setSchemaNodeFactory(SchemaNodeFactory factory) {
        this.factory = factory;
    }

    public SchemaNodeFactory getSchemaNodeFactory() {
        return this.factory;
    }

    public void processAllAttributes() throws SchemaException {
        this.prepareAttributes();
        for (NodeInfo nodeInfo : this.children(NodeSelector.of(SchemaElement.class::isInstance))) {
            ((SchemaElement)nodeInfo).processAllAttributes();
        }
    }

    protected abstract void prepareAttributes() throws SchemaException;

    public void allowAttributes(AttributeMap atts, String[] allowed) throws SchemaException {
        for (AttributeInfo att : atts) {
            NodeName attName = att.getNodeName();
            if (attName.hasURI(NamespaceUri.NULL)) {
                if (Arrays.binarySearch(allowed, attName.getLocalPart()) >= 0) continue;
                this.error("Attribute " + Err.wrap(attName.getLocalPart(), 2) + " is not allowed on element " + Err.wrap(this.getDisplayName(), 1));
                continue;
            }
            if (!attName.hasURI(NamespaceUri.SCHEMA)) continue;
            this.error("Attributes in the XML Schema namespace are not allowed");
        }
    }

    public void requireAttribute(AttributeMap atts, String required) throws SchemaException {
        if (atts.getValue(NamespaceUri.NULL, required) == null) {
            this.missingAttribute(required);
        }
    }

    public void validateSubtree(SchemaCompiler compiler) throws SchemaException {
        this.checkNoTextNodes();
        this.validate(compiler);
        this.validateChildren(compiler);
        this.postValidate(compiler);
    }

    private void checkNoTextNodes() throws SchemaException {
        SchemaElement prev = this;
        for (NodeInfo nodeInfo : this.children()) {
            if (nodeInfo instanceof SchemaElement) {
                prev = (SchemaElement)nodeInfo;
            }
            if (nodeInfo.getNodeKind() != 3) continue;
            prev.error("Character data is not allowed as a child of " + Err.wrap(this.getDisplayName()));
        }
    }

    protected void validateChildren(SchemaCompiler compiler) throws SchemaException {
        for (NodeInfo nodeInfo : this.children(NodeSelector.of(SchemaElement.class::isInstance))) {
            ((SchemaElement)nodeInfo).validateSubtree(compiler);
        }
    }

    public void validate(SchemaCompiler compiler) throws SchemaException {
    }

    public void postValidate(SchemaCompiler compiler) throws SchemaException {
    }

    public XSDSchema getXSDSchema() throws SchemaException {
        NodeInfo n = this;
        do {
            if (!(n instanceof XSDSchema)) continue;
            return (XSDSchema)n;
        } while ((n = n.getParent()) != null);
        throw new SchemaException("Node does not have an xs:schema ancestor");
    }

    public SingleNamespaceSchema getSchema() throws SchemaException {
        return this.getXSDSchema().getSchema();
    }

    protected UserComplexType getContainingComplexType() throws SchemaException {
        NodeInfo parent = this.getParent();
        while (!(parent instanceof XSDComplexType)) {
            if (parent == null) {
                throw new SchemaException("Found " + Err.wrap(this.getDisplayName(), 1) + " with no xs:complexType ancestor");
            }
            parent = parent.getParent();
        }
        return ((XSDComplexType)parent).getComplexType();
    }

    protected SimpleTypeDefinition getContainingSimpleType() throws SchemaException {
        NodeInfo parent = this.getParent();
        while (!(parent instanceof XSDSimpleType)) {
            if (parent == null) {
                throw new SchemaException("Found " + Err.wrap(this.getDisplayName()) + " with no xs:simpleType ancestor");
            }
            parent = parent.getParent();
        }
        return ((XSDSimpleType)parent).getSimpleTypeDefinition();
    }

    protected NamespaceResolver makeNamespaceContext() {
        return this.getAllNamespaces();
    }

    public void checkPermittedType(int fp, String name, String role) throws SchemaException {
        if (fp == 634 || fp == 633) {
            if (this.getConfiguration().getXsdVersion() == 10) {
                this.warning("Type " + name + " is recognized by Saxon but is not interoperable");
            }
        } else if (fp == 565) {
            if (this.getConfiguration().getXsdVersion() == 10) {
                this.error("Type xs:dateTimeStamp requires XSD 1.1 support to be enabled");
            }
        } else if (fp == 631 || fp == 630) {
            this.error("Type " + name + " cannot be used as " + role);
        } else if (fp == 632 && this.getConfiguration().getXsdVersion() == 10) {
            this.error("Type xs:anyAtomicType requires XSD 1.1 support to be enabled");
        }
    }

    public boolean parseBooleanAttribute(String name, String value) throws SchemaException {
        if ((value = Whitespace.trim(value)).equals("true") || value.equals("1")) {
            return true;
        }
        if (value.equals("false") || value.equals("0")) {
            return false;
        }
        this.invalidAttributeValue(name, value, "Must be true(1) or false(0)");
        return false;
    }

    protected void error(String err) throws SchemaException {
        ErrorReporter reporter = this.getSchemaNodeFactory().getPipelineConfiguration().getErrorReporter();
        try {
            this.getXSDSchema().incrementErrorCount();
        }
        catch (SchemaException e2) {
            throw new IllegalStateException("Schema document contains no xs:schema element. Problem occurred while reporting error: " + e2.getMessage());
        }
        if (reporter != null) {
            XmlProcessingIncident incident = new XmlProcessingIncident(err, "SXSQ0001", this);
            reporter.report(incident);
            if (incident.getTerminationMessage() != null) {
                throw new SchemaException(incident.getTerminationMessage());
            }
        }
    }

    protected void error(SchemaException exception) throws SchemaException {
        ErrorReporter reporter = this.getSchemaNodeFactory().getPipelineConfiguration().getErrorReporter();
        try {
            this.getXSDSchema().incrementErrorCount();
        }
        catch (SchemaException e2) {
            throw new IllegalStateException("Schema document contains no xs:schema element. Problem occurred while reporting error: " + exception.getMessage());
        }
        if (reporter != null) {
            XmlProcessingException incident = new XmlProcessingException(exception);
            reporter.report(incident);
            if (incident.getTerminationMessage() != null) {
                throw new SchemaException(incident.getTerminationMessage());
            }
        } else {
            throw exception;
        }
    }

    protected void warning(String err) throws SchemaException {
        XmlProcessingIncident exception = new XmlProcessingIncident(err, "SXWN9018", this).asWarning();
        ErrorReporter reporter = this.getSchemaNodeFactory().getPipelineConfiguration().getErrorReporter();
        reporter.report(exception);
        if (exception.getTerminationMessage() != null) {
            throw new SchemaException(exception.getTerminationMessage());
        }
    }

    protected int getFingerprint(String name, int option) throws SchemaException {
        StructuredQName qname = this.getComponentName(name, option);
        return this.getNamePool().allocateFingerprint(qname.getNamespaceUri(), qname.getLocalPart());
    }

    protected StructuredQName getComponentName(String name, int option) throws SchemaException {
        try {
            XSDSchema root = this.getXSDSchema();
            String[] parts = NameChecker.getQNameParts(Whitespace.trim(name));
            NamespaceUri uri = null;
            if (parts[0].isEmpty()) {
                if (option == 0 || option == 3) {
                    uri = this.getURIForPrefix("", true);
                    if (uri == NamespaceUri.NULL && root.isChameleon()) {
                        uri = root.getTargetNamespace();
                    }
                } else if (option == 1) {
                    String target = this.getAttributeValue(NamespaceUri.NULL, "targetNamespace");
                    uri = target == null ? root.getTargetNamespace() : NamespaceUri.of(target);
                } else if (option == 2) {
                    uri = NamespaceUri.NULL;
                }
            } else {
                if (option == 1 || option == 2) {
                    throw new SchemaException("No namespace prefix is allowed in this name " + Err.wrap(name));
                }
                uri = this.getURIForPrefix(parts[0], true);
            }
            if (uri == null) {
                throw new SchemaException("Undeclared namespace prefix in " + Err.wrap(name));
            }
            if (!(option != 0 || root.getTargetNamespace().equals(uri) || root.isImportedNamespace(uri) || uri.equals(NamespaceUri.SCHEMA) || uri.equals(NamespaceUri.SCHEMA_INSTANCE))) {
                throw new SchemaException("Cannot reference schema components in " + (uri.isEmpty() ? "the null namespace" : "namespace " + uri) + " as it has not been imported");
            }
            return new StructuredQName(parts[0], uri, parts[1]);
        }
        catch (QNameException err) {
            throw new SchemaException(err.getMessage());
        }
    }

    protected void checkOnlyChildIsAnnotation() throws SchemaException {
        boolean foundAnnotation = false;
        for (NodeInfo nodeInfo : this.children()) {
            int fp = nodeInfo.getFingerprint();
            if (fp == 578) {
                if (foundAnnotation) {
                    this.duplicateElement("annotation");
                }
                foundAnnotation = true;
                continue;
            }
            this.illegalElement(nodeInfo);
        }
    }

    protected void illegalElement(NodeInfo child) throws SchemaException {
        if (child.getNodeKind() != 3) {
            if (child instanceof XSDSchema) {
                this.error("Element " + Err.wrap(child.getDisplayName(), 1) + " is not allowed as a child of " + Err.wrap(this.getDisplayName(), 1));
            } else if (child instanceof SchemaElement) {
                ((SchemaElement)child).error("Element " + Err.wrap(child.getDisplayName(), 1) + " is not allowed as a child of " + Err.wrap(this.getDisplayName(), 1));
            } else {
                this.error("Element " + Err.wrap(child.getDisplayName(), 1) + " is not allowed as a child of " + Err.wrap(this.getDisplayName(), 1));
            }
        }
    }

    protected void duplicateElement(String name) throws SchemaException {
        this.error("Only one " + Err.wrap(name, 1) + " is allowed as a child of " + Err.wrap(this.getDisplayName(), 1));
    }

    protected void duplicate(String category, String name) throws SchemaException {
        this.error("The schema already contains " + this.indefiniteArticle(category, "a") + ' ' + category + " named " + Err.wrap(name));
    }

    protected void mutuallyExclusive(String name1, String name2) throws SchemaException {
        if (name1.equals(name2)) {
            this.duplicateElement(name1);
        } else {
            this.error("The " + Err.wrap(name1, 1) + " and " + Err.wrap(name2, 1) + " elements must not both appear as children of the same " + Err.wrap(this.getDisplayName(), 1));
        }
    }

    protected void mutuallyExclusiveElementAndAttribute(String elem, String att) throws SchemaException {
        this.error(this.indefiniteArticle(elem, "A") + ' ' + Err.wrap(elem, 1) + " element must not appear as a child of " + this.indefiniteArticle(this.getDisplayName(), "a") + ' ' + Err.wrap(this.getDisplayName(), 1) + " with " + this.indefiniteArticle(att, "a") + ' ' + Err.wrap(att, 2) + " attribute");
    }

    protected void mutuallyExclusiveAttributes(String name1, String name2) throws SchemaException {
        this.error("The " + Err.wrap(name1, 2) + " and " + Err.wrap(name2, 2) + " attributes must not both appear on the same " + Err.wrap(this.getDisplayName(), 1) + " element");
    }

    protected void checkMutuallyExclusiveAttributes(String name1, String name2) throws SchemaException {
        AttributeMap atts = this.attributes();
        if (atts.getValue(NamespaceUri.NULL, name1) != null && atts.getValue(NamespaceUri.NULL, name2) != null) {
            this.mutuallyExclusiveAttributes(name1, name2);
        }
    }

    protected void mustPrecede(String name1, String name2) throws SchemaException {
        this.error("The " + Err.wrap(name1, 1) + " must come before the " + Err.wrap(name2, 1) + " element");
    }

    protected void mustBeFirstElement(String name) throws SchemaException {
        this.error(this.indefiniteArticle(name, "A") + ' ' + Err.wrap(name, 1) + " element is allowed only as the first child of " + Err.wrap(this.getDisplayName(), 1));
    }

    protected String indefiniteArticle(String word, String start) {
        String article = start;
        if ("aeiouAEIOU".indexOf(word.charAt(0)) >= 0) {
            article = article + "n";
        } else if (word.startsWith("xs") || word.startsWith("xml")) {
            article = article + "n";
        }
        return article;
    }

    public void invalidAttributeValue(String name, String value, String message) throws SchemaException {
        String s = "The value " + Err.wrap(value, 4) + " is not valid for the " + Err.wrap(name, 2) + " attribute of " + Err.wrap(this.getDisplayName(), 1);
        if (message != null) {
            s = s + ". " + message;
        }
        this.error(s);
    }

    public void missingAttribute(String name) throws SchemaException {
        String s = "The required attribute " + Err.wrap(name, 2) + " is missing from the " + Err.wrap(this.getDisplayName(), 1) + " element";
        this.error(s);
    }

    public void missingChildElement(String name) throws SchemaException {
        String s = "The " + Err.wrap(this.getDisplayName(), 1) + " element must have a child " + Err.wrap(name, 1) + " element";
        this.error(s);
    }

    public int parseFinalOrBlock(String attrName, String finalValue, int allowed) throws SchemaException {
        if (Whitespace.trim(finalValue).equals("#all")) {
            return allowed;
        }
        int result = 0;
        StringTokenizer tokenizer = new StringTokenizer(finalValue, " \t\n\r", false);
        while (tokenizer.hasMoreTokens()) {
            int v;
            String token;
            switch (token = tokenizer.nextToken()) {
                case "union": {
                    v = 4;
                    break;
                }
                case "list": {
                    v = 8;
                    break;
                }
                case "restriction": {
                    v = 1;
                    break;
                }
                case "extension": {
                    v = 2;
                    break;
                }
                case "substitution": {
                    v = 16;
                    break;
                }
                default: {
                    String err = "Invalid " + Err.wrap(attrName, 2) + " value " + Err.wrap(token, 4);
                    this.error(err);
                    return 0;
                }
            }
            if ((v & ~allowed) != 0) {
                String err = "The " + Err.wrap(attrName, 2) + " value " + Err.wrap(token, 4) + " is not allowed here";
                this.error(err);
                return 0;
            }
            result |= v;
        }
        return result;
    }

    public void processId() throws SchemaException {
        SchemaException err;
        String id = this.attributes().getValue(NamespaceUri.NULL, "id");
        if (id != null && (err = this.getSchemaNodeFactory().registerId(id, this)) != null) {
            err.setLocation(this);
            this.error(err);
        }
    }

    protected NodeName allocateAnonymousTypeCode() {
        String baseName;
        String topname;
        int count;
        String moduleName;
        block6: {
            SchemaElement node;
            int slash;
            AxisIterator iter = this.iterateAxis(13, NodeKindTest.ELEMENT);
            moduleName = this.getSystemId();
            while ((slash = moduleName.indexOf(47)) >= 0) {
                if (slash == moduleName.length() - 1) {
                    moduleName = moduleName.substring(0, slash);
                    continue;
                }
                moduleName = moduleName.substring(slash + 1);
            }
            if (!NameChecker.isValidNmtoken(StringView.of(moduleName))) {
                moduleName = "module" + moduleName.hashCode();
            }
            count = 0;
            topname = "";
            do {
                node = (SchemaElement)iter.next();
                ++count;
                if (node == null) break block6;
            } while (!node.isTopLevel());
            AttributeMap atts = node.attributes();
            topname = atts.getValue(NamespaceUri.NULL, "name");
            if (topname == null) {
                topname = "";
            }
        }
        int tries = 0;
        NamePool pool = this.getNamePool();
        String name = baseName = topname + "_anonymous_type_" + count + "_at_line_" + this.getLineNumber() + "_of_" + moduleName;
        while (pool.getFingerprint(NamespaceUri.ANONYMOUS, name) != -1) {
            name = baseName + "_" + ++tries;
        }
        int fp = this.getNamePool().allocateFingerprint(NamespaceUri.ANONYMOUS, name);
        return new FingerprintedQName("anon", NamespaceUri.ANONYMOUS, name, fp);
    }

    public int processMaxOccurs(String attValue) throws SchemaException {
        block6: {
            if ((attValue = Whitespace.trim(attValue)).equals("unbounded")) {
                return -1;
            }
            try {
                ConversionResult maxOccursValue = IntegerValue.stringToInteger(attValue);
                if (maxOccursValue instanceof ValidationFailure) {
                    this.invalidAttributeValue("maxOccurs", attValue, "Must be numeric or 'unbounded'");
                    break block6;
                }
                if (((IntegerValue)maxOccursValue).compareTo(Integer.MAX_VALUE) > 0) {
                    this.warning("maxOccurs value exceeds Saxon limits: taken as unbounded");
                    break block6;
                }
                if (((IntegerValue)maxOccursValue).compareTo(0L) < 0) {
                    this.invalidAttributeValue("maxOccurs", attValue, "The value is negative");
                    break block6;
                }
                return (int)((IntegerValue)maxOccursValue).longValue();
            }
            catch (XPathException e) {
                this.invalidAttributeValue("maxOccurs", attValue, "Must be numeric or 'unbounded'");
            }
        }
        return -1;
    }

    public int processMinOccurs(String attValue) throws SchemaException {
        block5: {
            attValue = Whitespace.trim(attValue);
            try {
                ConversionResult minOccursValue = IntegerValue.stringToInteger(attValue);
                if (minOccursValue instanceof ValidationFailure) {
                    this.invalidAttributeValue("minOccurs", attValue, "Must be numeric");
                    break block5;
                }
                if (((IntegerValue)minOccursValue).compareTo(Integer.MAX_VALUE) > 0) {
                    this.warning("minOccurs value exceeds Saxon limits: taken as 2147483647");
                    return Integer.MAX_VALUE;
                }
                if (((IntegerValue)minOccursValue).compareTo(0L) < 0) {
                    this.invalidAttributeValue("minOccurs", attValue, "The value is negative");
                    break block5;
                }
                return (int)((IntegerValue)minOccursValue).longValue();
            }
            catch (XPathException e) {
                this.invalidAttributeValue("minOccurs", attValue, "Must be numeric");
            }
        }
        return -1;
    }

    protected void checkContentModel(int[][] stateTerms, int[][] stateTargets, boolean allowWildcards) throws SchemaException {
        NodeImpl child;
        NamePool pool = this.getNamePool();
        int state = 0;
        AxisIterator iter = this.iterateAxis(3);
        while ((child = (NodeImpl)iter.next()) != null) {
            int i;
            int fp = child.getFingerprint();
            int[] terms = stateTerms[state];
            int[] targets = stateTargets[state];
            boolean continueOuter = false;
            for (i = 0; i < terms.length; ++i) {
                if (fp != terms[i]) continue;
                state = targets[i];
                continueOuter = true;
                break;
            }
            if (continueOuter) continue;
            if (allowWildcards && !NamespaceUri.SCHEMA.equals(child.getNamespaceUri())) {
                for (i = 0; i < terms.length; ++i) {
                    if (terms[i] != -1) continue;
                    state = targets[i];
                    continueOuter = true;
                    break;
                }
                if (continueOuter) continue;
            }
            StringBuilder msg = new StringBuilder(64);
            if (child.getNodeKind() == 1) {
                msg.append("Element " + Err.wrap(child.getDisplayName(), 1) + " cannot appear here: expected ");
                if (terms.length == 0) {
                    msg.append("no more child elements");
                } else if (terms.length == 1) {
                    msg.append(terms[0] == -1 ? "*" : pool.getEQName(terms[0]));
                } else {
                    msg.append("one of {");
                    for (int i2 = 0; i2 < terms.length; ++i2) {
                        msg.append(terms[i2] == -1 ? "*" : pool.getEQName(terms[i2]));
                        msg.append(i2 == terms.length - 1 ? "}" : ", ");
                    }
                }
                if (this.isFinalState(state) && terms.length > 0) {
                    msg.append(" or nothing");
                }
            } else {
                msg.append("Text node '" + Err.wrap(child.getUnicodeStringValue()) + "' cannot appear here");
            }
            if (child instanceof SchemaElement) {
                ((SchemaElement)child).error(msg.toString());
                continue;
            }
            this.error(msg.toString());
        }
        if (!this.isFinalState(state)) {
            throw new SchemaException("Content of element is incomplete");
        }
    }

    protected boolean isFinalState(int state) {
        return false;
    }

    protected void processAllowedNamespaces(String attValue, Wildcard wildcard) throws SchemaException {
        StringTokenizer tokenizer = new StringTokenizer(attValue, " \t\n\r", false);
        int count = tokenizer.countTokens();
        if (count == 0) {
            wildcard.setNoNamespacesAllowed();
        } else {
            while (tokenizer.hasMoreTokens()) {
                String ns = tokenizer.nextToken();
                if (count > 1 && (NAMESPACE_ANY.equals(ns) || NAMESPACE_OTHER.equals(ns))) {
                    this.error(ns + " is not valid when multiple namespaces are listed.");
                    return;
                }
                if (ns.equals(NAMESPACE_TARGET)) {
                    wildcard.addAllowedNamespace(this.getXSDSchema().getTargetNamespace());
                    continue;
                }
                if (ns.equals(NAMESPACE_LOCAL)) {
                    wildcard.addAllowedNamespace(NamespaceUri.NULL);
                    continue;
                }
                if (ns.equals(NAMESPACE_OTHER)) {
                    wildcard.addDisallowedNamespace(NamespaceUri.NULL);
                    wildcard.addDisallowedNamespace(this.getXSDSchema().getTargetNamespace());
                    continue;
                }
                if (ns.equals(NAMESPACE_ANY)) continue;
                if (ns.contains("##")) {
                    this.error("Invalid namespace URI " + Err.wrap(ns));
                    continue;
                }
                wildcard.addAllowedNamespace(NamespaceUri.of(ns));
            }
        }
    }

    protected void processDisallowedNamespaces(String attValue, Wildcard wildcard) throws SchemaException {
        StringTokenizer tokenizer = new StringTokenizer(attValue, " \t\n\r", false);
        while (tokenizer.hasMoreTokens()) {
            String ns = tokenizer.nextToken();
            if (ns.equals(NAMESPACE_TARGET)) {
                wildcard.addDisallowedNamespace(this.getXSDSchema().getTargetNamespace());
                continue;
            }
            if (ns.equals(NAMESPACE_LOCAL)) {
                wildcard.addDisallowedNamespace(NamespaceUri.NULL);
                continue;
            }
            if (ns.contains("##")) {
                this.error("Invalid namespace URI " + Err.wrap(ns));
                continue;
            }
            wildcard.addDisallowedNamespace(NamespaceUri.of(ns));
        }
    }

    protected void processDisallowedQNames(String attValue, Wildcard wildcard) throws SchemaException {
        StringTokenizer tokenizer = new StringTokenizer(attValue, " \t\n\r", false);
        while (tokenizer.hasMoreTokens()) {
            String qname = tokenizer.nextToken();
            if (qname.equals("##defined")) {
                wildcard.setDisallowDefinedNames(true);
                continue;
            }
            if (qname.equals("##definedSibling")) {
                wildcard.setDisallowDefinedSiblings(true);
                continue;
            }
            int fp = -1;
            try {
                fp = this.getFingerprint(qname, 3);
            }
            catch (SchemaException e) {
                this.error(e.getMessage());
                continue;
            }
            NamespaceUri uri = this.getNamePool().getURI(fp);
            if (!wildcard.matches(uri)) {
                this.error("QName " + Err.wrap(qname, 6) + " is in a namespace that is not allowed by the wildcard");
            }
            wildcard.addDisallowedQName(fp);
        }
    }

    public void checkLocalTargetNamespace(String elementOrAttribute) throws SchemaException {
        AxisIterator ancestors = this.iterateAxis(0, new NameTest(1, 616, this.getNamePool()));
        NodeInfo restriction = ancestors.next();
        if (restriction == null) {
            this.error("A local targetNamespace is allowed only for an " + elementOrAttribute + " declared within an xs:restriction");
        } else {
            ancestors = this.iterateAxis(0, new NameTest(1, 588, this.getNamePool()));
            NodeInfo complexType = ancestors.next();
            if (complexType == null) {
                this.error("A local targetNamespace is allowed only within a complex type restriction");
            } else {
                UserComplexType ct = ((XSDComplexType)complexType).getComplexType();
                if (ct != null && ct.getBaseTypeFingerprint() == 572) {
                    this.error("A local targetNamespace is not allowed on an " + elementOrAttribute + " within a restriction of xs:anyType");
                }
            }
        }
    }

    protected static class XPathStaticContext
    extends IndependentContext {
        private final SchemaElement schemaElement;

        public XPathStaticContext(SchemaElement schemaElement) {
            super(schemaElement.getConfiguration());
            this.schemaElement = schemaElement;
            Configuration config = schemaElement.getConfiguration();
            this.getPackageData().setSchemaAware(true);
            FunctionLibraryList lib = new FunctionLibraryList();
            lib.addFunctionLibrary(XPath20FunctionSet.getInstance());
            lib.addFunctionLibrary(this.getConfiguration().getBuiltInExtensionLibraryList(31));
            lib.addFunctionLibrary(new ConstructorFunctionLibrary(this.getConfiguration()));
            lib.addFunctionLibrary(config.getIntegratedFunctionLibrary());
            config.addExtensionBinders(lib);
            this.setFunctionLibrary(lib);
            this.setXPathLanguageLevel(20);
        }

        @Override
        public NamespaceResolver getNamespaceResolver() {
            return this.schemaElement.getAllNamespaces();
        }

        @Override
        public Executable getExecutable() {
            try {
                return this.schemaElement.getXSDSchema().getExecutable();
            }
            catch (SchemaException e) {
                return null;
            }
        }
    }
}

