/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.feed;

import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.om.FleetingParentNode;
import com.saxonica.ee.stream.watch.Terminator;
import net.sf.saxon.event.ComplexContentOutputter;
import net.sf.saxon.event.Outputter;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.Loc;
import net.sf.saxon.ma.arrays.ArrayItem;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameOfNode;
import net.sf.saxon.om.NamespaceMap;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.str.StringConstants;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.value.AtomicValue;

public abstract class ComplexNodeEventFeed
extends ItemFeed {
    private boolean opened = false;
    private boolean previousAtomic = false;
    protected Outputter next;

    public ComplexNodeEventFeed(Expression exp, ItemFeed parentExpressionFeed, XPathContext context) {
        super(exp, parentExpressionFeed, context);
        this.next = parentExpressionFeed;
    }

    @Override
    public void open(Terminator terminator) throws XPathException {
        if (!this.opened) {
            super.open(terminator);
            try {
                this.processLeft(this.getContext());
            }
            catch (XPathException e) {
                this.dynamicError(e);
            }
            this.opened = true;
        }
    }

    @Override
    public Receiver startSelectedParentNode(FleetingParentNode node, Location locationId) throws XPathException {
        return null;
    }

    @Override
    public void append(Item item) throws XPathException {
        block12: {
            if (item instanceof FleetingParentNode) {
                throw new XPathException("Internal streaming error: streamed node cannot be used directly to construct output node", "SXST0067", this.getExpression().getLocation());
            }
            if (this.opened && !this.hasFailed()) {
                try {
                    Outputter out = this.next;
                    if (item instanceof NodeInfo) {
                        NodeInfo node = (NodeInfo)item;
                        int kind = node.getNodeKind();
                        if (kind == 2) {
                            out.attribute(NameOfNode.makeName(node), (SimpleType)node.getSchemaType(), node.getStringValue(), this.getExpression().getLocation(), 0);
                        } else {
                            ((NodeInfo)item).copy(out, 6, this.getExpression().getLocation());
                        }
                        this.previousAtomic = false;
                        break block12;
                    }
                    if (item instanceof AtomicValue) {
                        if (this.previousAtomic) {
                            out.characters(StringConstants.SINGLE_SPACE, Loc.NONE, 0x100000);
                        }
                        out.characters(item.getUnicodeStringValue(), this.getExpression().getLocation(), 0);
                        this.previousAtomic = true;
                        break block12;
                    }
                    if (item instanceof ArrayItem) {
                        for (GroundedValue members : ((ArrayItem)item).members()) {
                            for (Item item2 : members.asIterable()) {
                                this.append(item2);
                            }
                        }
                        break block12;
                    }
                    throw new XPathException("Cannot write a function item to the content of an XDM tree", "XTDE0450");
                }
                catch (XPathException e) {
                    this.dynamicError(e);
                }
            }
        }
    }

    @Override
    public void endSelectedParentNode(Location locationId) throws XPathException {
    }

    @Override
    public void close() throws XPathException {
        if (this.opened && !this.hasFailed()) {
            try {
                this.processRight(this.getContext());
            }
            catch (XPathException e) {
                this.dynamicError(e);
                return;
            }
            super.close();
            this.opened = false;
        }
    }

    protected void setComplexContentOutputter(ComplexContentOutputter out) {
    }

    protected abstract void processLeft(XPathContext var1) throws XPathException;

    protected abstract void processRight(XPathContext var1) throws XPathException;

    @Override
    public void startDocument(int properties) throws XPathException {
        if (!this.hasFailed()) {
            try {
                this.next.startDocument(properties);
            }
            catch (XPathException e) {
                this.dynamicError(e);
            }
        }
        this.previousAtomic = false;
    }

    @Override
    public void endDocument() throws XPathException {
        if (!this.hasFailed()) {
            try {
                this.next.endDocument();
            }
            catch (XPathException e) {
                this.dynamicError(e);
            }
        }
        this.previousAtomic = false;
    }

    @Override
    public void startElement(NodeName elemName, SchemaType typeCode, Location location, int properties) throws XPathException {
        if (!this.hasFailed()) {
            try {
                this.next.startElement(elemName, typeCode, location, properties);
            }
            catch (XPathException e) {
                this.dynamicError(e);
            }
        }
        this.previousAtomic = false;
    }

    @Override
    public void startElement(NodeName elemName, SchemaType type, AttributeMap attributes, NamespaceMap namespaces, Location location, int properties) throws XPathException {
        if (!this.hasFailed()) {
            try {
                this.next.startElement(elemName, type, attributes, namespaces, location, properties);
            }
            catch (XPathException e) {
                this.dynamicError(e);
            }
        }
        this.previousAtomic = false;
    }

    @Override
    public void namespace(String prefix, NamespaceUri namespaceUri, int properties) throws XPathException {
        if (!this.hasFailed()) {
            try {
                this.next.namespace(prefix, namespaceUri, properties);
            }
            catch (XPathException e) {
                this.dynamicError(e);
            }
        }
        this.previousAtomic = false;
    }

    @Override
    public void attribute(NodeName attName, SimpleType typeCode, String value, Location location, int properties) throws XPathException {
        if (!this.hasFailed()) {
            try {
                this.next.attribute(attName, typeCode, value, location, properties);
            }
            catch (XPathException e) {
                this.dynamicError(e);
            }
        }
        this.previousAtomic = false;
    }

    @Override
    public void startContent() throws XPathException {
        if (!this.hasFailed()) {
            try {
                this.next.startContent();
            }
            catch (XPathException e) {
                this.dynamicError(e);
            }
        }
        this.previousAtomic = false;
    }

    @Override
    public void endElement() throws XPathException {
        if (!this.hasFailed()) {
            try {
                this.next.endElement();
            }
            catch (XPathException e) {
                this.dynamicError(e);
            }
        }
        this.previousAtomic = false;
    }

    @Override
    public void characters(UnicodeString chars, Location location, int properties) throws XPathException {
        if (!this.hasFailed()) {
            try {
                this.next.characters(chars, location, properties);
            }
            catch (XPathException e) {
                this.dynamicError(e);
            }
        }
        this.previousAtomic = false;
    }

    @Override
    public void processingInstruction(String name, UnicodeString data, Location location, int properties) throws XPathException {
        if (!this.hasFailed()) {
            try {
                this.next.processingInstruction(name, data, location, properties);
            }
            catch (XPathException e) {
                this.dynamicError(e);
            }
        }
        this.previousAtomic = false;
    }

    @Override
    public void comment(UnicodeString content, Location location, int properties) throws XPathException {
        if (!this.hasFailed()) {
            try {
                this.next.comment(content, location, properties);
            }
            catch (XPathException e) {
                this.dynamicError(e);
            }
        }
        this.previousAtomic = false;
    }
}

