/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.ToIteratorCompiler;
import com.saxonica.ee.bytecode.map.ForItemMappingAction;
import com.saxonica.ee.bytecode.map.ForSequenceMappingAction;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import com.saxonica.objectweb.asm.ClassVisitor;
import com.saxonica.objectweb.asm.ClassWriter;
import com.saxonica.objectweb.asm.Type;
import com.saxonica.objectweb.asm.commons.Method;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ForExpression;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.value.Cardinality;

public class ForExpressionCompiler
extends ToIteratorCompiler {
    @Override
    public void compileToPush(CompilerService compiler, Expression expression) throws CannotCompileException {
        Expression sequence = ((ForExpression)expression).getSequence();
        Expression action = ((ForExpression)expression).getAction();
        int slotNum = ((ForExpression)expression).getLocalSlotNumber();
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        ForExpressionCompiler.visitAnnotation(compiler, "ForExpression-push");
        compiler.compileToIterator(sequence);
        int iterVar = methodInfo.allocateLocal(SequenceIterator.class);
        ga.storeLocal(iterVar);
        LabelInfo done = methodInfo.newLabel("doneFor");
        LabelInfo loop = methodInfo.placeNewLabel("loopFor");
        ga.loadLocal(iterVar);
        ga.invokeInstanceMethod(SequenceIterator.class, "next", new Class[0]);
        ga.dup();
        ga.ifNull(done.label());
        compiler.generateGetContext();
        ga.swap();
        ga.push(slotNum);
        ga.swap();
        ga.invokeInstanceMethod(XPathContext.class, "setLocalVariable", Integer.TYPE, Sequence.class);
        compiler.compileToPush(action);
        ga.goTo(loop);
        methodInfo.placeLabel(done);
        ga.pop();
        methodInfo.releaseLocal(iterVar);
    }

    @Override
    public void compileToIterator(CompilerService compiler, Expression expression) throws CannotCompileException {
        Expression sequence = ((ForExpression)expression).getSequence();
        Expression action = ((ForExpression)expression).getAction();
        ForExpressionCompiler.visitAnnotation(compiler, "Forexpression-itr");
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        int localSlotNum = ((ForExpression)expression).getLocalSlotNumber();
        if (!Cardinality.allowsMany(sequence.getCardinality())) {
            compiler.compileToItem(sequence);
            ga.dup();
            LabelInfo nullLabel = methodInfo.newLabel("nullLabel");
            LabelInfo endLabel = methodInfo.newLabel("endLabel");
            ga.ifNull(nullLabel.label());
            compiler.generateGetContext();
            ga.swap();
            int slotNumber = ((ForExpression)expression).getLocalSlotNumber();
            ga.push(slotNumber);
            ga.swap();
            ga.invokeInstanceMethod(XPathContext.class, "setLocalVariable", Integer.TYPE, Sequence.class);
            compiler.compileToIterator(action);
            ga.goTo(endLabel);
            methodInfo.placeLabel(nullLabel);
            ga.pop();
            ForExpressionCompiler.allocateStatic(compiler, EmptyIterator.emptyIterator());
            methodInfo.placeLabel(endLabel);
        } else if (Cardinality.allowsMany(action.getCardinality())) {
            ga.newInstance(MappingIterator.class);
            ga.dup();
            compiler.compileToIterator(sequence);
            Class mappingActionClass = compiler.getCompiledClass(expression);
            if (mappingActionClass == null) {
                mappingActionClass = ForExpressionCompiler.generateSequenceMappingAction(compiler, (ForExpression)expression, action, localSlotNum);
                compiler.setCompiledClass(expression, mappingActionClass);
            }
            ForExpressionCompiler.allocateStatic(compiler, mappingActionClass);
            ga.invokeInstanceMethod(Class.class, "newInstance", new Class[0]);
            ga.checkClass(ForSequenceMappingAction.class);
            ga.dup();
            compiler.generateGetContext();
            ga.invokeInstanceMethod(ForSequenceMappingAction.class, "setContext", XPathContext.class);
            ga.invokeConstructor(MappingIterator.class, SequenceIterator.class, MappingFunction.class);
        } else {
            ga.newInstance(ItemMappingIterator.class);
            ga.dup();
            compiler.compileToIterator(sequence);
            Class mappingActionClass = compiler.getCompiledClass(expression);
            if (mappingActionClass == null) {
                mappingActionClass = this.generateItemMappingAction(compiler, (ForExpression)expression, action, localSlotNum);
                compiler.setCompiledClass(expression, mappingActionClass);
            }
            ForExpressionCompiler.allocateStatic(compiler, mappingActionClass);
            ga.invokeInstanceMethod(Class.class, "newInstance", new Class[0]);
            ga.checkClass(ForItemMappingAction.class);
            ga.dup();
            compiler.generateGetContext();
            ga.invokeInstanceMethod(ForItemMappingAction.class, "setContext", XPathContext.class);
            ga.push(!Cardinality.allowsZero(action.getCardinality()));
            ga.invokeConstructor(ItemMappingIterator.class, SequenceIterator.class, ItemMappingFunction.class, Boolean.TYPE);
        }
    }

    public static Class generateSequenceMappingAction(CompilerService compiler, ForExpression expression, Expression action, int slotNumber) throws CannotCompileException {
        compiler.checkMaxClassesLimit();
        ClassWriter cw = new ClassWriter(compiler.getFlags());
        ClassVisitor cv = cw;
        String className = "gen_ForSequenceMappingAction_line" + expression.getLocation().getLineNumber() + "_" + CompilerService.getUniqueNumber();
        cv = compiler.makeAnnotatedTraceClassVisitor(cv, className);
        cv.visitSource(expression.getLocation().getSystemId(), null);
        cv.visit(49, 1, className, null, "com/saxonica/ee/bytecode/map/ForSequenceMappingAction", new String[0]);
        compiler.pushNewClassInfo(className, ForSequenceMappingAction.class, cw);
        Method m = Method.getMethod("void <init> ()");
        Generator ga = new Generator(1, m, false, cv);
        ga.loadThis();
        ga.invokeConstructor(Type.getType(ForSequenceMappingAction.class), m);
        ga.returnValue();
        ga.endMethod();
        m = Method.getMethod("net.sf.saxon.om.SequenceIterator map(net.sf.saxon.om.Item)");
        ga = new Generator(1, m, true, cv);
        int contextVar = ga.newLocal(XPathContext.class);
        compiler.pushNewMethodInfo(ga, false, contextVar);
        ForExpressionCompiler.visitLineNumber(compiler, ga, expression);
        ga.loadThis();
        ga.getField(Type.getType(ForSequenceMappingAction.class), "context", Type.getType(XPathContext.class));
        compiler.initNewMethod(ga, false);
        ga.loadLocal(contextVar);
        ga.push(slotNumber);
        ga.loadArg(0);
        ga.invokeInstanceMethod(XPathContext.class, "setLocalVariable", Integer.TYPE, Sequence.class);
        compiler.compileToIterator(action);
        ga.returnValue();
        ga.endMethod();
        compiler.popCurrentMethodInfo();
        cv.visitEnd();
        ForExpressionCompiler.verify(cw, "For expression at line " + expression.getLocation().getLineNumber(), compiler.isDebugByteCode());
        return compiler.makeClass(cw, className);
    }

    private Class generateItemMappingAction(CompilerService compiler, ForExpression expression, Expression action, int slotNumber) throws CannotCompileException {
        compiler.checkMaxClassesLimit();
        ClassWriter cw = new ClassWriter(compiler.getFlags());
        ClassVisitor cv = cw;
        int lineNumber = expression.getLocation().getLineNumber();
        String className = "gen_ForItemMappingAction_line" + (lineNumber > 0 ? lineNumber : 0) + "_" + CompilerService.getUniqueNumber();
        cv = compiler.makeAnnotatedTraceClassVisitor(cv, className);
        cv.visitSource(expression.getLocation().getSystemId(), null);
        cv.visit(49, 1, className, null, "com/saxonica/ee/bytecode/map/ForItemMappingAction", new String[0]);
        compiler.pushNewClassInfo(className, ForItemMappingAction.class, cw);
        Method m = Method.getMethod("void <init> ()");
        Generator ga = new Generator(1, m, false, cv);
        ga.loadThis();
        ga.invokeConstructor(Type.getType(ForItemMappingAction.class), m);
        ga.returnValue();
        ga.endMethod();
        m = Method.getMethod("net.sf.saxon.om.Item mapItem(net.sf.saxon.om.Item)");
        ga = new Generator(1, m, true, cv);
        int contextVar = ga.newLocal(XPathContext.class);
        compiler.pushNewMethodInfo(ga, false, contextVar);
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        ForExpressionCompiler.visitLineNumber(compiler, ga, expression);
        LabelInfo itemNotNull = methodInfo.newLabel("itemNotNull");
        ga.loadArg(0);
        ga.ifNonNull(itemNotNull.label());
        ga.showMessage(compiler, "Item is null");
        methodInfo.placeLabel(itemNotNull);
        ga.showObjectVariable(compiler, "itemArg", 0);
        ga.loadThis();
        ga.getField(Type.getType(ForItemMappingAction.class), "context", Type.getType(XPathContext.class));
        compiler.initNewMethod(ga, false);
        ga.loadLocal(contextVar);
        ga.push(slotNumber);
        ga.loadArg(0);
        ga.invokeInstanceMethod(XPathContext.class, "setLocalVariable", Integer.TYPE, Sequence.class);
        compiler.compileToItem(action);
        ga.showMessage(compiler, "Returning");
        ga.returnValue();
        ga.endMethod();
        compiler.popCurrentMethodInfo();
        cv.visitEnd();
        ForExpressionCompiler.verify(cw, "For expression at line " + expression.getLocation().getLineNumber(), compiler.isDebugByteCode());
        return compiler.makeClass(cw, className);
    }
}

