/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode.util;

import com.saxonica.expr.JavaExtensionFunctionCall;
import java.lang.reflect.AccessibleObject;
import net.sf.saxon.expr.CardinalityChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.JavaExternalObjectType;
import net.sf.saxon.type.StringToDouble;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.Whitespace;

public class Callback {
    public static String makeMessageFromTemplate(String messageTemplate, Object param0) {
        return messageTemplate.replace("{$1}", param0.toString());
    }

    public static XPathException makeNonComparableException(AtomicValue av0, AtomicValue av1, String systemId, int lineNumber) {
        XPathException e2 = new XPathException("Cannot compare " + Type.displayTypeName(av0) + " to " + Type.displayTypeName(av1), "XPTY0004", new ExplicitLocation(systemId, lineNumber, -1));
        e2.setIsTypeError(true);
        return e2;
    }

    public static XPathException makeXmlNamespaceException(String prefix, String namespace, boolean isXSLT, String systemId, int lineNumber) {
        String message = prefix.equals("xml") ? "When the prefix is 'xml', the namespace URI must be http://www.w3.org/XML/1998/namespace" : "When the namespace URI is http://www.w3.org/XML/1998/namespace, the prefix must be 'xml'";
        String errorCode = isXSLT ? "XTDE0835" : "XQDY0096";
        ExplicitLocation loc = new ExplicitLocation(systemId, lineNumber, -1);
        return new XPathException(message, errorCode, loc);
    }

    public static XPathException makeJavaInvocationException(Exception err, JavaExtensionFunctionCall call) {
        XPathException xe = new XPathException("Exception thrown by extension function {" + call.getTargetMethod().toString() + "}: " + err, err);
        xe.setLocation(call.getLocation());
        xe.setErrorCodeQName(JavaExternalObjectType.classNameToQName(err.getClass().getName()));
        xe.setErrorObject(new ObjectValue<AccessibleObject>(call.getTargetMethod()));
        return xe;
    }

    public static XPathException makeMultipleItemsException(CardinalityChecker expression, XPathContext context) {
        String depiction;
        try {
            SequenceIterator<?> offendingSequence = expression.getBaseExpression().iterate(context);
            depiction = CardinalityChecker.depictSequenceStart(offendingSequence, 2);
        }
        catch (XPathException err) {
            depiction = "";
        }
        RoleDiagnostic role = expression.getRoleLocator();
        String message = "A sequence of more than one item is not allowed as the " + role.getMessage() + depiction;
        XPathException err = new XPathException(message, role.getErrorCode(), expression.getLocation());
        err.setIsTypeError(true);
        err.setXPathContext(context);
        return err;
    }

    public static XPathException makeXPathException(String message, String errorCode, String systemId, int lineNumber, boolean isTypeError) {
        XPathException err = new XPathException(message, errorCode, new ExplicitLocation(systemId, lineNumber, -1));
        err.setIsTypeError(isTypeError);
        return err;
    }

    public static double stringToNumberOrNaN(StringToDouble s2d, CharSequence string) {
        try {
            return s2d.stringToNumber(string);
        }
        catch (NumberFormatException err) {
            return Double.NaN;
        }
    }

    public static long doubleToIntegerOrError(double value) throws XPathException {
        if (Double.isNaN(value)) {
            ValidationFailure err = new ValidationFailure("Cannot convert double NaN to an integer");
            err.setErrorCode("FOCA0002");
            throw err.makeException();
        }
        if (Double.isInfinite(value)) {
            ValidationFailure err = new ValidationFailure("Cannot convert double INF to an integer");
            err.setErrorCode("FOCA0002");
            throw err.makeException();
        }
        return (long)value;
    }

    public static int booleanFromString(CharSequence s) {
        int len = (s = Whitespace.trimWhitespace(s)).length();
        if (len == 1) {
            char c = s.charAt(0);
            if (c == '1') {
                return 1;
            }
            if (c == '0') {
                return 0;
            }
        } else if (len == 4) {
            if (s.charAt(0) == 't' && s.charAt(1) == 'r' && s.charAt(2) == 'u' && s.charAt(3) == 'e') {
                return 1;
            }
        } else if (len == 5 && s.charAt(0) == 'f' && s.charAt(1) == 'a' && s.charAt(2) == 'l' && s.charAt(3) == 's' && s.charAt(4) == 'e') {
            return 0;
        }
        return -1;
    }
}

