/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.index;

import de.ids_mannheim.korap.KrillIndex;
import de.ids_mannheim.korap.util.KrillProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.store.MMapDirectory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Indexer {
    private KrillIndex index;
    private int count;
    private int commitCount;
    private static String path = null;
    private static boolean addInsteadOfUpsert = false;
    private Pattern jsonFilePattern;
    private static final Logger log = LoggerFactory.getLogger(Indexer.class);
    private static final boolean DEBUG = false;

    public Indexer(Properties prop) throws IOException {
        if (path == null) {
            path = prop.getProperty("krill.indexDir");
        }
        log.info("Output directory: " + path);
        String commitCount = prop.getProperty("krill.index.commit.count", "1000");
        this.index = new KrillIndex(new MMapDirectory(Paths.get(path, new String[0])));
        this.count = 0;
        this.commitCount = Integer.parseInt(commitCount);
        this.jsonFilePattern = Pattern.compile(".*\\.json\\.gz$");
    }

    private void parse(File dir) {
        for (String string : dir.list()) {
            Matcher matcher = this.jsonFilePattern.matcher(string);
            if (matcher.find()) {
                String string2 = dir.getPath() + "/" + string;
                try {
                    if (addInsteadOfUpsert) {
                        log.info("{} Add {} to the index. ", (Object)this.count, (Object)string2);
                        if (this.index.addDoc(new FileInputStream(string2), true) == null) {
                            log.warn("fail.");
                            continue;
                        }
                    } else {
                        log.info("{} Add or update {} to the index. ", (Object)this.count, (Object)string2);
                        if (this.index.upsertDoc(new FileInputStream(string2), true) == null) {
                            log.warn("fail.");
                            continue;
                        }
                    }
                    ++this.count;
                    if (this.count % this.commitCount != 0) continue;
                    this.commit();
                }
                catch (FileNotFoundException e) {
                    log.error("File " + string2 + " is not found!");
                }
                continue;
            }
            log.warn("Skip " + string + " since it does not have json.gz format.");
        }
    }

    private void commit() {
        log.info("Committing index ... ");
        try {
            this.index.commit();
        }
        catch (IOException e) {
            log.error("Unable to commit to index " + path);
        }
    }

    private void closeIndex() throws IOException {
        this.commit();
        this.index.closeReader();
        this.index.closeWriter();
    }

    public static void main(String[] argv) {
        Options options = new Options();
        options.addOption(Option.builder("c").longOpt("config").desc("configuration file (defaults to krill.properties).").hasArg().argName("properties file").required().build());
        options.addOption(Option.builder("i").longOpt("inputDir").desc("input directories separated by semicolons. The input files have to be in <filename>.json.gz format. ").hasArgs().argName("input directories").required().valueSeparator(Character.valueOf(';').charValue()).build());
        options.addOption(Option.builder("o").longOpt("outputDir").desc("index output directory (defaults to krill.indexDir in the configuration.").hasArg().argName("output directory").build());
        options.addOption(Option.builder("a").longOpt("addInsteadofUpsert").desc("Always add files to the index, never update").build());
        DefaultParser parser = new DefaultParser();
        String propFile = null;
        String[] inputDirectories = null;
        try {
            CommandLine cmd = parser.parse(options, argv);
            log.info("Configuration file: " + cmd.getOptionValue("c"));
            propFile = cmd.getOptionValue("c");
            log.info("Input directories: " + StringUtils.join((Object[])cmd.getOptionValues("i"), ";"));
            inputDirectories = cmd.getOptionValues("i");
            if (cmd.hasOption("o")) {
                log.info("Output directory: " + cmd.getOptionValue("o"));
                path = cmd.getOptionValue("o");
            }
            if (cmd.hasOption("a")) {
                addInsteadOfUpsert = true;
            }
        }
        catch (MissingOptionException e) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("Krill indexer\n java -jar -c <properties file> -i <input directories> [-o <output directory> -a]", options);
            return;
        }
        catch (ParseException e) {
            log.error("Unexpected error: " + e);
            e.printStackTrace();
        }
        Properties prop = KrillProperties.loadProperties(propFile);
        try {
            Indexer indexer = new Indexer(prop);
            for (String arg : inputDirectories) {
                log.info("Indexing files in " + arg);
                File f = new File(arg);
                if (!f.isDirectory()) continue;
                indexer.parse(f);
            }
            indexer.closeIndex();
            log.info("Finished indexing.");
            Object message = "Added ";
            if (!addInsteadOfUpsert) {
                message = (String)message + "or updated ";
            }
            message = (String)message + indexer.count + " file";
            if (indexer.count > 1) {
                message = (String)message + "s";
            }
            System.out.println((String)message + ".");
        }
        catch (IOException e) {
            log.error("Unexpected error: " + e);
            e.printStackTrace();
        }
    }
}

