/*
 * Decompiled with CFR 0.152.
 */
package experimental.morfessor;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import experimental.morfessor.CharEncoder;
import experimental.morfessor.Morfessor;
import experimental.morfessor.Splitter;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import marmot.util.FileUtils;
import marmot.util.LineIterator;

public class CorpusSegmenter {
    public static void main(String[] args2) throws JSAPException, IOException {
        JSAP jsap = new JSAP();
        FlaggedOption opt = new FlaggedOption("text-file").setRequired(true).setLongFlag("text-file");
        jsap.registerParameter((Parameter)opt);
        opt = new FlaggedOption("morfessor").setRequired(false).setLongFlag("morfessor");
        jsap.registerParameter((Parameter)opt);
        opt = new FlaggedOption("encoder").setRequired(false).setLongFlag("encoder");
        jsap.registerParameter((Parameter)opt);
        opt = new FlaggedOption("splitter").setRequired(false).setLongFlag("splitter");
        jsap.registerParameter((Parameter)opt);
        opt = new FlaggedOption("out-file").setRequired(true).setLongFlag("out-file");
        jsap.registerParameter((Parameter)opt);
        JSAPResult config = jsap.parse(args2);
        if (!config.success()) {
            Iterator errs = config.getErrorMessageIterator();
            while (errs.hasNext()) {
                System.err.println("Error: " + errs.next());
            }
            System.err.println("Usage: ");
            System.err.println(jsap.getUsage());
            System.err.println(jsap.getHelp());
            System.err.println();
            System.exit(1);
        }
        Splitter splitter = null;
        if (config.getString("splitter") != null) {
            splitter = (Splitter)FileUtils.loadFromFile(config.getString("splitter"));
        } else if (config.getString("morfessor") != null) {
            CharEncoder encoder = null;
            if (config.getString("encoder") != null) {
                try {
                    encoder = (CharEncoder)FileUtils.loadFromFile(config.getString("encoder"));
                }
                catch (RuntimeException e) {
                    System.err.println("Caught :" + e);
                    System.err.println("Trying text model ...");
                    encoder = CharEncoder.loadFromFile(config.getString("encoder"));
                }
            }
            splitter = new Morfessor(config.getString("morfessor"), encoder);
        } else {
            System.err.println("Error: Either splitter or morfessor must be specified!");
            System.exit(1);
        }
        Writer writer = FileUtils.openFileWriter(config.getString("out-file"));
        LineIterator iterator2 = new LineIterator(config.getString("text-file"));
        int count2 = 0;
        long time = System.currentTimeMillis();
        while (iterator2.hasNext()) {
            Object line = iterator2.next();
            boolean first2 = true;
            Iterator iterator3 = line.iterator();
            while (iterator3.hasNext()) {
                String word = (String)iterator3.next();
                List<String> morphs = splitter.split(word);
                for (String morph : morphs) {
                    if (!first2) {
                        writer.write(32);
                    }
                    writer.write(morph);
                    first2 = false;
                }
            }
            writer.write(10);
            if (++count2 % 100000 != 0) continue;
            double delta = (double)(System.currentTimeMillis() - time) / 1000.0;
            System.err.format("Processing at %g lines/s.\n", (double)count2 / delta);
        }
        writer.close();
    }
}

