/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.watch;

import com.saxonica.ee.stream.Inversion;
import com.saxonica.ee.stream.ManualGroupIterator;
import com.saxonica.ee.stream.Streamability;
import com.saxonica.ee.stream.Sweep;
import com.saxonica.ee.stream.adjunct.ForEachGroupAdjunct;
import com.saxonica.ee.stream.adjunct.GroupAdjacentTester;
import com.saxonica.ee.stream.adjunct.GroupBoundaryTester;
import com.saxonica.ee.stream.feed.FilteringFeed;
import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.feed.NoOpenOrCloseFeed;
import com.saxonica.ee.stream.om.FleetingNode;
import com.saxonica.ee.stream.om.FleetingParentNode;
import com.saxonica.ee.stream.watch.Terminator;
import com.saxonica.ee.stream.watch.Trigger;
import com.saxonica.ee.stream.watch.Watch;
import com.saxonica.ee.stream.watch.WatchManager;
import java.util.List;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.ForEachGroup;
import net.sf.saxon.functions.CurrentGroupCall;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.AncestorQualifiedPattern;
import net.sf.saxon.pattern.AnchorPattern;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ManualIterator;

public class ForEachGroupPartitionAction
extends ItemFeed {
    protected XPathContext bodyContext;
    private final WatchManager watchManager;
    private GroupBoundaryTester boundaryTester;
    private ItemFeed currentGroupFeed;
    private final XPathContext populationContext;
    private final Expression action;
    private Inversion inversion;
    private final boolean actionIsConsuming;
    private boolean closed = true;
    private List<Watch> currentGroupWatches;
    public boolean feedAppliesToWholeGroup = false;
    private boolean closeAtEndElement;
    private NodeInfo anchorNode;
    private Watch thisGroupWatch = null;
    private WatchManager.GroupingScope currentGroupingScope = null;

    public ForEachGroupPartitionAction(WatchManager watchManager, ForEachGroup expression, ItemFeed result, XPathContext context) {
        super(expression, result, context);
        this.watchManager = watchManager;
        this.action = expression.getActionExpression();
        this.actionIsConsuming = Streamability.getSweep(this.action) == Sweep.CONSUMING;
        this.populationContext = context.newMinorContext();
    }

    public void setInversion(Inversion inversion) {
        this.inversion = inversion;
    }

    protected Inversion getInversion() {
        return this.inversion;
    }

    @Override
    public void open(Terminator terminator) throws XPathException {
        super.open(terminator);
        this.makeBodyContext();
        this.populationContext.setCurrentIterator(new ManualIterator());
        this.boundaryTester = ForEachGroupAdjunct.makeBoundaryTester((ForEachGroup)this.getExpression(), this.populationContext);
        this.closed = false;
    }

    protected void makeBodyContext() {
        this.bodyContext = this.getContext().newContext();
        ManualGroupIterator mgi = new ManualGroupIterator(null, 0);
        this.bodyContext.setCurrentIterator(mgi);
        ((XPathContextMajor)this.bodyContext).setCurrentGroupIterator(mgi);
    }

    @Override
    public Receiver startSelectedParentNode(FleetingParentNode node, Location locationId) throws XPathException {
        ManualIterator popIter = (ManualIterator)this.populationContext.getCurrentIterator();
        popIter.setContextItem(node);
        popIter.incrementPosition();
        this.anchorNode = node;
        boolean needToStartNewGroup = this.boundaryTester.notifyItem();
        if (this.actionIsConsuming) {
            if (needToStartNewGroup) {
                this.startNewGroup(node);
                this.closeAtEndElement = true;
                return this.currentGroupFeed.startSelectedParentNode(node, locationId);
            }
            ((ManualGroupIterator)this.bodyContext.getCurrentGroupIterator()).appendToCurrentGroup(node);
            for (Watch w : this.currentGroupWatches) {
                if (!(w instanceof Trigger) || !((Trigger)w).isMatchCurrentGroup()) continue;
                w.setAnchorNode(node);
            }
            this.closeAtEndElement = this.feedAppliesToWholeGroup;
            if (this.feedAppliesToWholeGroup) {
                return this.currentGroupFeed.startSelectedParentNode(node, locationId);
            }
            return this.currentGroupFeed.startSelectedParentNode(node, locationId);
        }
        this.maybeStartNewGroup(node, needToStartNewGroup);
        return null;
    }

    private void maybeStartNewGroup(Item node, boolean startNewGroup) throws XPathException {
        if (startNewGroup) {
            ManualIterator iter = (ManualIterator)this.bodyContext.getCurrentIterator();
            iter.setContextItem(node);
            iter.incrementPosition();
            SequenceIterator stepIter = this.action.iterate(this.bodyContext);
            ForEachGroupPartitionAction.processItems(stepIter, this.getNextOutputter());
        }
    }

    @Override
    public void append(Item node) throws XPathException {
        ManualIterator popIter = (ManualIterator)this.populationContext.getCurrentIterator();
        popIter.setContextItem(node);
        popIter.incrementPosition();
        boolean needToStartNewGroup = this.boundaryTester.notifyItem();
        if (this.actionIsConsuming) {
            if (needToStartNewGroup) {
                this.startNewGroup(node);
            }
            this.currentGroupFeed.append(node);
        } else {
            this.maybeStartNewGroup(node, needToStartNewGroup);
        }
    }

    private void startNewGroup(Item node) throws XPathException {
        if (this.currentGroupFeed != null) {
            this.watchManager.endGroupingScope(this.currentGroupingScope);
            this.watchManager.stopCapturingGroupingWatches(this.currentGroupingScope);
            this.currentGroupFeed.close();
        }
        if (this.thisGroupWatch != null) {
            this.watchManager.removeWatch(this.thisGroupWatch);
        }
        this.currentGroupingScope = this.watchManager.startGroupingScope();
        this.watchManager.startCapturingGroupingWatches(this.currentGroupingScope);
        ManualGroupIterator firstItemsIter = (ManualGroupIterator)this.bodyContext.getCurrentIterator();
        firstItemsIter.setContextItem(node);
        firstItemsIter.incrementPosition();
        firstItemsIter.startNewCurrentGroup(node);
        if (this.boundaryTester instanceof GroupAdjacentTester) {
            firstItemsIter.setCurrentGroupingKey(((GroupAdjacentTester)this.boundaryTester).getCurrentGroupingKey());
        }
        if (node instanceof FleetingNode) {
            NoOpenOrCloseFeed thisFeed = new NoOpenOrCloseFeed(this.getResultFeed(), this.bodyContext);
            Trigger watch = this.getInversion().getWatch(this.watchManager, thisFeed, this.bodyContext);
            Pattern pattern = watch.getSelection();
            ItemFeed actionFeed = watch.getAction();
            if (pattern.matchesCurrentGroup()) {
                this.feedAppliesToWholeGroup = true;
            }
            boolean opened = false;
            if (pattern instanceof AnchorPattern) {
                this.currentGroupFeed = actionFeed;
            } else {
                FilteringFeed.FilterLambda filter = new FilteringFeed.FilterLambda((item, position) -> pattern.matchesBeneathAnchor((NodeInfo)item, this.anchorNode, this.bodyContext) ? FilteringFeed.FilterResult.MATCHES : FilteringFeed.FilterResult.SKIP);
                this.currentGroupFeed = new FilteringFeed(this.watchManager, actionFeed, this.getContext(), filter);
                if (pattern instanceof AncestorQualifiedPattern) {
                    this.watchManager.addWatch(watch, true);
                    opened = true;
                    this.thisGroupWatch = watch;
                }
            }
            if (!opened) {
                this.currentGroupFeed.open(this.getTerminator());
            }
        } else {
            this.currentGroupFeed = new NoOpenOrCloseFeed(this.findCurrentGroupFeed(), this.bodyContext);
            this.currentGroupFeed.open(this.getTerminator());
        }
        this.currentGroupWatches = this.currentGroupingScope.watches;
        this.currentGroupingScope.isActive = false;
    }

    private ItemFeed findCurrentGroupFeed() throws XPathException {
        NoOpenOrCloseFeed thisFeed = new NoOpenOrCloseFeed(this.getResultFeed(), this.bodyContext);
        Trigger watch = this.getInversion().getWatch(this.watchManager, thisFeed, this.bodyContext);
        ItemFeed feed = watch.getAction();
        while (!(feed.getExpression() instanceof CurrentGroupCall)) {
            feed = feed.getResultFeed();
        }
        return feed;
    }

    @Override
    public void endSelectedParentNode(Location locationId) throws XPathException {
        if (this.currentGroupFeed != null && this.closeAtEndElement) {
            this.currentGroupFeed.endSelectedParentNode(locationId);
        }
    }

    @Override
    public void close() throws XPathException {
        if (this.currentGroupFeed != null && !this.closed) {
            this.closed = true;
            this.watchManager.endGroupingScope(this.currentGroupingScope);
            this.watchManager.stopCapturingGroupingWatches(this.currentGroupingScope);
            this.currentGroupFeed.close();
        }
        super.close();
    }
}

