/*
 * Decompiled with CFR 0.152.
 */
package marmot.morph.mapper.czech;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import marmot.morph.mapper.czech.MsdReader;
import marmot.morph.mapper.czech.MsdTag;
import marmot.morph.mapper.czech.PdTMsdMapper;
import marmot.morph.mapper.czech.PdtMorphTag;
import marmot.morph.mapper.czech.PdtMorphTagReader;
import marmot.util.LineIterator;

public class Mapping {
    Map<String, Map<String, Set<PdtMorphTag>>> map_ = new HashMap<String, Map<String, Set<PdtMorphTag>>>();

    public void init_fst_map(String filename) {
        LineIterator iterator2 = new LineIterator(filename);
        this.map_ = new HashMap<String, Map<String, Set<PdtMorphTag>>>();
        while (iterator2.hasNext()) {
            Object line = iterator2.next();
            if (line.isEmpty()) continue;
            String form = (String)line.get(0);
            Map lemmas = this.map_.computeIfAbsent(form, k -> new HashMap());
            String lemma = (String)line.get(1);
            Set tags = lemmas.computeIfAbsent(lemma, k -> new HashSet());
            String tag = (String)line.get(2);
            String feat = (String)line.get(3);
            PdtMorphTagReader reader = new PdtMorphTagReader();
            PdtMorphTag pdt_tag = reader.parse_positional(tag + feat);
            tags.add(pdt_tag);
        }
    }

    public void create_mapping(String mte_file) {
        LineIterator iter = new LineIterator(mte_file);
        MsdReader reader = new MsdReader();
        PdTMsdMapper mapper = new PdTMsdMapper();
        while (iter.hasNext()) {
            String form;
            Map<String, Set<PdtMorphTag>> map2;
            Object line = iter.next();
            if (line.isEmpty() || (map2 = this.map_.get(form = (String)line.get(0))) == null) continue;
            String lemma = (String)line.get(1);
            Set<PdtMorphTag> set = this.getLemmaSet(map2, lemma);
            String msd_tag_string = (String)line.get(2);
            MsdTag msd_tag = reader.parse(msd_tag_string);
            if (set.size() != 1) continue;
            PdtMorphTag pdt_tag = set.iterator().next();
            MsdTag msd_tag_mapped = mapper.map(pdt_tag);
            if (pdt_tag.gender_ != PdtMorphTag.Gender.q) continue;
            System.err.println(form + " " + pdt_tag.toHumanMorphString() + " " + msd_tag_mapped.toHumanString() + " " + msd_tag.toHumanString());
        }
    }

    private Set<PdtMorphTag> getLemmaSet(Map<String, Set<PdtMorphTag>> map2, String lemma) {
        Set<PdtMorphTag> set = map2.get(lemma);
        if (set != null) {
            return set;
        }
        set = new HashSet<PdtMorphTag>();
        for (Set<PdtMorphTag> current_set : map2.values()) {
            set.addAll(current_set);
        }
        return set;
    }

    public static void main(String[] args2) {
        Mapping m4 = new Mapping();
        m4.init_fst_map(args2[1]);
        m4.create_mapping(args2[0]);
    }
}

