/*
 * Decompiled with CFR 0.152.
 */
package marmot.morph.mapper.czech;

import marmot.morph.mapper.czech.MsdTag;
import marmot.morph.mapper.czech.PdtMorphTag;

public class PdTMsdMapper {
    public MsdTag map(PdtMorphTag tag) {
        MsdTag msd_tag = new MsdTag();
        this.setPos(msd_tag, tag);
        this.setTense(msd_tag, tag);
        this.setPerson(msd_tag, tag);
        this.setNumber(msd_tag, tag);
        this.setGender(msd_tag, tag);
        this.setNumber(msd_tag, tag);
        this.setGender(msd_tag, tag);
        this.setVoice(msd_tag, tag);
        this.setDegree(msd_tag, tag);
        this.setCase(msd_tag, tag);
        return msd_tag;
    }

    private void setCase(MsdTag msd_tag, PdtMorphTag tag) {
        switch (tag.case_) {
            case nom: {
                msd_tag.case_ = MsdTag.Case.n;
                break;
            }
            case gen: {
                msd_tag.case_ = MsdTag.Case.g;
                break;
            }
            case dat: {
                msd_tag.case_ = MsdTag.Case.d;
                break;
            }
            case acc: {
                msd_tag.case_ = MsdTag.Case.a;
                break;
            }
            case loc: {
                msd_tag.case_ = MsdTag.Case.l;
                break;
            }
            case voc: {
                msd_tag.case_ = MsdTag.Case.v;
                break;
            }
            case ins: {
                msd_tag.case_ = MsdTag.Case.i;
                break;
            }
        }
    }

    private void setDegree(MsdTag msd_tag, PdtMorphTag tag) {
        switch (tag.degree_) {
            case pos: {
                msd_tag.degree_ = MsdTag.Degree.p;
                break;
            }
            case comp: {
                msd_tag.degree_ = MsdTag.Degree.c;
                break;
            }
            case sup: {
                msd_tag.degree_ = MsdTag.Degree.s;
                break;
            }
        }
    }

    private void setVoice(MsdTag msd_tag, PdtMorphTag tag) {
        switch (tag.voice_) {
            case a: {
                msd_tag.voice_ = MsdTag.Voice.a;
                break;
            }
            case p: {
                msd_tag.voice_ = MsdTag.Voice.p;
                break;
            }
        }
    }

    private void setGender(MsdTag msd_tag, PdtMorphTag tag) {
        switch (tag.gender_) {
            case f: {
                msd_tag.gender_ = MsdTag.Gender.f;
                break;
            }
            case i: 
            case m: 
            case y: {
                msd_tag.gender_ = MsdTag.Gender.m;
                break;
            }
            case n: {
                msd_tag.gender_ = MsdTag.Gender.n;
                break;
            }
            case q: {
                if (msd_tag.number_ == MsdTag.Number.s) {
                    msd_tag.gender_ = MsdTag.Gender.f;
                }
                if (msd_tag.number_ != MsdTag.Number.p) break;
                msd_tag.gender_ = MsdTag.Gender.n;
                break;
            }
            case t: {
                if (msd_tag.number_ != MsdTag.Number.s) break;
                msd_tag.gender_ = MsdTag.Gender.m;
                break;
            }
        }
    }

    private void setNumber(MsdTag msd_tag, PdtMorphTag tag) {
        switch (tag.number_) {
            case s: {
                msd_tag.number_ = MsdTag.Number.s;
                break;
            }
            case p: {
                msd_tag.number_ = MsdTag.Number.p;
                break;
            }
            case d: {
                msd_tag.number_ = MsdTag.Number.d;
                break;
            }
            case w: {
                if (msd_tag.gender_ == MsdTag.Gender.f) {
                    msd_tag.number_ = MsdTag.Number.s;
                }
                if (msd_tag.gender_ != MsdTag.Gender.n) break;
                msd_tag.number_ = MsdTag.Number.p;
                break;
            }
        }
    }

    private void setPerson(MsdTag msd_tag, PdtMorphTag tag) {
        switch (tag.person_) {
            case fst: {
                msd_tag.person_ = MsdTag.Person.fst;
                break;
            }
            case snd: {
                msd_tag.person_ = MsdTag.Person.snd;
                break;
            }
            case thd: {
                msd_tag.person_ = MsdTag.Person.thd;
                break;
            }
        }
    }

    private void setTense(MsdTag msd_tag, PdtMorphTag tag) {
        switch (tag.tense_) {
            case f: {
                msd_tag.tense_ = MsdTag.Tense.f;
                break;
            }
            case h: {
                break;
            }
            case p: {
                msd_tag.tense_ = MsdTag.Tense.p;
                break;
            }
            case r: {
                msd_tag.tense_ = MsdTag.Tense.s;
                break;
            }
        }
    }

    private void setPos(MsdTag msd_tag, PdtMorphTag tag) {
        switch (tag.pos_) {
            case a: {
                msd_tag.pos_ = MsdTag.Pos.a;
                break;
            }
            case c: {
                msd_tag.pos_ = MsdTag.Pos.m;
                break;
            }
            case d: {
                msd_tag.pos_ = MsdTag.Pos.r;
                break;
            }
            case i: {
                msd_tag.pos_ = MsdTag.Pos.i;
                break;
            }
            case j: {
                msd_tag.pos_ = MsdTag.Pos.c;
                break;
            }
            case n: {
                msd_tag.pos_ = MsdTag.Pos.n;
                break;
            }
            case p: {
                msd_tag.pos_ = MsdTag.Pos.p;
                break;
            }
            case v: {
                msd_tag.pos_ = MsdTag.Pos.v;
                break;
            }
            case r: {
                msd_tag.pos_ = MsdTag.Pos.s;
                break;
            }
            case t: {
                msd_tag.pos_ = MsdTag.Pos.q;
                break;
            }
            case z: {
                msd_tag.pos_ = MsdTag.Pos.z;
                break;
            }
            case x: {
                break;
            }
        }
    }
}

