/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.parallel;

import com.saxonica.ee.parallel.MultithreadedContextMappingIterator;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.PullElaborator;
import net.sf.saxon.expr.elab.PullEvaluator;
import net.sf.saxon.expr.elab.StringEvaluator;
import net.sf.saxon.expr.elab.UpdateEvaluator;
import net.sf.saxon.expr.instruct.ForEach;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.om.FocusIterator;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;

public class MultithreadedForEach
extends ForEach {
    public MultithreadedForEach(Expression select, Expression action, boolean containsTailCall, Expression threads) {
        super(select, action, false, threads);
    }

    @Override
    public boolean isMultiThreaded(Configuration config) {
        return true;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        Expression e2 = super.optimize(visitor, contextInfo);
        if (e2 != this) {
            return e2;
        }
        for (Expression e = this.getParentExpression(); e != null; e = e.getParentExpression()) {
            if (!(e instanceof LetExpression) || !ExpressionTool.dependsOnVariable(this.getAction(), new Binding[]{(LetExpression)e})) continue;
            ((LetExpression)e).setNeedsEagerEvaluation(true);
        }
        return this;
    }

    @Override
    public Expression copy(RebindingMap rebindings) {
        MultithreadedForEach result = new MultithreadedForEach(this.getSelect().copy(rebindings), this.getAction().copy(rebindings), this.containsTailCall, this.getThreads());
        result.setInstruction(this.isInstruction());
        return result;
    }

    @Override
    public int getImplementationMethod() {
        return 4;
    }

    private int evaluateThreads(XPathContext context) throws XPathException {
        if (this.threadsOp == null) {
            return 1;
        }
        String threadsValue = this.getThreads().evaluateAsString(context).toString();
        int threads = 0;
        try {
            threads = Integer.parseInt(threadsValue);
        }
        catch (NumberFormatException e) {
            throw new XPathException("Value of 'threads' is not an integer (" + threadsValue + ")").withLocation(this.getLocation()).withXPathContext(context);
        }
        return threads;
    }

    @Override
    public SequenceIterator iterate(XPathContext context) throws XPathException {
        return this.makeElaborator().elaborateForPull().iterate(context);
    }

    @Override
    public String getExpressionName() {
        return "multithreadedForEach";
    }

    @Override
    protected void explainThreads(ExpressionPresenter out) throws XPathException {
        out.setChildRole("threads");
        this.getThreads().export(out);
    }

    @Override
    public Elaborator getElaborator() {
        return new MultithreadedForEachElaborator();
    }

    public static class MultithreadedForEachElaborator
    extends PullElaborator {
        private StringEvaluator makeThreadsEvaluator(MultithreadedForEach forEach) {
            if (forEach.threadsOp == null) {
                return context -> "1";
            }
            return forEach.getThreads().makeElaborator().elaborateForString(true);
        }

        private int evaluateThreads(MultithreadedForEach forEach, StringEvaluator threadsEvaluator, XPathContext context) throws XPathException {
            int threads;
            if (forEach.threadsOp == null) {
                return 1;
            }
            String threadsValue = threadsEvaluator.eval(context);
            try {
                threads = Integer.parseInt(threadsValue);
            }
            catch (NumberFormatException e) {
                throw new XPathException("Value of 'threads' is not an integer (" + threadsValue + ")").withLocation(forEach.getLocation()).withXPathContext(context);
            }
            return threads;
        }

        @Override
        public PullEvaluator elaborateForPull() {
            MultithreadedForEach forEach = (MultithreadedForEach)this.getExpression();
            PullEvaluator select = forEach.getSelectExpression().makeElaborator().elaborateForPull();
            PullEvaluator action = forEach.getActionExpression().makeElaborator().elaborateForPull();
            StringEvaluator threadsEvaluator = this.makeThreadsEvaluator(forEach);
            return context -> {
                int threads = this.evaluateThreads(forEach, threadsEvaluator, context);
                XPathContextMinor c2 = context.newMinorContext();
                SequenceIterator iter = select.iterate(context);
                FocusIterator fit = c2.getController().makeFocusTracker(iter, true);
                c2.setCurrentIterator(fit);
                return new MultithreadedContextMappingIterator(action, c2, threads);
            };
        }

        @Override
        public UpdateEvaluator elaborateForUpdate() {
            throw new UnsupportedOperationException("Multi-threading is not supported for updating expressions");
        }
    }
}

