/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.xsltextn.style;

import com.saxonica.xsltextn.instruct.DeepUpdate;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.ExtensionInstruction;
import net.sf.saxon.trans.XPathException;

public class SaxonDeepUpdate
extends ExtensionInstruction {
    private Expression root;
    private Expression select;
    private Expression action;

    @Override
    protected boolean mayContainSequenceConstructor() {
        return false;
    }

    @Override
    protected void prepareAttributes() {
        block10: for (AttributeInfo att : this.attributes()) {
            NodeName attName = att.getNodeName();
            String f = attName.getDisplayName();
            String value = att.getValue();
            switch (f) {
                case "root": {
                    this.root = this.makeExpression(value, att);
                    continue block10;
                }
                case "select": {
                    this.select = this.makeExpression(value, att);
                    continue block10;
                }
                case "action": {
                    this.action = this.makeExpression(value, att);
                    continue block10;
                }
            }
            this.checkUnknownAttribute(attName);
        }
        if (this.root == null) {
            this.reportAbsence("root");
        }
        if (this.select == null) {
            this.reportAbsence("select");
        }
        if (this.action == null) {
            this.reportAbsence("action");
        }
    }

    @Override
    public void validate(ComponentDeclaration decl) throws XPathException {
        this.getConfiguration().checkLicensedFeature(8, "saxon:deep-update", this.getPackageData().getLocalLicenseId());
        this.root = this.typeCheck("root", this.root);
        this.select = this.typeCheck("select", this.select);
        this.action = this.typeCheck("action", this.action);
    }

    @Override
    public Expression compile(Compilation exec, ComponentDeclaration decl) throws XPathException {
        return new DeepUpdate(this.root, this.select, this.action);
    }
}

