/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.jaxp;

import javax.xml.validation.TypeInfoProvider;
import net.sf.saxon.dom.TypeInfoImpl;
import net.sf.saxon.event.ContentHandlerProxy;
import net.sf.saxon.event.ReceiverOption;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.NamespaceMap;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import org.w3c.dom.TypeInfo;
import org.xml.sax.ContentHandler;

public class TypedContentHandler
extends ContentHandlerProxy {
    private SchemaType pendingElementTypeCode = null;
    private AttributeMap pendingAttributes = null;

    public TypedContentHandler(ContentHandler handler) {
        super(handler);
    }

    public TypeInfoProvider getTypeInfoProvider() {
        return new TypeInfoProviderImpl();
    }

    @Override
    public boolean usesTypeAnnotations() {
        return true;
    }

    @Override
    public void startElement(NodeName elemName, SchemaType type, AttributeMap attributes, NamespaceMap namespaces, Location location, int properties) throws XPathException {
        this.pendingElementTypeCode = type;
        this.pendingAttributes = attributes;
        super.startElement(elemName, type, attributes, namespaces, location, properties);
    }

    public class TypeInfoProviderImpl
    extends TypeInfoProvider {
        @Override
        public TypeInfo getElementTypeInfo() {
            if (TypedContentHandler.this.pendingElementTypeCode == null) {
                return new TypeInfoImpl(TypedContentHandler.this.getConfiguration(), AnyType.getInstance());
            }
            return new TypeInfoImpl(TypedContentHandler.this.getConfiguration(), TypedContentHandler.this.pendingElementTypeCode);
        }

        @Override
        public TypeInfo getAttributeTypeInfo(int index) {
            if (index < 0 || index > TypedContentHandler.this.pendingAttributes.size()) {
                throw new IndexOutOfBoundsException("" + index);
            }
            SimpleType type = TypedContentHandler.this.pendingAttributes.itemAt(index).getType();
            return new TypeInfoImpl(TypedContentHandler.this.getConfiguration(), type);
        }

        @Override
        public boolean isIdAttribute(int index) {
            return TypedContentHandler.this.pendingAttributes.itemAt(index).isId();
        }

        @Override
        public boolean isSpecified(int index) {
            return !ReceiverOption.contains(TypedContentHandler.this.pendingAttributes.itemAt(index).getProperties(), 8);
        }
    }
}

