/*
 * Decompiled with CFR 0.152.
 */
package marmot.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import marmot.util.FileUtils;

public class LineIterator
implements Iterator<List<String>> {
    private static final String DefaultSeperator_ = "\\s+";
    protected BufferedReader reader_;
    protected String seperator_;

    public LineIterator(String filename) {
        this(filename, DefaultSeperator_);
    }

    public LineIterator(InputStream in) {
        this(in, DefaultSeperator_);
    }

    public LineIterator(InputStream in, String seperator) {
        this.seperator_ = seperator;
        try {
            this.reader_ = FileUtils.openStream(in);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public LineIterator(String filename, String seperator) {
        this.seperator_ = seperator;
        try {
            this.reader_ = FileUtils.openFile(filename);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean hasNext() {
        try {
            return this.reader_.ready();
        }
        catch (IOException e) {
            throw new RuntimeException("IOException: " + e);
        }
    }

    @Override
    public List<String> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        try {
            String line = this.reader_.readLine();
            String[] tokens = line.split(this.seperator_);
            ArrayList<String> list = new ArrayList<String>(tokens.length);
            for (String token2 : tokens) {
                if (token2.isEmpty()) continue;
                list.add(token2);
            }
            return list;
        }
        catch (IOException e) {
            throw new RuntimeException("IOException: " + e);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

