/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.ToPushCompiler;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import com.saxonica.ee.bytecode.util.OnEmpty;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.instruct.SimpleNodeConstructor;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.tree.util.Orphan;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Cardinality;

public abstract class SimpleNodeConstructorCompiler
extends ToPushCompiler {
    @Override
    public void compileToPush(CompilerService compiler, Expression expression) throws CannotCompileException {
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        SimpleNodeConstructorCompiler.visitAnnotation(compiler, "SimpleNodeConstructorCompiler-Push");
        SimpleNodeConstructor simpleNode = (SimpleNodeConstructor)expression;
        compiler.generateGetReceiver();
        this.compileNodeName(compiler, expression);
        Expression content = simpleNode.getSelect();
        compiler.compileToPrimitive(content, CharSequence.class, OnEmpty.RETURN_NULL);
        LabelInfo done = null;
        if (Cardinality.allowsZero(content.getCardinality())) {
            LabelInfo notNull = methodInfo.newLabel("simpleNodeNotNull");
            ga.dup();
            ga.ifNonNull(notNull.label());
            ga.pop();
            if (this.isNoNodeIfEmpty(expression)) {
                done = methodInfo.newLabel("doneSimpleNode");
                ga.pop();
                ga.goTo(done);
            } else {
                ga.push("");
            }
            methodInfo.placeLabel(notNull);
        }
        this.checkContent(compiler, expression);
        this.pushNode(compiler, expression);
        if (done != null) {
            methodInfo.placeLabel(done);
        }
    }

    protected boolean isNoNodeIfEmpty(Expression expr) {
        return false;
    }

    protected void checkContent(CompilerService compiler, Expression expression) {
    }

    protected void compileNodeName(CompilerService compiler, Expression expression) throws CannotCompileException {
    }

    protected abstract void pushNode(CompilerService var1, Expression var2);

    protected boolean isNamedNodeKind() {
        return false;
    }

    @Override
    public void compileToItem(CompilerService compiler, Expression expression) throws CannotCompileException {
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        SimpleNodeConstructorCompiler.visitAnnotation(compiler, "SimpleNodeConstructorCompiler-Push");
        SimpleNodeConstructor simpleNode = (SimpleNodeConstructor)expression;
        Configuration config = compiler.getConfiguration();
        TypeHierarchy th = config.getTypeHierarchy();
        ga.newInstance(Orphan.class);
        ga.dup();
        SimpleNodeConstructorCompiler.allocateStatic(compiler, config);
        ga.invokeConstructor(Orphan.class, Configuration.class);
        ga.dup();
        ga.push((short)simpleNode.getItemType().getPrimitiveType());
        ga.invokeInstanceMethod(Orphan.class, "setNodeKind", Short.TYPE);
        if (this.isNamedNodeKind()) {
            ga.dup();
            ga.newInstance(FingerprintedQName.class);
            ga.dup();
            this.compileNodeName(compiler, expression);
            ga.push("");
            ga.swap();
            ga.push("");
            ga.swap();
            ga.invokeConstructor(FingerprintedQName.class, String.class, String.class, String.class);
            ga.invokeInstanceMethod(Orphan.class, "setNodeName", NodeName.class);
        }
        ga.dup();
        Expression content = simpleNode.getSelect();
        compiler.compileToPrimitive(content, CharSequence.class, OnEmpty.RETURN_EMPTY_STRING);
        this.checkContent(compiler, expression);
        ga.invokeInstanceMethod(Orphan.class, "setStringValue", CharSequence.class);
    }
}

