/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.xtupdate;

import com.saxonica.ee.update.RenameExpression;
import com.saxonica.ee.xtupdate.SaxonUpdate;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.InscopeNamespaceResolver;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.trans.XPathException;

public class SaxonRename
extends StyleElement {
    private Expression select;
    private Expression newName;

    @Override
    public boolean isInstruction() {
        return true;
    }

    @Override
    public boolean mayContainSequenceConstructor() {
        return false;
    }

    @Override
    public void prepareAttributes() throws XPathException {
        String selectAtt = null;
        String toAtt = null;
        AttributeCollection atts = this.getAttributeList();
        for (int a = 0; a < atts.getLength(); ++a) {
            String f = atts.getQName(a);
            if (f.equals("select")) {
                selectAtt = atts.getValue(a);
                this.select = this.makeExpression(selectAtt, a);
                continue;
            }
            if (f.equals("to")) {
                toAtt = atts.getValue(a);
                this.newName = this.makeExpression(toAtt, a);
                continue;
            }
            this.checkUnknownAttribute(atts.getNodeName(a));
        }
        if (selectAtt == null) {
            this.select = new ContextItemExpression();
            this.select.setLocation(this.allocateLocation());
        }
        if (toAtt == null) {
            this.reportAbsence("to");
        }
    }

    @Override
    public void validate(ComponentDeclaration decl) throws XPathException {
        this.getConfiguration().checkLicensedFeature(2, "saxon:rename", this.getPackageData().getLocalLicenseId());
        this.select = this.typeCheck("select", this.select);
        this.newName = this.typeCheck("to", this.newName);
        SaxonUpdate.checkContainment(this);
    }

    @Override
    public Expression compile(Compilation exec, ComponentDeclaration decl) throws XPathException {
        return new RenameExpression(this.select, this.newName, new InscopeNamespaceResolver(this), this.getDefaultXPathNamespace());
    }
}

