/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.query.spans;

import de.ids_mannheim.korap.query.spans.ClassSpans;
import de.ids_mannheim.korap.query.spans.SimpleSpans;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.lucene.search.spans.Spans;

public class CandidateSpan
implements Comparable<CandidateSpan>,
Cloneable {
    protected int doc;
    protected int start;
    protected int end;
    private long cost;
    private Collection<byte[]> payloads;
    private int position;
    private CandidateSpan childSpan;
    private CandidateSpan secondChildSpan;
    protected short spanId;
    protected boolean hasSpanId;
    private short leftId;
    private short rightId;
    private int leftStart;
    private int leftEnd;
    private int rightStart;
    private int rightEnd;
    protected byte payloadTypeIdentifier;

    public CandidateSpan(Spans span) throws IOException {
        this.doc = span.doc();
        this.start = span.start();
        this.end = span.end();
        this.cost = span.cost();
        this.payloads = new ArrayList<byte[]>();
        if (span.isPayloadAvailable()) {
            this.setPayloads(span.getPayload());
        }
        if (span instanceof SimpleSpans) {
            SimpleSpans temp = (SimpleSpans)span;
            this.spanId = temp.getSpanId();
            this.hasSpanId = temp.hasSpanId;
        } else if (span instanceof ClassSpans) {
            this.spanId = ((ClassSpans)span).getNumber();
            this.hasSpanId = true;
        }
    }

    public CandidateSpan(Spans span, int position) throws IOException {
        this(span);
        this.position = position;
    }

    public CandidateSpan(int start, int end, int doc, long cost, Collection<byte[]> payloads) {
        this.start = start;
        this.end = end;
        this.doc = doc;
        this.cost = cost;
        if (payloads != null) {
            this.setPayloads(payloads);
        }
    }

    protected CandidateSpan clone() throws CloneNotSupportedException {
        return new CandidateSpan(this.start, this.end, this.doc, this.cost, this.payloads);
    }

    public int getDoc() {
        return this.doc;
    }

    public void setDoc(int doc) {
        this.doc = doc;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getEnd() {
        return this.end;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    public Collection<byte[]> getPayloads() {
        return this.payloads;
    }

    public void setPayloads(Collection<byte[]> payloads) {
        this.payloads = new ArrayList<byte[]>();
        for (byte[] b : payloads) {
            if (b == null) {
                this.payloads.add(null);
                continue;
            }
            this.payloads.add((byte[])b.clone());
        }
    }

    public long getCost() {
        return this.cost;
    }

    public void setCost(long cost) {
        this.cost = cost;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public CandidateSpan getChildSpan() {
        return this.childSpan;
    }

    public void setChildSpan(CandidateSpan childSpan) {
        this.childSpan = childSpan;
    }

    public CandidateSpan getSecondChildSpan() {
        return this.secondChildSpan;
    }

    public void setSecondChildSpan(CandidateSpan secondChildSpan) {
        this.secondChildSpan = secondChildSpan;
    }

    public short getSpanId() {
        return this.spanId;
    }

    public void setSpanId(short spanId) {
        this.spanId = spanId;
        if (spanId > 0) {
            this.hasSpanId = true;
        }
    }

    public short getLeftId() {
        return this.leftId;
    }

    public void setLeftId(short leftId) {
        this.leftId = leftId;
    }

    public short getRightId() {
        return this.rightId;
    }

    public void setRightId(short rightId) {
        this.rightId = rightId;
    }

    public int getLeftStart() {
        return this.leftStart;
    }

    public void setLeftStart(int leftStart) {
        this.leftStart = leftStart;
    }

    public int getLeftEnd() {
        return this.leftEnd;
    }

    public void setLeftEnd(int leftEnd) {
        this.leftEnd = leftEnd;
    }

    public int getRightStart() {
        return this.rightStart;
    }

    public void setRightStart(int rightStart) {
        this.rightStart = rightStart;
    }

    public int getRightEnd() {
        return this.rightEnd;
    }

    public void setRightEnd(int rightEnd) {
        this.rightEnd = rightEnd;
    }

    public byte getPayloadTypeIdentifier() {
        return this.payloadTypeIdentifier;
    }

    public void setPayloadTypeIdentifier(byte payloadTypeIdentifier) {
        this.payloadTypeIdentifier = payloadTypeIdentifier;
    }

    @Override
    public int compareTo(CandidateSpan o) {
        if (this.doc == o.doc) {
            if (this.getStart() == o.getStart()) {
                if (this.getEnd() == o.getEnd()) {
                    return 0;
                }
                if (this.getEnd() > o.getEnd()) {
                    return 1;
                }
                return -1;
            }
            if (this.getStart() < o.getStart()) {
                return -1;
            }
            return 1;
        }
        if (this.doc < o.doc) {
            return -1;
        }
        return 1;
    }

    public String toString() {
        return this.getClass().getName() + "@" + this.doc + ":" + this.start + "-" + this.end;
    }
}

