/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.qt4;

import java.util.ArrayList;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.Reverse;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.SequenceExtent;

public class Slice
extends SystemFunction {
    @Override
    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        return Slice.slice(arguments);
    }

    public static GroundedValue slice(Sequence[] arguments) throws XPathException {
        int stepVal;
        int endVal;
        int startVal;
        GroundedValue input = arguments[0].materialize();
        int length = input.getLength();
        if (length == 0) {
            return input;
        }
        IntegerValue start = (IntegerValue)arguments[1].head();
        IntegerValue end = (IntegerValue)arguments[2].head();
        IntegerValue step = (IntegerValue)arguments[3].head();
        int s = start == null ? 1 : ((startVal = (int)start.longValue()) == 0 ? 1 : (startVal < 0 ? length + startVal + 1 : startVal));
        int e = end == null ? length : ((endVal = (int)end.longValue()) == 0 ? length : (endVal < 0 ? length + endVal + 1 : endVal));
        int st = 1;
        int n = stepVal = step == null ? 0 : (int)step.longValue();
        st = stepVal == 0 ? (e >= s ? 1 : -1) : stepVal;
        if (st < 0) {
            SequenceExtent.Of<Item> reversed = SequenceExtent.from(Reverse.getReverseIterator(input.iterate()));
            return Slice.positiveSlice(reversed, length - s + 1, length - e + 1, -st);
        }
        return Slice.positiveSlice(input, s, e, st);
    }

    private static GroundedValue positiveSlice(GroundedValue input, int start, int end, int step) {
        ArrayList<Item> result = new ArrayList<Item>(input.getLength());
        for (int i = 0; i < input.getLength(); ++i) {
            int pos = i + 1;
            if (pos < start || pos > end || (pos - start) % step != 0) continue;
            result.add(input.itemAt(i));
        }
        return SequenceExtent.makeSequenceExtent(result);
    }
}

