/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.update;

import com.saxonica.ee.update.BasicUpdatingExpression;
import com.saxonica.ee.update.PendingUpdateListImpl;
import com.saxonica.ee.update.ReplaceAttributeAction;
import com.saxonica.ee.update.ReplaceNodeAction;
import com.saxonica.ee.validate.SkipValidator;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.TreeReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.ItemEvaluator;
import net.sf.saxon.expr.elab.PullEvaluator;
import net.sf.saxon.expr.elab.UpdateElaborator;
import net.sf.saxon.expr.elab.UpdateEvaluator;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Loc;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.EmptyAttributeMap;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.MutableNodeInfo;
import net.sf.saxon.om.NameOfNode;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.linked.NodeImpl;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.value.SequenceType;

public class ReplaceNodeExpression
extends BasicUpdatingExpression {
    private final Operand targetOp;
    private final Operand replacementOp;
    private final int constructionMode;
    private final boolean inheritNamespaces;

    public ReplaceNodeExpression(Expression target, Expression replacement, int constructionMode, boolean inheritNamespaces) {
        this.targetOp = new Operand(this, target, OperandRole.INSPECT);
        this.replacementOp = new Operand(this, replacement, OperandRole.SINGLE_ATOMIC);
        this.constructionMode = constructionMode;
        this.inheritNamespaces = inheritNamespaces;
    }

    public Expression getTargetExp() {
        return this.targetOp.getChildExpression();
    }

    public void setTargetExp(Expression targetExpression) {
        this.targetOp.setChildExpression(targetExpression);
    }

    public Expression getReplacementExp() {
        return this.replacementOp.getChildExpression();
    }

    public void setReplacementExp(Expression replacement) {
        this.replacementOp.setChildExpression(replacement);
    }

    @Override
    public Iterable<Operand> operands() {
        return this.operandList(this.targetOp, this.replacementOp);
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.typeCheckChildren(visitor, contextInfo);
        TypeChecker tc = visitor.getConfiguration().getTypeChecker(false);
        Supplier<RoleDiagnostic> roleSupplier0 = () -> {
            RoleDiagnostic role0 = new RoleDiagnostic(10, "replace", 0);
            role0.setErrorCode("XUDY0027");
            return role0;
        };
        this.setTargetExp(tc.staticTypeCheck(this.getTargetExp(), SequenceType.NON_EMPTY_SEQUENCE, roleSupplier0, visitor));
        Supplier<RoleDiagnostic> roleSupplier1 = () -> {
            RoleDiagnostic role0 = new RoleDiagnostic(10, "replace", 0);
            role0.setErrorCode("XUTY0008");
            return role0;
        };
        this.setTargetExp(tc.staticTypeCheck(this.getTargetExp(), SequenceType.OPTIONAL_NODE, roleSupplier1, visitor));
        return this;
    }

    @Override
    public Expression copy(RebindingMap rebindings) {
        ReplaceNodeExpression exp = new ReplaceNodeExpression(this.getTargetExp().copy(rebindings), this.getReplacementExp().copy(rebindings), this.constructionMode, this.inheritNamespaces);
        ExpressionTool.copyLocationInfo(this, exp);
        return exp;
    }

    @Override
    public void export(ExpressionPresenter out) throws XPathException {
        out.startElement("replaceNodes", this);
        out.emitAttribute("constructionMode", this.constructionMode + "");
        if (this.inheritNamespaces) {
            out.emitAttribute("flags", "i");
        }
        this.getTargetExp().export(out);
        this.getReplacementExp().export(out);
        out.endElement();
    }

    @Override
    public String getExpressionName() {
        return "replaceNode";
    }

    @Override
    public Elaborator getElaborator() {
        return new ReplaceNodeExpressionElaborator();
    }

    private static class ReplaceNodeExpressionElaborator
    extends UpdateElaborator {
        private ReplaceNodeExpressionElaborator() {
        }

        @Override
        public UpdateEvaluator elaborateForUpdate() {
            ReplaceNodeExpression expr = (ReplaceNodeExpression)this.getExpression();
            ItemEvaluator targetEval = expr.getTargetExp().makeElaborator().elaborateForItem();
            PullEvaluator replacementEval = expr.getReplacementExp().makeElaborator().elaborateForPull();
            return (context, pul) -> {
                ArrayList<Item> content = new ArrayList<Item>();
                NodeInfo target = (NodeInfo)targetEval.eval(context);
                if (target == null) {
                    throw new XPathException("Target of replace expression must not be empty", "XUDY0027").withLocation(expr.getLocation());
                }
                if (!target.getTreeInfo().isMutable()) {
                    throw new XPathException("Attempting to update a non-updatable tree", "SXUP0081");
                }
                int kind = target.getNodeKind();
                if (kind == 13) {
                    throw new XPathException("Target of replace expression must not be a namespace node", "XUTY0008").withLocation(expr.getLocation());
                }
                if (kind == 9) {
                    throw new XPathException("Target of replace expression must not be a document node", "XUTY0008").withLocation(expr.getLocation());
                }
                NodeInfo parent = target.getParent();
                if (parent == null) {
                    throw new XPathException("Target node of replace expression has no parent", "XUDY0009").withLocation(expr.getLocation());
                }
                if (!(parent instanceof MutableNodeInfo)) {
                    throw new XPathException("Target node of replace expression is not updatable", "SXUP0081").withLocation(expr.getLocation());
                }
                if (kind == 2) {
                    Item item;
                    SequenceIterator iter = replacementEval.iterate(context);
                    AttributeMap atts = EmptyAttributeMap.getInstance();
                    while ((item = iter.next()) != null) {
                        SimpleType attributeType;
                        boolean isAttribute;
                        boolean bl = isAttribute = item instanceof NodeInfo && ((NodeInfo)item).getNodeKind() == 2;
                        if (!isAttribute) {
                            throw new XPathException("The replacement nodes for an attribute must all be attributes", "XUTY0011").withLocation(expr.getLocation());
                        }
                        NodeInfo att = (NodeInfo)item;
                        int properties = 0;
                        if (expr.constructionMode == 4 || Untyped.getInstance().equals(parent.getSchemaType())) {
                            attributeType = BuiltInAtomicType.UNTYPED_ATOMIC;
                        } else {
                            attributeType = (SimpleType)att.getSchemaType();
                            if (att.isId() || att.getLocalPart().equals("id") && att.getNamespaceUri().equals(NamespaceUri.XML)) {
                                properties |= 0x800;
                            }
                            if (att.isIdref()) {
                                properties |= 0x1000;
                            }
                        }
                        atts = atts.put(new AttributeInfo(NameOfNode.makeName(att), attributeType, att.getStringValue(), Loc.NONE, properties));
                    }
                    ReplaceAttributeAction action = new ReplaceAttributeAction(parent, target, atts, expr.inheritNamespaces);
                    action.setOriginator(expr);
                    ((PendingUpdateListImpl)pul).add(action);
                } else {
                    GroundedValue extent;
                    Item item;
                    SequenceIterator iter = replacementEval.iterate(context);
                    while ((item = iter.next()) != null) {
                        if (item instanceof NodeInfo && ((NodeInfo)item).getNodeKind() == 2) {
                            throw new XPathException("An attribute node cannot replace a node that is not itself an attribute", "XUTY0010").withLocation(expr.getLocation());
                        }
                        content.add(item);
                    }
                    if (content.isEmpty()) {
                        try {
                            ReplaceNodeAction action = new ReplaceNodeAction(new NodeImpl[0], (MutableNodeInfo)target, expr.inheritNamespaces);
                            action.setOriginator(expr);
                            ((PendingUpdateListImpl)pul).add(action);
                        }
                        catch (XPathException e) {
                            throw e.maybeWithLocation(expr.getLocation()).maybeWithContext(context);
                        }
                    }
                    Builder builder = ((MutableNodeInfo)parent).newBuilder();
                    Controller controller = context.getController();
                    builder.setLineNumbering(controller.getConfiguration().isLineNumbering());
                    PipelineConfiguration pipe = controller.makePipelineConfiguration();
                    pipe.setXPathContext(context);
                    pipe.setHostLanguage(expr.getPackageData().getHostLanguage());
                    builder.setPipelineConfiguration(pipe);
                    Receiver r = builder;
                    if (expr.constructionMode == 4 || Untyped.getInstance().equals(parent.getSchemaType())) {
                        r = new SkipValidator(r);
                    }
                    TreeReceiver out = new TreeReceiver(r);
                    out.setPipelineConfiguration(pipe);
                    out.open();
                    out.startDocument(0);
                    for (Object e : content) {
                        Item n = (Item)e;
                        out.append(n, Loc.NONE, 524288);
                    }
                    out.endDocument();
                    out.close();
                    NodeInfo root = builder.getCurrentRoot();
                    AxisIterator axisIterator = root.iterateAxis(3);
                    try {
                        extent = SequenceTool.toGroundedValue(axisIterator);
                    }
                    catch (UncheckedXPathException e) {
                        throw e.getXPathException();
                    }
                    int len = extent.getLength();
                    NodeInfo[] array = new NodeInfo[len];
                    for (int i = 0; i < len; ++i) {
                        array[i] = (NodeInfo)extent.itemAt(i);
                    }
                    try {
                        ReplaceNodeAction action = new ReplaceNodeAction(array, (MutableNodeInfo)target, expr.inheritNamespaces);
                        action.setOriginator(expr);
                        ((PendingUpdateListImpl)pul).add(action);
                    }
                    catch (XPathException e) {
                        throw e.maybeWithLocation(expr.getLocation()).maybeWithContext(context);
                    }
                }
            };
        }
    }
}

