/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.query.spans;

import de.ids_mannheim.korap.query.SpanSegmentQuery;
import de.ids_mannheim.korap.query.spans.FocusSpans;
import de.ids_mannheim.korap.query.spans.RelationSpans;
import de.ids_mannheim.korap.query.spans.SimpleSpans;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.util.Bits;

public class SegmentSpans
extends SimpleSpans {
    private boolean isRelation;

    public SegmentSpans(SpanSegmentQuery spanSegmentQuery, LeafReaderContext context, Bits acceptDocs, Map<Term, TermContext> termContexts) throws IOException {
        super(spanSegmentQuery, context, acceptDocs, termContexts);
        if (spanSegmentQuery.isRelation()) {
            this.isRelation = true;
        }
        this.collectPayloads = true;
        this.hasMoreSpans = this.secondSpans.next();
    }

    @Override
    public boolean next() throws IOException {
        this.hasMoreSpans &= this.firstSpans.next();
        this.isStartEnumeration = false;
        this.matchPayload.clear();
        return this.advance();
    }

    protected boolean advance() throws IOException {
        while (this.hasMoreSpans && this.ensureSameDoc(this.firstSpans, this.secondSpans)) {
            int matchCase = this.findMatch();
            if (matchCase == 0) {
                this.doCollectPayloads();
                return true;
            }
            if (matchCase == 1) {
                this.hasMoreSpans = this.secondSpans.next();
                continue;
            }
            this.hasMoreSpans = this.firstSpans.next();
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected int findMatch() {
        block7: {
            block9: {
                block8: {
                    if (this.firstSpans.start() != this.secondSpans.start() || this.firstSpans.end() != this.secondSpans.end()) break block7;
                    if (!this.isRelation) break block8;
                    RelationSpans s1 = (RelationSpans)this.firstSpans;
                    if (!(this.secondSpans instanceof SimpleSpans)) {
                        this.setMatch();
                        return 0;
                    }
                    SimpleSpans s2 = (SimpleSpans)this.secondSpans;
                    if (!s2.hasSpanId) {
                        this.setMatch();
                        return 0;
                    }
                    if (s1.getLeftId() == s2.getSpanId()) {
                        this.setMatch();
                        return 0;
                    }
                    break block7;
                }
                if (!(this.firstSpans instanceof FocusSpans) || !(this.secondSpans instanceof SimpleSpans)) break block9;
                SimpleSpans s1 = (SimpleSpans)this.firstSpans;
                SimpleSpans s2 = (SimpleSpans)this.secondSpans;
                if (s1.hasSpanId && s2.hasSpanId) {
                    if (s1.getSpanId() == s2.getSpanId()) {
                        this.setSpanId(s2.getSpanId());
                        this.hasSpanId = true;
                    }
                    break block7;
                } else {
                    this.setMatch();
                    return 0;
                }
            }
            this.setMatch();
            return 0;
        }
        if (this.firstSpans.start() >= this.secondSpans.start() && this.firstSpans.end() >= this.secondSpans.end()) {
            return 1;
        }
        return -1;
    }

    private void setMatch() {
        this.matchDocNumber = this.firstSpans.doc();
        this.matchStartPosition = this.firstSpans.start();
        this.matchEndPosition = this.firstSpans.end();
    }

    private void doCollectPayloads() throws IOException {
        if (this.collectPayloads) {
            Collection<byte[]> payload;
            if (this.firstSpans.isPayloadAvailable()) {
                payload = this.firstSpans.getPayload();
                this.matchPayload.addAll(payload);
            }
            if (this.secondSpans.isPayloadAvailable()) {
                payload = this.secondSpans.getPayload();
                this.matchPayload.addAll(payload);
            }
        }
    }

    @Override
    public boolean skipTo(int target) throws IOException {
        if (this.hasMoreSpans && this.firstSpans.doc() < target && !this.firstSpans.skipTo(target)) {
            this.hasMoreSpans = false;
            return false;
        }
        this.matchPayload.clear();
        return this.advance();
    }

    @Override
    public long cost() {
        return this.firstSpans.cost() + this.secondSpans.cost();
    }
}

