/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.watch;

import com.saxonica.ee.stream.feed.SnapshotFeed;
import com.saxonica.ee.stream.om.FleetingDocumentNode;
import com.saxonica.ee.stream.om.FleetingElementNode;
import com.saxonica.ee.stream.om.FleetingNode;
import com.saxonica.ee.stream.om.FleetingParentNode;
import com.saxonica.ee.stream.watch.MultiAccumulatorWatch;
import com.saxonica.ee.stream.watch.Terminator;
import com.saxonica.ee.stream.watch.Trigger;
import com.saxonica.ee.stream.watch.Watch;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Outputter;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.ReceiverOption;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.Loc;
import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceMap;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NoNamespaceName;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.str.StringView;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.QuitParsingException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.XmlProcessingException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.UType;
import net.sf.saxon.type.ValidationException;

public class WatchManager
extends SequenceReceiver
implements NamespaceResolver {
    private static final boolean TRACING = false;
    private boolean startDocumentPending;
    private int startDocumentProperties;
    private final FleetingDocumentNode documentNode;
    private FleetingParentNode[] elementStack = new FleetingParentNode[20];
    private int[] receiverCountStack = new int[20];
    protected int elementStackTop = 0;
    private Stack<NamespaceMap> namespaceStack = new Stack();
    protected List<Watch> watchList = new ArrayList<Watch>(10);
    protected Stack<List<ClosedownAction>> activeWatchStack = new Stack();
    private final Stack<Receiver> activeReceiverStack = new Stack();
    private Location lastLocationId = Loc.NONE;
    private XPathContext context;
    private Outputter outputter;
    private MultiAccumulatorWatch multiAccumulatorWatch;
    private final List<GroupingScope> capturingScopes = new ArrayList<GroupingScope>();
    private long eventNumber = 0L;

    private void trace(String message) {
    }

    public WatchManager(PipelineConfiguration pipe) {
        super(pipe);
        Configuration config = pipe.getConfiguration();
        this.context = config.getConversionContext();
        long docNr = config.getDocumentNumberAllocator().allocateStreamedDocumentNumber();
        this.documentNode = new FleetingDocumentNode(docNr);
        this.documentNode.setConfiguration(config);
        pipe.setComponent("com.saxonica.ee.stream.watch.WatchManager", this);
    }

    public void setXPathContext(XPathContext context) {
        this.context = context;
    }

    public XPathContext getXPathContext() {
        return this.context;
    }

    public void setOutputter(Outputter outputter) {
        outputter.setPipelineConfiguration(this.getPipelineConfiguration());
        this.outputter = outputter;
    }

    public Outputter getOutputter() {
        return this.outputter;
    }

    @Override
    public void append(Item item, Location locationId, int copyNamespaces) throws XPathException {
        throw new UnsupportedOperationException("WatchManager does not implement append()");
    }

    @Override
    public void close() throws XPathException {
    }

    @Override
    public void startDocument(int properties) throws XPathException {
        if (this.elementStackTop == 0) {
            this.startDocumentPending = true;
            this.startDocumentProperties = properties;
            this.namespaceStack = new Stack();
        }
        ++this.eventNumber;
    }

    private void deferredStartDocument() throws XPathException {
        this.documentNode.setSystemId(this.getSystemId());
        this.documentNode.setMultiAccumulatorWatch(this.multiAccumulatorWatch);
        this.elementStack[this.elementStackTop] = this.documentNode;
        this.receiverCountStack[this.elementStackTop] = 0;
        ++this.elementStackTop;
        ArrayList<ClosedownAction> activeWatchList = new ArrayList<ClosedownAction>(4);
        this.activeWatchStack.push(activeWatchList);
        for (int i = 0; i < this.watchList.size(); ++i) {
            Watch watch = this.watchList.get(i);
            boolean matches = watch.matchesNode(this.documentNode, this.context);
            if (!matches) continue;
            ClosedownAction action = new ClosedownAction(watch, 0);
            activeWatchList.add(action);
            Receiver out = watch.startSelectedParentNode(this.documentNode, Loc.NONE);
            if (out == null) continue;
            out.open();
            this.activeReceiverStack.push(out);
            int n = this.elementStackTop - 1;
            this.receiverCountStack[n] = this.receiverCountStack[n] + 1;
        }
        for (Receiver out : this.activeReceiverStack) {
            this.copyUnparsedEntities(out);
            out.startDocument(this.startDocumentProperties);
        }
        this.documentNode.copyInitialCommentsAndProcessingInstructions(this);
    }

    private void copyUnparsedEntities(Receiver out) throws XPathException {
        if (this.documentNode != null) {
            Iterator<String> names = this.documentNode.getUnparsedEntityNames();
            while (names.hasNext()) {
                String name = names.next();
                String[] entity = this.documentNode.getUnparsedEntity(name);
                out.setUnparsedEntity(name, entity[0], entity[1]);
            }
        }
    }

    @Override
    public void startElement(NodeName elementName, SchemaType typeCode, AttributeMap attributes, NamespaceMap namespaces, Location location, int properties) throws XPathException {
        block9: {
            this.trace("startElement " + elementName);
            try {
                if (this.startDocumentPending) {
                    this.startDocumentPending = false;
                    this.deferredStartDocument();
                }
                ValidationException ve = null;
                this.ensureStackSpace();
                FleetingElementNode element = new FleetingElementNode(elementName, typeCode);
                FleetingDocumentNode parent = this.elementStackTop > 0 ? this.elementStack[this.elementStackTop - 1] : this.documentNode;
                element.setParent(parent);
                element.setNamespaceMap(namespaces);
                element.setAttributes(attributes);
                element.setHasChildren(ReceiverOption.contains(properties, 262144));
                this.elementStack[this.elementStackTop] = element;
                this.receiverCountStack[this.elementStackTop] = 0;
                this.namespaceStack.push(namespaces);
                ++this.elementStackTop;
                ArrayList<ClosedownAction> activeWatchList = new ArrayList<ClosedownAction>(4);
                this.activeWatchStack.push(activeWatchList);
                this.addPrearrangedWatches();
                for (int i = 0; i < this.watchList.size(); ++i) {
                    Watch watch = this.watchList.get(i);
                    boolean matches = watch.matchesNode(element, this.context);
                    if (!matches) continue;
                    ClosedownAction action = new ClosedownAction(watch, 0);
                    activeWatchList.add(action);
                    Receiver out = watch.startSelectedParentNode(element, location);
                    if (out == null) continue;
                    out.open();
                    this.activeReceiverStack.push(out);
                    int n = this.elementStackTop - 1;
                    this.receiverCountStack[n] = this.receiverCountStack[n] + 1;
                }
                for (Receiver out : this.activeReceiverStack) {
                    try {
                        out.startElement(elementName, typeCode, attributes, namespaces, location, properties);
                    }
                    catch (ValidationException err) {
                        ve = err;
                    }
                }
                if (ve != null) {
                    throw ve;
                }
                this.lastLocationId = location.saveLocation();
            }
            catch (QuitParsingException quit) {
                if (this.multiAccumulatorWatch != null) break block9;
                while (!this.namespaceStack.isEmpty()) {
                    this.endElement();
                }
                this.endDocument();
                this.warning(quit);
                throw quit;
            }
        }
        this.processAttributes(attributes);
        ++this.eventNumber;
    }

    public void restartElement(Watch watch) throws XPathException {
        try {
            if (this.startDocumentPending) {
                this.startDocumentPending = false;
                this.deferredStartDocument();
            }
            ValidationException ve = null;
            this.ensureStackSpace();
            FleetingElementNode element = (FleetingElementNode)this.elementStack[this.elementStackTop - 1];
            List<ClosedownAction> activeWatchList = this.activeWatchStack.peek();
            boolean matches = watch.matchesNode(element, this.context);
            if (matches) {
                ClosedownAction action = new ClosedownAction(watch, 0);
                activeWatchList.add(action);
                Receiver out = watch.startSelectedParentNode(element, element);
                if (out != null) {
                    out.open();
                    try {
                        out.startElement(element.getNodeName(), element.getSchemaType(), element.getAttributes(), element.getAllNamespaces(), this.lastLocationId, 0);
                    }
                    catch (ValidationException err) {
                        ve = err;
                    }
                    this.activeReceiverStack.push(out);
                    int n = this.elementStackTop - 1;
                    this.receiverCountStack[n] = this.receiverCountStack[n] + 1;
                }
            }
            if (ve != null) {
                throw ve;
            }
        }
        catch (QuitParsingException quit) {
            while (!this.namespaceStack.isEmpty()) {
                this.endElement();
            }
            this.endDocument();
            this.warning(quit);
            throw quit;
        }
    }

    private void processAttributes(AttributeMap attributes) throws XPathException {
        for (AttributeInfo attribute : attributes) {
            try {
                FleetingNode att = null;
                NodeName nameCode = attribute.getNodeName();
                for (Watch watch : this.watchList) {
                    boolean matches;
                    if (!watch.matchesNodesOfKind(UType.ATTRIBUTE)) continue;
                    if (att == null) {
                        att = new FleetingNode();
                        att.setNodeKind(2);
                        att.setNodeName(nameCode);
                        att.setTypeAnnotation(attribute.getType());
                        att.setParent(this.elementStack[this.elementStackTop - 1]);
                        att.setStringValue(StringView.tidy(attribute.getValue()));
                    }
                    if (!(matches = watch.matchesNode(att, this.context))) continue;
                    watch.processItem(att);
                }
                this.lastLocationId = attribute.getLocation();
            }
            catch (QuitParsingException quit) {
                while (!this.namespaceStack.isEmpty()) {
                    this.endElement();
                }
                this.endDocument();
                this.warning(quit);
                throw quit;
            }
        }
    }

    public int getDepth() {
        return this.elementStackTop;
    }

    private void ensureStackSpace() {
        if (this.elementStackTop + 1 > this.elementStack.length) {
            this.elementStack = Arrays.copyOf(this.elementStack, this.elementStackTop * 2);
            this.receiverCountStack = Arrays.copyOf(this.receiverCountStack, this.elementStackTop * 2);
        }
    }

    public FleetingParentNode getCurrentNode() {
        return this.elementStack[this.elementStackTop - 1];
    }

    public long getCurrentEventNumber() {
        return this.eventNumber;
    }

    protected void addPrearrangedWatches() throws XPathException {
    }

    @Override
    public void characters(UnicodeString chars, Location locationId, int properties) throws XPathException {
        try {
            this.ensureStackSpace();
            FleetingNode node = null;
            FleetingDocumentNode parent = this.elementStackTop > 0 ? this.elementStack[this.elementStackTop - 1] : this.documentNode;
            for (Watch watch : this.watchList) {
                boolean matches;
                if (!watch.matchesNodesOfKind(UType.TEXT)) continue;
                if (node == null) {
                    node = new FleetingNode();
                    node.setNodeKind(3);
                    node.setParent(parent);
                    node.setStringValue(chars.tidy());
                    node.setTypeAnnotation(BuiltInAtomicType.UNTYPED_ATOMIC);
                }
                if (!(matches = watch.matchesNode(node, this.context))) continue;
                watch.processItem(node);
            }
            for (Receiver out : this.activeReceiverStack) {
                out.characters(chars, locationId, properties);
            }
            this.lastLocationId = locationId;
        }
        catch (QuitParsingException quit) {
            while (!this.namespaceStack.isEmpty()) {
                this.endElement();
            }
            this.endDocument();
            this.warning(quit);
            throw quit;
        }
        ++this.eventNumber;
    }

    private void warning(QuitParsingException exception) {
        XmlProcessingException err = new XmlProcessingException(exception.maybeWithLocation(this.lastLocationId));
        err.setWarning(true);
        this.getPipelineConfiguration().getErrorReporter().report(err);
    }

    @Override
    public void endElement() throws XPathException {
        this.trace("endElement " + this.elementStack[this.elementStackTop - 1].getDisplayName());
        for (Receiver out : this.activeReceiverStack) {
            out.endElement();
        }
        --this.elementStackTop;
        if (!this.namespaceStack.isEmpty()) {
            this.namespaceStack.pop();
        }
        int drop = this.receiverCountStack[this.elementStackTop];
        this.receiverCountStack[this.elementStackTop] = 0;
        for (int i = 0; i < drop; ++i) {
            Receiver out = this.activeReceiverStack.pop();
            out.close();
        }
        List<ClosedownAction> activeWatchList = this.activeWatchStack.pop();
        QuitParsingException quit = null;
        int[] doItWhen = new int[activeWatchList.size()];
        for (int i = 0; i < activeWatchList.size(); ++i) {
            ClosedownAction action = activeWatchList.get(i);
            doItWhen[i] = action.watch instanceof Trigger && ((Trigger)action.watch).getAction() instanceof SnapshotFeed ? 0 : (action.watch instanceof MultiAccumulatorWatch ? 1 : 2);
        }
        for (int phase = 0; phase <= 2; ++phase) {
            for (int i = activeWatchList.size() - 1; i >= 0; --i) {
                ClosedownAction action = activeWatchList.get(i);
                if (doItWhen[i] != phase) continue;
                if (action.action == 0) {
                    try {
                        action.watch.endSelectedParentNode(this.lastLocationId);
                    }
                    catch (QuitParsingException q) {
                        quit = q;
                    }
                    continue;
                }
                try {
                    action.watch.close();
                }
                catch (QuitParsingException q) {
                    quit = q;
                }
                this.watchList.remove(action.watch);
            }
        }
        if (quit != null) {
            while (!this.namespaceStack.isEmpty()) {
                this.endElement();
            }
            this.endDocument();
            this.warning(quit);
            throw quit;
        }
        ++this.eventNumber;
    }

    @Override
    public void endDocument() throws XPathException {
        --this.elementStackTop;
        if (this.elementStackTop == 0) {
            for (Receiver out : this.activeReceiverStack) {
                out.endDocument();
            }
            int drop = this.receiverCountStack[this.elementStackTop];
            this.receiverCountStack[this.elementStackTop] = 0;
            for (int i = 0; i < drop; ++i) {
                Receiver out = this.activeReceiverStack.pop();
                out.close();
            }
            List<ClosedownAction> activeWatchList = this.activeWatchStack.pop();
            for (int i = activeWatchList.size() - 1; i >= 0; --i) {
                ClosedownAction action = activeWatchList.get(i);
                if (action.action == 0) {
                    action.watch.endSelectedParentNode(this.lastLocationId);
                    continue;
                }
                action.watch.close();
                this.watchList.remove(action.watch);
            }
        }
        ++this.eventNumber;
    }

    @Override
    public void comment(UnicodeString chars, Location locationId, int properties) throws XPathException {
        this.ensureStackSpace();
        FleetingNode node = new FleetingNode();
        FleetingDocumentNode parent = this.elementStackTop > 0 ? this.elementStack[this.elementStackTop - 1] : this.documentNode;
        node.setNodeKind(8);
        node.setParent(parent);
        node.setStringValue(chars.tidy());
        node.setTypeAnnotation(BuiltInAtomicType.UNTYPED_ATOMIC);
        if (this.startDocumentPending) {
            this.documentNode.captureInitialCommentOrProcessingInstruction(node);
        } else {
            for (Watch watch : this.watchList) {
                boolean matches = watch.matchesNode(node, this.context);
                if (!matches) continue;
                watch.processItem(node);
            }
            for (Receiver out : this.activeReceiverStack) {
                out.comment(chars, locationId, properties);
            }
            this.lastLocationId = locationId;
        }
        ++this.eventNumber;
    }

    @Override
    public void processingInstruction(String target, UnicodeString data, Location locationId, int properties) throws XPathException {
        this.ensureStackSpace();
        FleetingNode node = new FleetingNode();
        FleetingDocumentNode parent = this.elementStackTop > 0 ? this.elementStack[this.elementStackTop - 1] : this.documentNode;
        node.setNodeKind(7);
        node.setParent(parent);
        NoNamespaceName nodeName = new NoNamespaceName(target);
        node.setNodeName(nodeName);
        node.setStringValue(data.tidy());
        node.setTypeAnnotation(BuiltInAtomicType.UNTYPED_ATOMIC);
        if (this.startDocumentPending) {
            this.documentNode.captureInitialCommentOrProcessingInstruction(node);
        } else {
            for (Watch watch : this.watchList) {
                boolean matches = watch.matchesNode(node, this.context);
                if (!matches) continue;
                watch.processItem(node);
            }
            for (Receiver out : this.activeReceiverStack) {
                out.processingInstruction(target, data, locationId, properties);
            }
            this.lastLocationId = locationId;
        }
        ++this.eventNumber;
    }

    @Override
    public void setUnparsedEntity(String name, String systemID, String publicID) throws XPathException {
        if (this.documentNode != null) {
            this.documentNode.setUnparsedEntity(name, systemID, publicID);
        }
    }

    public void addWatch(Watch watch, boolean autoClose) throws XPathException {
        this.watchList.add(watch);
        watch.setPipelineConfiguration(this.getPipelineConfiguration());
        watch.setNamespaceResolver(this);
        boolean foundGroupCapture = false;
        if (!this.capturingScopes.isEmpty()) {
            for (GroupingScope scope : this.capturingScopes) {
                if (!scope.isActive) continue;
                scope.addWatch(watch);
                watch.setAnchorNode(this.elementStack[this.elementStackTop - 1]);
                foundGroupCapture = true;
            }
        }
        if (!foundGroupCapture && this.elementStackTop > 0) {
            watch.setAnchorNode(this.elementStack[this.elementStackTop - 1]);
            if (autoClose) {
                this.activeWatchStack.peek().add(new ClosedownAction(watch, 1));
            }
        }
        if (autoClose) {
            watch.open(Terminator.getInstance());
        }
    }

    public void removeWatch(Watch watch) {
        this.watchList.remove(watch);
    }

    @Override
    public NamespaceUri getURIForPrefix(String prefix, boolean useDefault) {
        if (!useDefault && prefix.isEmpty()) {
            return NamespaceUri.NULL;
        }
        return this.namespaceStack.peek().getURIForPrefix(prefix, useDefault);
    }

    @Override
    public Iterator<String> iteratePrefixes() {
        return this.namespaceStack.peek().iteratePrefixes();
    }

    @Override
    public boolean usesTypeAnnotations() {
        return true;
    }

    public boolean allowsEarlyExit() {
        return this.multiAccumulatorWatch == null;
    }

    public FleetingDocumentNode getDocumentNode() {
        return this.documentNode;
    }

    public MultiAccumulatorWatch getMultiAccumulatorWatch() {
        return this.multiAccumulatorWatch;
    }

    public void watchAccumulators(MultiAccumulatorWatch multiWatch) throws XPathException {
        this.multiAccumulatorWatch = multiWatch;
        this.addWatch(multiWatch, true);
    }

    public GroupingScope startGroupingScope() {
        return new GroupingScope();
    }

    public void endGroupingScope(GroupingScope current) throws XPathException {
        for (Watch watch : current.watches) {
            watch.close();
            this.removeWatch(watch);
        }
    }

    public void startCapturingGroupingWatches(GroupingScope scope) {
        this.capturingScopes.add(scope);
    }

    public void stopCapturingGroupingWatches(GroupingScope scope) {
        this.capturingScopes.remove(scope);
    }

    protected static class ClosedownAction {
        public static final int DEACTIVATE = 0;
        public static final int CLOSE = 1;
        public Watch watch;
        public int action;

        public ClosedownAction(Watch watch, int action) {
            this.watch = watch;
            this.action = action;
        }
    }

    public static class GroupingScope {
        public boolean isActive = true;
        public List<Watch> watches = new ArrayList<Watch>();

        public void addWatch(Watch watch) {
            if (this.isActive) {
                this.watches.add(watch);
            }
        }
    }
}

