/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.trans;

import com.saxonica.ee.extfn.js.IXSLFunctionSet;
import com.saxonica.ee.extfn.js.JSFunctionLibrary;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.sf.saxon.Configuration;
import net.sf.saxon.Version;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.accum.Accumulator;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.serialize.CharacterMap;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.DecimalFormatManager;
import net.sf.saxon.trans.DecimalSymbols;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.Visibility;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.DateTimeValue;

public class StylesheetPackageEE
extends StylesheetPackage {
    private boolean fallbackToNonStreaming = false;
    private boolean justInTimeCompilation = false;
    private String errorMessageOnExport;
    private String errorCodeOnExport;

    public StylesheetPackageEE(Configuration config) {
        super(config);
    }

    @Override
    public void setFallbackToNonStreaming() {
        for (Mode m : this.getRuleManager().getAllNamedModes()) {
            m.setStreamable(false);
        }
        this.getRuleManager().getUnnamedMode().setStreamable(false);
        for (Accumulator acc : this.getAccumulatorRegistry().getAllAccumulators()) {
            acc.setDeclaredStreamable(false);
        }
        this.fallbackToNonStreaming = true;
    }

    @Override
    public boolean isFallbackToNonStreaming() {
        return this.fallbackToNonStreaming;
    }

    @Override
    public boolean isJustInTimeCompilation() {
        return this.justInTimeCompilation;
    }

    @Override
    public void setJustInTimeCompilation(boolean justInTimeCompilation) {
        this.justInTimeCompilation = justInTimeCompilation;
    }

    @Override
    public void markNonExportable(String message, String errorCode) {
        this.errorMessageOnExport = message;
        this.errorCodeOnExport = errorCode;
    }

    @Override
    public void export(ExpressionPresenter presenter) throws XPathException {
        if (!this.config.isLicensedFeature(2)) {
            throw new XPathException("Exporting a package requires a Saxon-EE license");
        }
        presenter.setDefaultNamespace(NamespaceUri.SAXON_XSLT_EXPORT);
        ExpressionPresenter.ExportOptions options = presenter.getOptions();
        options.componentMap = new HashMap<Component, Integer>();
        options.packageMap = new HashMap<StylesheetPackage, Integer>();
        options.packageMap.put(this, 0);
        this.export(presenter, true);
        presenter.close();
    }

    @Override
    protected void addIxslFunctionLibrary(FunctionLibraryList functionLibrary) {
        functionLibrary.addFunctionLibrary(IXSLFunctionSet.getInstance());
        functionLibrary.addFunctionLibrary(new JSFunctionLibrary());
    }

    private void export(ExpressionPresenter presenter, boolean topLevel) throws XPathException {
        if (this.errorMessageOnExport != null) {
            throw new XPathException("Stylesheet package cannot be exported: " + this.errorMessageOnExport, this.errorCodeOnExport);
        }
        ExpressionPresenter.ExportOptions options = presenter.getOptions();
        Map<Component, Integer> componentIdMap = options.componentMap;
        Map<StylesheetPackage, Integer> packageIdMap = options.packageMap;
        presenter.startElement("package");
        int packageId = packageIdMap.get(this);
        if (topLevel) {
            String expiry;
            presenter.emitAttribute("when", DateTimeValue.now().getStringValue());
            presenter.namespace("fn", NamespaceUri.FN);
            presenter.namespace("xs", NamespaceUri.SCHEMA);
            presenter.namespace("vv", NamespaceUri.SAXON_GENERATED_VARIABLE);
            presenter.namespace("java-type", NamespaceUri.JAVA_TYPE);
            String dmk = this.getConfiguration().getLicenseFeature("DMK");
            if (dmk != null) {
                presenter.emitAttribute("dmk", dmk);
            }
            if ((expiry = this.getConfiguration().getLicenseFeature("Expiration")) != null && !expiry.equals("never")) {
                presenter.emitAttribute("expiry", expiry);
            }
        }
        presenter.emitAttribute("id", packageId + "");
        presenter.emitAttribute("name", this.getPackageName());
        presenter.emitAttribute("version", this.getHostLanguageVersion() + "");
        if (this.getDefaultMode() != null && !this.getDefaultMode().getStructuredQName().equals(Mode.UNNAMED_MODE_NAME)) {
            presenter.emitAttribute("defaultMode", this.getDefaultMode().getStructuredQName());
        }
        if (this.isDeclaredModes()) {
            presenter.emitAttribute("declaredModes", "1");
        }
        if (this.isStripsTypeAnnotations()) {
            presenter.emitAttribute("stripType", "1");
        }
        if (this.getPackageVersion() != null) {
            presenter.emitAttribute("packageVersion", this.getPackageVersion().toString());
        }
        if (this.isSchemaAware()) {
            presenter.emitAttribute("schemaAware", "1");
        }
        presenter.emitAttribute("saxonProduct", Version.getProductName() + '-' + this.config.getEditionCode());
        presenter.emitAttribute("saxonVersion", Version.getProductVersion());
        presenter.emitAttribute("buildDateTime", DateTimeValue.now().getStringValue());
        presenter.emitAttribute("target", presenter.getOptions().target);
        presenter.emitAttribute("targetVersion", presenter.getOptions().targetVersion + "");
        presenter.emitAttribute("relocatable", this.isRelocatable() ? "true" : "false");
        presenter.emitAttribute("implicit", this.isImplicitPackage() ? "true" : "false");
        for (StylesheetPackage used : this.getUsedPackages()) {
            if (packageIdMap.containsKey(used)) continue;
            packageIdMap.put(used, packageIdMap.size());
            ((StylesheetPackageEE)used).export(presenter, false);
        }
        if (topLevel && this.globalContextRequirement != null) {
            this.globalContextRequirement.export(presenter);
        }
        this.exportSchemaNamespaces(presenter);
        for (Component c : this.getComponentIndex().values()) {
            if (!this.needToExport(c)) continue;
            c.export(presenter, componentIdMap, packageIdMap);
        }
        for (Component c : this.hiddenComponents) {
            if (!this.needToExport(c)) continue;
            c.export(presenter, componentIdMap, packageIdMap);
        }
        presenter.startElement("overridden");
        for (Component c : this.overriddenComponents.values()) {
            c.export(presenter, componentIdMap, packageIdMap);
        }
        presenter.endElement();
        this.keyManager.exportKeys(presenter, componentIdMap);
        this.exportAccumulators(presenter, componentIdMap);
        this.exportOutputProperties(presenter);
        this.exportCharacterMaps(presenter);
        if (this.stripperRules != null) {
            this.stripperRules.export(presenter);
        }
        this.exportDecimalFormats(presenter);
        presenter.endElement();
    }

    private boolean needToExport(Component c) {
        if (c.getVisibility() == Visibility.HIDDEN) {
            return c.getBaseComponent() != null && this.needToExport(c.getBaseComponent());
        }
        if (this.overriddenComponents.containsKey(c.getActor().getSymbolicName())) {
            return true;
        }
        if (c.getVisibility() == Visibility.PRIVATE) {
            return c.getActor().isExportable();
        }
        return true;
    }

    private void exportSchemaNamespaces(ExpressionPresenter presenter) {
        for (NamespaceUri ns : this.schemaIndex) {
            presenter.startElement("schema");
            presenter.emitAttribute("ns", ns.toString());
            presenter.endElement();
        }
    }

    private void exportOutputProperties(ExpressionPresenter presenter) {
        presenter.startElement("output");
        this.exportOutputDefinition(this.defaultOutputProperties, presenter);
        presenter.endElement();
        for (Map.Entry namedProps : this.namedOutputProperties.entrySet()) {
            StructuredQName defName = (StructuredQName)namedProps.getKey();
            presenter.startElement("output");
            presenter.emitAttribute("name", defName);
            this.exportOutputDefinition((Properties)namedProps.getValue(), presenter);
            presenter.endElement();
        }
    }

    private void exportCharacterMaps(ExpressionPresenter presenter) {
        for (CharacterMap cm : this.getCharacterMapIndex()) {
            cm.export(presenter);
        }
    }

    private void exportOutputDefinition(Properties properties, ExpressionPresenter presenter) {
        for (String name : properties.stringPropertyNames()) {
            presenter.startElement("property");
            String key = name.startsWith("{") ? "Q" + name : name;
            presenter.emitAttribute("name", key);
            String val = properties.getProperty(name);
            if (key.equals("use-character-maps")) {
                val = val.replace("{", "Q{");
            }
            presenter.emitAttribute("value", val);
            presenter.endElement();
        }
    }

    private void exportDecimalFormats(ExpressionPresenter presenter) {
        DecimalFormatManager dfm = this.getDecimalFormatManager();
        dfm.getDefaultDecimalFormat().export(null, presenter);
        for (StructuredQName qn : dfm.getDecimalFormatNames()) {
            DecimalSymbols symbols = dfm.getNamedDecimalFormat(qn);
            symbols.export(qn, presenter);
        }
    }

    private void exportAccumulators(ExpressionPresenter presenter, Map<Component, Integer> componentIdMap) throws XPathException {
        for (Accumulator acc : this.getAccumulatorRegistry().getAllAccumulators()) {
            acc.export(presenter, componentIdMap);
        }
    }
}

