/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.validate;

import com.saxonica.ee.schema.IdentityConstraint;
import com.saxonica.ee.schema.IdentityField;
import com.saxonica.ee.schema.Key;
import com.saxonica.ee.schema.KeyRef;
import com.saxonica.ee.schema.Unique;
import com.saxonica.ee.stream.om.FleetingParentNode;
import com.saxonica.ee.stream.watch.PatternWatch;
import com.saxonica.ee.validate.CompactStringValue;
import com.saxonica.ee.validate.ConstraintChecker;
import com.saxonica.ee.validate.FieldWatch;
import com.saxonica.ee.validate.ValidationContext;
import java.util.HashMap;
import java.util.Stack;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.sort.SimpleTypeComparison;
import net.sf.saxon.lib.InvalidityHandler;
import net.sf.saxon.lib.InvalidityHandlerWrappingErrorReporter;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.StringValue;

public abstract class SelectorWatch
extends PatternWatch {
    IdentityConstraint identityConstraint;
    private final ConstraintChecker constraintChecker;
    private final int numberOfColumns;
    private AtomicSequence[] currentRow;
    private Stack<AtomicSequence[]> activationStack = null;
    HashMap<ValueEntry, Integer> table = new HashMap(100);
    private static final Integer REFERENCED_VALUE = 65536;
    private static final Integer PRESENT_VALUE = 1;

    SelectorWatch(ConstraintChecker checker, IdentityConstraint uniqueConstraint) {
        this.identityConstraint = uniqueConstraint;
        this.constraintChecker = checker;
        this.setSelection(uniqueConstraint.getSelector().getSelection());
        this.numberOfColumns = uniqueConstraint.getFields().size();
    }

    IdentityConstraint getIdentityConstraint() {
        return this.identityConstraint;
    }

    @Override
    public Receiver startSelectedParentNode(FleetingParentNode node, Location locationId) throws XPathException {
        if (this.currentRow != null) {
            if (this.activationStack == null) {
                this.activationStack = new Stack();
            }
            this.activationStack.push(this.currentRow);
        }
        this.currentRow = new AtomicSequence[this.numberOfColumns];
        int column = 0;
        ConstraintChecker fieldHandler = this.constraintChecker;
        for (IdentityField field : this.identityConstraint.getFields()) {
            Pattern fieldSelection = field.getSelection();
            FieldWatch fieldWatch = new FieldWatch(this, fieldSelection, this.currentRow, column++);
            fieldWatch.setAnchorNode(node);
            fieldWatch.setNamespaceResolver(this.getNamespaceResolver());
            fieldHandler.addWatch(fieldWatch, true);
        }
        return null;
    }

    @Override
    public void endSelectedParentNode(Location locationId) throws XPathException {
        this.checkRow(this.currentRow, false, locationId);
        this.currentRow = this.activationStack != null && !this.activationStack.isEmpty() ? this.activationStack.pop() : null;
    }

    @Override
    public void close() throws XPathException {
    }

    void addFieldValue(AtomicSequence[] currentRow, int column, AtomicSequence value, boolean nillableElement, Location locationId) throws XPathException {
        ValidationFailure ve;
        if (currentRow[column] != null) {
            ve = new ValidationFailure("Identity constraint " + Err.wrap(this.identityConstraint.getName()) + ": the " + this.identifyField(column) + " selects more than one node");
            ve.setErrorCode(this.constraintChecker.getValidationContext().getErrorCode());
            ve.setConstraintReference(1, "cvc-identity-constraint", "3");
            this.reportValidationError(ve, locationId);
        }
        if (nillableElement && this.identityConstraint instanceof Key) {
            ve = new ValidationFailure("The element declaration of a field in an xs:key constraint must not be nillable");
            ve.setErrorCode(this.constraintChecker.getValidationContext().getErrorCode());
            ve.setConstraintReference(1, "cvc-identity-constraint", "4.2.3");
            this.reportValidationError(ve, locationId);
        }
        currentRow[column] = value;
    }

    private String identifyField(int column) {
        if (this.numberOfColumns == 1) {
            return "field";
        }
        if (column == 0) {
            return "first field";
        }
        if (column == 1) {
            return "second field";
        }
        if (column == 2) {
            return "third field";
        }
        if (column < 20) {
            return column + 1 + "th field";
        }
        return "field " + (column + 1);
    }

    protected void checkRow(AtomicSequence[] currentRow, boolean isTarget, Location locationId) throws XPathException {
        for (int i = 0; i < this.numberOfColumns; ++i) {
            if (currentRow[i] != null) continue;
            if (isTarget) {
                return;
            }
            if (this.identityConstraint instanceof Unique) {
                return;
            }
            if (this.identityConstraint instanceof Key) {
                ValidationFailure ve = new ValidationFailure("The " + this.identifyField(i) + " in constraint " + Err.wrap(this.identityConstraint.getName()) + " has no value");
                ve.setErrorCode(this.constraintChecker.getValidationContext().getErrorCode());
                ve.setConstraintReference(1, "cvc-identity-constraint", "4.2.1");
                this.reportValidationError(ve, locationId);
                continue;
            }
            return;
        }
        ValueEntry entry = ValueEntry.makeValueEntry(currentRow);
        if (this.table.containsKey(entry)) {
            int flags = this.table.get(entry);
            if (isTarget) {
                int count = flags >> 16;
                flags = ++count << 16 | flags & 0xFFFF;
                if (count > 1 && (flags & 1) != 0) {
                    ValidationFailure ve = new ValidationFailure("More than one referenced value found for keyRef " + Err.wrap(this.identityConstraint.getName()) + "\n    " + entry);
                    ve.setErrorCode(this.constraintChecker.getValidationContext().getErrorCode());
                    ve.setConstraintReference(1, "cvc-identity-constraint", "3");
                    this.reportValidationError(ve, locationId);
                }
                this.table.put(entry, flags);
            } else if (this.identityConstraint instanceof KeyRef) {
                if ((flags |= 1) >> 16 > 1) {
                    ValidationFailure ve = new ValidationFailure("More than one referenced value found for keyRef " + Err.wrap(this.identityConstraint.getName()) + "\n    " + entry);
                    ve.setErrorCode(this.constraintChecker.getValidationContext().getErrorCode());
                    ve.setConstraintReference(1, "cvc-identity-constraint", "3");
                    this.reportValidationError(ve, locationId);
                }
                this.table.put(entry, flags);
            } else {
                ValidationFailure ve = new ValidationFailure("Non-unique value found for constraint " + this.identityConstraint.getName() + ": " + entry);
                String err = this.constraintChecker.getValidationContext().getErrorCode();
                ve.setErrorCode(err);
                ve.setConstraintReference(1, "cvc-identity-constraint", this.identityConstraint instanceof Unique ? "4.1" : "4.2.2");
                this.reportValidationError(ve, locationId);
            }
        } else if (this.identityConstraint.isOrdered()) {
            if (this.table.isEmpty()) {
                this.table.put(entry, PRESENT_VALUE);
            } else {
                ValueEntry latest = null;
                Object ve = this.table.keySet().iterator();
                while (ve.hasNext()) {
                    ValueEntry ve2;
                    latest = ve2 = ve.next();
                }
                assert (latest != null);
                if (this.orderedOK(latest, entry)) {
                    this.table.clear();
                    this.table.put(entry, PRESENT_VALUE);
                } else {
                    ve = new ValidationFailure("Value out of sequence for ordered constraint " + this.identityConstraint.getName() + ": " + entry);
                    ((ValidationFailure)ve).setErrorCode("SXOR0001");
                    ((ValidationFailure)ve).setConstraintReference(1, "saxon-identity-constraint", "0");
                    this.reportValidationError((ValidationFailure)ve, locationId);
                }
            }
        } else {
            Integer details = isTarget ? REFERENCED_VALUE : PRESENT_VALUE;
            this.table.put(entry, details);
        }
    }

    private boolean orderedOK(ValueEntry first, ValueEntry second) {
        AtomicSequence[] s2;
        AtomicSequence[] s1 = first.getValues();
        if (s1.length != (s2 = second.getValues()).length) {
            throw new AssertionError();
        }
        for (int i = 0; i < s1.length; ++i) {
            int c = SimpleTypeComparison.getInstance().compareSequences(s1[i], s2[i]);
            if (c == 0) continue;
            return this.identityConstraint.getFields().get(i).isAscending() ? c < 0 : c > 0;
        }
        return false;
    }

    protected void reportValidationError(ValidationFailure err, Location locator) throws XPathException {
        PipelineConfiguration pipe = this.getPipelineConfiguration();
        ValidationContext vc = this.constraintChecker.getValidationContext();
        InvalidityHandler handler = vc.getInvalidityHandler();
        if (handler == null) {
            handler = new InvalidityHandlerWrappingErrorReporter(pipe.getErrorReporter());
        }
        err.setHasBeenReported(true);
        err.setSourceLocator(locator);
        handler.reportInvalidity(err);
        if (vc.getErrorCount() == 0) {
            vc.setErrorCode(err.getErrorCode());
        }
        if (vc.incrementErrorCount(err)) {
            throw err.makeException();
        }
    }

    private static class ValueEntry4
    extends ValueEntry {
        AtomicSequence value0;
        AtomicSequence value1;
        AtomicSequence value2;
        AtomicSequence value3;

        ValueEntry4(AtomicSequence value0, AtomicSequence value1, AtomicSequence value2, AtomicSequence value3) {
            this.value0 = this.compact(value0);
            this.value1 = this.compact(value1);
            this.value2 = this.compact(value2);
            this.value3 = this.compact(value3);
        }

        @Override
        protected AtomicSequence[] getValues() {
            return new AtomicSequence[]{this.value0, this.value1, this.value2, this.value3};
        }

        public boolean equals(Object obj) {
            return obj instanceof ValueEntry4 && this.equalValues(this.value0, ((ValueEntry4)obj).value0) && this.equalValues(this.value1, ((ValueEntry4)obj).value1) && this.equalValues(this.value2, ((ValueEntry4)obj).value2) && this.equalValues(this.value3, ((ValueEntry4)obj).value3);
        }

        public int hashCode() {
            return 0xA012B876 ^ this.hash(this.value0) ^ this.hash(this.value1) * 31 ^ this.hash(this.value2) * 63 ^ this.hash(this.value3) * 127;
        }

        public String toString() {
            return "(" + this.displayValue(this.value0) + ", " + this.displayValue(this.value1) + ", " + this.displayValue(this.value2) + ", " + this.displayValue(this.value3) + ")";
        }
    }

    private static class ValueEntry3
    extends ValueEntry {
        AtomicSequence value0;
        AtomicSequence value1;
        AtomicSequence value2;

        ValueEntry3(AtomicSequence value0, AtomicSequence value1, AtomicSequence value2) {
            this.value0 = this.compact(value0);
            this.value1 = this.compact(value1);
            this.value2 = this.compact(value2);
        }

        @Override
        protected AtomicSequence[] getValues() {
            return new AtomicSequence[]{this.value0, this.value1, this.value2};
        }

        public boolean equals(Object obj) {
            return obj instanceof ValueEntry3 && this.equalValues(this.value0, ((ValueEntry3)obj).value0) && this.equalValues(this.value1, ((ValueEntry3)obj).value1) && this.equalValues(this.value2, ((ValueEntry3)obj).value2);
        }

        public int hashCode() {
            return 0xA012B876 ^ this.hash(this.value0) ^ this.hash(this.value1) * 31 ^ this.hash(this.value2) * 63;
        }

        public String toString() {
            return "(" + this.displayValue(this.value0) + ", " + this.displayValue(this.value1) + ", " + this.displayValue(this.value2) + ")";
        }
    }

    private static class ValueEntry2
    extends ValueEntry {
        AtomicSequence value0;
        AtomicSequence value1;

        ValueEntry2(AtomicSequence value0, AtomicSequence value1) {
            this.value0 = this.compact(value0);
            this.value1 = this.compact(value1);
        }

        @Override
        protected AtomicSequence[] getValues() {
            return new AtomicSequence[]{this.value0, this.value1};
        }

        public boolean equals(Object obj) {
            return obj instanceof ValueEntry2 && this.equalValues(this.value0, ((ValueEntry2)obj).value0) && this.equalValues(this.value1, ((ValueEntry2)obj).value1);
        }

        public int hashCode() {
            return 0xA012B876 ^ this.hash(this.value0) ^ this.hash(this.value1) * 31;
        }

        public String toString() {
            return "(" + this.displayValue(this.value0) + ", " + this.displayValue(this.value1) + ")";
        }
    }

    private static class ValueEntry1
    extends ValueEntry {
        AtomicSequence value;

        ValueEntry1(AtomicSequence value) {
            this.value = this.compact(value);
        }

        @Override
        protected AtomicSequence[] getValues() {
            return new AtomicSequence[]{this.value};
        }

        public boolean equals(Object obj) {
            return obj instanceof ValueEntry1 && this.equalValues(this.value, ((ValueEntry1)obj).value);
        }

        public int hashCode() {
            return 0xA012B876 ^ this.hash(this.value);
        }

        public String toString() {
            return this.displayValue(this.value);
        }
    }

    private static class MultiValueEntry
    extends ValueEntry {
        AtomicSequence[] values;

        MultiValueEntry(AtomicSequence[] values) {
            this.values = values;
            for (int i = 0; i < values.length; ++i) {
                values[i] = this.compact(values[i]);
            }
        }

        @Override
        protected AtomicSequence[] getValues() {
            return this.values;
        }

        public boolean equals(Object obj) {
            if (obj instanceof MultiValueEntry && ((MultiValueEntry)obj).values.length == this.values.length) {
                for (int i = 0; i < this.values.length; ++i) {
                    if (this.equalValues(this.values[i], ((MultiValueEntry)obj).values[i])) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            int h = -1609385866;
            for (AtomicSequence a : this.values) {
                h ^= this.hash(a);
            }
            return h;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(100);
            sb.append('(');
            for (int i = 0; i < this.values.length; ++i) {
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append(this.displayValue(this.values[i]));
            }
            sb.append(')');
            return sb.toString();
        }
    }

    static abstract class ValueEntry {
        ValueEntry() {
        }

        protected static ValueEntry makeValueEntry(AtomicSequence[] values) {
            switch (values.length) {
                case 1: {
                    return new ValueEntry1(values[0]);
                }
                case 2: {
                    return new ValueEntry2(values[0], values[1]);
                }
                case 3: {
                    return new ValueEntry3(values[0], values[1], values[2]);
                }
                case 4: {
                    return new ValueEntry4(values[0], values[1], values[2], values[3]);
                }
            }
            return new MultiValueEntry(values);
        }

        boolean equalValues(AtomicSequence val0, AtomicSequence val1) {
            if (val0 == null) {
                return val1 == null;
            }
            return val1 != null && SimpleTypeComparison.getInstance().equalOrIdentical(val0, val1);
        }

        String displayValue(AtomicSequence val) {
            if (val == null) {
                return "()";
            }
            return val.toString();
        }

        protected final AtomicSequence compact(AtomicSequence value) {
            if (value instanceof StringValue) {
                return new CompactStringValue(value.getUnicodeStringValue());
            }
            return value;
        }

        protected abstract AtomicSequence[] getValues();

        protected int hash(AtomicSequence value) {
            return value == null ? 0 : SimpleTypeComparison.getInstance().hash(value);
        }
    }
}

