/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.qt4;

import com.saxonica.functions.extfn.Parse;
import java.io.StringReader;
import java.util.Stack;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.Sender;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.lib.StandardErrorHandler;
import net.sf.saxon.lib.StandardErrorReporter;
import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.EmptyAttributeMap;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.NamespaceMap;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.StringValue;
import nu.validator.htmlparser.common.XmlViolationPolicy;
import nu.validator.htmlparser.sax.HtmlParser;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class ParseHtml
extends Parse {
    @Override
    public NodeInfo call(XPathContext context, Sequence[] arguments) throws XPathException {
        StringValue html = (StringValue)arguments[0].head();
        Builder builder = context.getController().makeBuilder();
        Html5Converter filter = new Html5Converter(builder);
        HtmlParser parser = new HtmlParser(XmlViolationPolicy.ALTER_INFOSET);
        parser.setReportingDoctype(false);
        parser.setErrorHandler((ErrorHandler)new HTML5ErrorHandler());
        InputSource is = new InputSource(new StringReader(html.getStringValue()));
        SAXSource ss = new SAXSource((XMLReader)parser, is);
        Sender.send(ss, filter, new ParseOptions());
        return builder.getCurrentRoot();
    }

    public static class Html5Converter
    extends ProxyReceiver {
        private final Stack<NamespaceUri> nsStack = new Stack();

        public Html5Converter(Receiver next) {
            super(next);
            this.nsStack.push(NamespaceUri.XHTML);
        }

        @Override
        public void startElement(NodeName elemName, SchemaType type, AttributeMap attributes, NamespaceMap namespaces, Location location, int properties) throws XPathException {
            NamespaceMap nsMap = namespaces;
            if (elemName.getLocalPart().equals("svg")) {
                this.nsStack.push(NamespaceUri.SVG);
            } else if (elemName.getLocalPart().equals("math")) {
                this.nsStack.push(NamespaceUri.MATHML);
            } else {
                this.nsStack.push(this.nsStack.peek());
            }
            nsMap = nsMap.put("", this.nsStack.peek());
            FingerprintedQName nn = new FingerprintedQName("", this.nsStack.peek(), elemName.getLocalPart());
            if (attributes.size() != 0) {
                AttributeMap atts2 = EmptyAttributeMap.getInstance();
                for (AttributeInfo info : attributes) {
                    FingerprintedQName attName2 = new FingerprintedQName("", NamespaceUri.NULL, this.lowerCaseAttributeName(info.getNodeName().getLocalPart()));
                    AttributeInfo info2 = info.withNodeName(attName2);
                    atts2 = atts2.put(info2);
                }
                attributes = atts2;
            }
            super.startElement(nn, type, attributes, nsMap, location, properties);
        }

        private String lowerCaseAttributeName(String in) {
            return in;
        }

        @Override
        public void endElement() throws XPathException {
            this.nsStack.pop();
            super.endElement();
        }
    }

    public static class HTML5ErrorHandler
    extends StandardErrorHandler {
        public HTML5ErrorHandler() {
            super(new StandardErrorReporter());
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
        }
    }
}

