/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.cache;

import de.ids_mannheim.korap.IndexInfo;
import de.ids_mannheim.korap.KrillIndex;
import de.ids_mannheim.korap.collection.DocBits;
import de.ids_mannheim.korap.collection.VirtualCorpusFilter;
import de.ids_mannheim.korap.util.Fingerprinter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.apache.lucene.index.LeafReaderContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualCorpusCache {
    public static final Logger log = LoggerFactory.getLogger(VirtualCorpusCache.class);
    public static Pattern vcNamePattern = Pattern.compile("[a-zA-Z0-9]+[a-zA-Z_0-9-.]+");
    public static String CACHE_LOCATION = "vc-cache";
    public static int CAPACITY = 5;
    public static final Map<String, Map<String, DocBits>> map = Collections.synchronizedMap(new LinkedHashMap<String, Map<String, DocBits>>(CAPACITY, 0.75f, true){
        private static final long serialVersionUID = 1815514581428132435L;

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > CAPACITY;
        }
    });
    private static IndexInfo indexInfo;
    public static final Set<String> vcToCleanUp;
    public static volatile boolean isCleaning;

    public VirtualCorpusCache() {
        File dir = new File(CACHE_LOCATION);
        dir.mkdirs();
    }

    private static boolean isVcIdValid(String vcId) {
        String vcName;
        String[] parts = vcId.split("/");
        if (parts.length > 2) {
            return false;
        }
        String string = vcName = parts.length == 2 ? parts[1] : parts[0];
        return vcNamePattern.matcher(vcName).matches();
    }

    public static void storeOnDisk(String vcId, String leafFingerprint, DocBits docBits) {
        String filepath;
        File f;
        if (!VirtualCorpusCache.isVcIdValid(vcId)) {
            throw new IllegalArgumentException("Cannot cache VC due to invalid VC ID");
        }
        File dir = new File(CACHE_LOCATION + "/" + vcId);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if ((f = new File(filepath = String.valueOf(dir) + "/" + leafFingerprint)).exists()) {
            f.delete();
        }
        try {
            ObjectOutputStream os = new ObjectOutputStream(new FileOutputStream(f));
            os.writeObject(docBits);
            os.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.err.println("Cannot write " + filepath);
        }
    }

    public static void store(String vcId, Map<String, DocBits> vcData) {
        map.put(vcId, vcData);
        vcData.keySet().forEach(leafFingerprint -> VirtualCorpusCache.storeOnDisk(vcId, leafFingerprint, (DocBits)vcData.get(leafFingerprint)));
    }

    public static void store(String vcId, KrillIndex index) {
        if (!VirtualCorpusCache.isVcIdValid(vcId)) {
            throw new IllegalArgumentException("Cannot cache VC due to invalid VC ID");
        }
        VirtualCorpusFilter.DocBitsSupplier docBitsSupplier = new VirtualCorpusFilter(vcId).getDocBitsSupplier();
        for (LeafReaderContext context : index.reader().leaves()) {
            String leafFingerprint = Fingerprinter.create(context.reader().getCombinedCoreAndDeletesKey().toString());
            VirtualCorpusCache.getDocBits(vcId, leafFingerprint, () -> {
                try {
                    return docBitsSupplier.supplyDocBits(context, context.reader().getLiveDocs());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }

    public static Map<String, DocBits> retrieve(String vcId) {
        Map<String, DocBits> vcData = map.get(vcId);
        if (vcData != null) {
            return vcData;
        }
        File dir = new File(CACHE_LOCATION + "/" + vcId);
        if (dir.exists()) {
            vcData = new HashMap<String, DocBits>();
            for (File f : dir.listFiles()) {
                try {
                    ObjectInputStream ois = new ObjectInputStream(new FileInputStream(f));
                    DocBits d = (DocBits)ois.readObject();
                    vcData.put(f.getName(), d);
                    ois.close();
                }
                catch (IOException | ClassNotFoundException e) {
                    return null;
                }
            }
            vcData = Collections.synchronizedMap(vcData);
            map.put(vcId, vcData);
        }
        return vcData;
    }

    public static boolean contains(String vcId) {
        if (!VirtualCorpusCache.isVcIdValid(vcId)) {
            return false;
        }
        if (map.containsKey(vcId)) {
            return true;
        }
        File f = new File(CACHE_LOCATION + "/" + vcId);
        return f.exists();
    }

    public static void delete(String vcId) {
        File vc;
        if (!VirtualCorpusCache.isVcIdValid(vcId)) {
            return;
        }
        map.remove(vcId);
        if (!isCleaning) {
            vcToCleanUp.remove(vcId);
        }
        if ((vc = new File(CACHE_LOCATION + "/" + vcId)).exists()) {
            for (File f : vc.listFiles()) {
                if (!f.exists()) continue;
                f.delete();
            }
            vc.delete();
        }
    }

    public static void reset() {
        vcToCleanUp.clear();
        map.clear();
        File vcCache = new File(CACHE_LOCATION + "/");
        if (!vcCache.exists()) {
            return;
        }
        File[] vcs = vcCache.listFiles();
        if (vcs != null) {
            for (File vc : vcs) {
                File[] files = vc.listFiles();
                if (files != null) {
                    for (File f : files) {
                        if (!f.exists()) continue;
                        f.delete();
                    }
                }
                vc.delete();
            }
        }
        vcCache.delete();
    }

    public static void setIndexInfo(IndexInfo indexInfo) {
        VirtualCorpusCache.indexInfo = indexInfo;
        if (!vcToCleanUp.isEmpty() && !isCleaning) {
            isCleaning = true;
            VirtualCorpusCache.cleanup();
            isCleaning = false;
        }
    }

    private static void cleanup() {
        Set<String> currentLeafFingerprints = indexInfo.getAllLeafFingerprints();
        for (String vcId : vcToCleanUp) {
            Map<String, DocBits> vcData = VirtualCorpusCache.retrieve(vcId);
            vcData.keySet().removeIf(storedFingerPrint -> !currentLeafFingerprints.contains(storedFingerPrint));
            VirtualCorpusCache.store(vcId, vcData);
        }
        vcToCleanUp.clear();
    }

    public static DocBits getDocBits(String vcId, String leafFingerprint, Supplier<DocBits> calculateDocBits) {
        DocBits docBits = null;
        Map<String, DocBits> leafToDocBitMap = VirtualCorpusCache.retrieve(vcId);
        if (leafToDocBitMap == null) {
            leafToDocBitMap = Collections.synchronizedMap(new HashMap());
            map.put(vcId, leafToDocBitMap);
        } else {
            docBits = leafToDocBitMap.get(leafFingerprint);
            if (docBits == null && !isCleaning) {
                vcToCleanUp.add(vcId);
            }
        }
        if (docBits == null) {
            docBits = calculateDocBits.get();
            leafToDocBitMap.put(leafFingerprint, docBits);
            VirtualCorpusCache.storeOnDisk(vcId, leafFingerprint, docBits);
        }
        return docBits;
    }

    static {
        vcToCleanUp = Collections.synchronizedSet(new HashSet());
        isCleaning = false;
    }
}

