/*
 * Decompiled with CFR 0.152.
 */
package marmot.util;

import marmot.util.Aspell;
import marmot.util.Lexicon;
import marmot.util.StringUtils;

public class AspellLexicon
implements Lexicon {
    private static final long serialVersionUID = 1L;
    private Aspell aspell_;
    private StringUtils.Mode mode_;

    public AspellLexicon(StringUtils.Mode mode, String aspell_path, String aspell_lang) {
        this.aspell_ = new Aspell(aspell_path, aspell_lang, "utf-8");
        this.mode_ = mode;
    }

    @Override
    public int[] getCount(String lemma) {
        lemma = StringUtils.normalize(lemma, this.mode_);
        boolean lower = false;
        boolean first_cap = false;
        boolean all_cap = false;
        boolean no_letter = false;
        if (StringUtils.containsLetter(lemma)) {
            lower = this.aspell_.isCorrect(lemma);
            first_cap = this.aspell_.isCorrect(StringUtils.capitalize(lemma));
            all_cap = this.aspell_.isCorrect(lemma.toUpperCase());
        } else {
            no_letter = this.aspell_.isCorrect(lemma);
        }
        if (lower || first_cap || all_cap || no_letter) {
            int[] counts = new int[Lexicon.ARRAY_LENGTH];
            if (lower) {
                counts[StringUtils.Shape.Lower.ordinal()] = 1;
            }
            if (first_cap) {
                counts[StringUtils.Shape.FirstCap.ordinal()] = 1;
            }
            if (all_cap) {
                counts[StringUtils.Shape.AllCap.ordinal()] = 1;
            }
            if (no_letter) {
                counts[StringUtils.Shape.NoLetter.ordinal()] = 1;
            }
            counts[Lexicon.ARRAY_LENGTH - 1] = 1;
            return counts;
        }
        return null;
    }
}

