/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema;

import com.saxonica.ee.schema.Facet;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.CallableFunction;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaComponent;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Base64BinaryValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.HexBinaryValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.QualifiedNameValue;
import net.sf.saxon.value.StringValue;

public abstract class LengthRangeFacet
extends Facet {
    int requiredLength;

    @Override
    public String getValue() {
        return "" + this.requiredLength;
    }

    @Override
    public long toLong() {
        return this.requiredLength;
    }

    public void setNumericValue(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("length facet < 0");
        }
        this.requiredLength = value;
    }

    public void setValue(String value) throws SchemaException {
        try {
            this.requiredLength = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new SchemaException("Value of " + this.getName() + " facet " + Err.wrap(value, 4) + " is not an integer");
        }
        if (this.requiredLength < 0) {
            throw new SchemaException("Value of " + this.getName() + " facet " + Err.wrap(value, 4) + " must be a positive integer");
        }
    }

    @Override
    public boolean testAtomicValue(AtomicValue value) {
        if (value instanceof StringValue) {
            return this.testLength(((StringValue)value).getStringLength());
        }
        if (value instanceof HexBinaryValue) {
            return this.testLength(((HexBinaryValue)value).getLengthInOctets());
        }
        if (value instanceof Base64BinaryValue) {
            return this.testLength(((Base64BinaryValue)value).getLengthInOctets());
        }
        if (value instanceof QualifiedNameValue) {
            return true;
        }
        throw new AssertionError((Object)"Length facet found on unexpected type");
    }

    @Override
    public abstract boolean testLength(int var1);

    @Override
    public Function getFacetAsFunctionItem() {
        Callable callable = new Callable(){

            public Sequence<?> call(XPathContext context, Sequence[] arguments) throws XPathException {
                String key;
                switch (key = arguments[0].head().getStringValue()) {
                    case "class": {
                        return new StringValue(LengthRangeFacet.this.getName());
                    }
                    case "implementation": {
                        return new ObjectValue<LengthRangeFacet>(LengthRangeFacet.this);
                    }
                    case "value": {
                        return new Int64Value(LengthRangeFacet.this.requiredLength, BuiltInAtomicType.NON_NEGATIVE_INTEGER, false);
                    }
                    case "fixed": {
                        return BooleanValue.get(LengthRangeFacet.this.isFixed());
                    }
                }
                return EmptySequence.getInstance();
            }
        };
        return new CallableFunction(1, callable, SchemaComponent.COMPONENT_FUNCTION_TYPE);
    }
}

