/*
 * Decompiled with CFR 0.152.
 */
package marmot.thirdparty.aramorph;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import marmot.thirdparty.aramorph.DictionaryEntry;

public class Solution {
    private List<String> features_;
    private static final List<String> prefix_features_ = new ArrayList<String>();
    private static final List<String> suffix_features_ = new ArrayList<String>();

    public List<String> getFeatures() {
        return this.features_;
    }

    protected Solution(DictionaryEntry prefix, DictionaryEntry stem, DictionaryEntry suffix) {
        String stem_feat;
        LinkedList<String> prefixes = new LinkedList<String>(Arrays.asList(prefix.getPOS()));
        LinkedList<String> stems = new LinkedList<String>(Arrays.asList(stem.getPOS()));
        LinkedList<String> suffixes = new LinkedList<String>(Arrays.asList(suffix.getPOS()));
        while (stems.size() > 0) {
            stem_feat = stems.getFirst();
            boolean found_prefix = false;
            for (String prefix_feat : prefix_features_) {
                if (!stem_feat.endsWith(prefix_feat)) continue;
                stems.removeFirst();
                prefixes.addLast(stem_feat);
                found_prefix = true;
                break;
            }
            if (found_prefix) continue;
            break;
        }
        while (stems.size() > 0) {
            stem_feat = stems.getLast();
            boolean found_suffix = false;
            for (String suffix_feat : suffix_features_) {
                if (!stem_feat.endsWith(suffix_feat)) continue;
                stems.removeLast();
                suffixes.addFirst(stem_feat);
                found_suffix = true;
                break;
            }
            if (found_suffix) continue;
            break;
        }
        this.features_ = new ArrayList<String>();
        this.features_.addAll(prefixes);
        if (stems.isEmpty()) {
            this.features_.add("NOSTEM");
        } else {
            this.features_.add(stems.getFirst());
        }
        this.features_.addAll(suffixes);
        this.features_.replaceAll(this::simplify);
    }

    public String simplify(String string) {
        int index = string.indexOf(47);
        if (index >= 0) {
            string = string.substring(index + 1);
        }
        return string;
    }

    static {
        prefix_features_.add("CONJ");
        prefix_features_.add("EMPHATIC_PARTICLE");
        prefix_features_.add("FUNC_WORD");
        prefix_features_.add("FUT_PART");
        prefix_features_.add("INTERJ");
        prefix_features_.add("INTERROG_PART");
        prefix_features_.add("IV1S");
        prefix_features_.add("IV2MS");
        prefix_features_.add("IV2FS");
        prefix_features_.add("IV3MS");
        prefix_features_.add("IV3FS");
        prefix_features_.add("IV2D");
        prefix_features_.add("IV2FD");
        prefix_features_.add("IV3MD");
        prefix_features_.add("IV3FD");
        prefix_features_.add("IV1P");
        prefix_features_.add("IV2MP");
        prefix_features_.add("IV2FP");
        prefix_features_.add("IV3MP");
        prefix_features_.add("IV3FP");
        prefix_features_.add("NEG_PART");
        prefix_features_.add("PREP");
        prefix_features_.add("RESULT_CLAUSE_PARTICLE");
        suffix_features_.add("CASE_INDEF_NOM");
        suffix_features_.add("CASE_INDEF_ACC");
        suffix_features_.add("CASE_INDEF_ACCGEN");
        suffix_features_.add("CASE_INDEF_GEN");
        suffix_features_.add("CASE_DEF_NOM");
        suffix_features_.add("CASE_DEF_ACC");
        suffix_features_.add("CASE_DEF_ACCGEN");
        suffix_features_.add("CASE_DEF_GEN");
        suffix_features_.add("NSUFF_MASC_SG_ACC_INDEF");
        suffix_features_.add("NSUFF_FEM_SG");
        suffix_features_.add("NSUFF_MASC_DU_NOM");
        suffix_features_.add("NSUFF_MASC_DU_NOM_POSS");
        suffix_features_.add("NSUFF_MASC_DU_ACCGEN");
        suffix_features_.add("NSUFF_MASC_DU_ACCGEN_POSS");
        suffix_features_.add("NSUFF_FEM_DU_NOM");
        suffix_features_.add("NSUFF_FEM_DU_NOM_POSS");
        suffix_features_.add("NSUFF_FEM_DU_ACCGEN");
        suffix_features_.add("NSUFF_FEM_DU_ACCGEN_POSS");
        suffix_features_.add("NSUFF_MASC_PL_NOM");
        suffix_features_.add("NSUFF_MASC_PL_NOM_POSS");
        suffix_features_.add("NSUFF_MASC_PL_ACCGEN");
        suffix_features_.add("NSUFF_MASC_PL_ACCGEN_POSS");
        suffix_features_.add("NSUFF_FEM_PL");
        suffix_features_.add("POSS_PRON_1S");
        suffix_features_.add("POSS_PRON_2MS");
        suffix_features_.add("POSS_PRON_2FS");
        suffix_features_.add("POSS_PRON_3MS");
        suffix_features_.add("POSS_PRON_3FS");
        suffix_features_.add("POSS_PRON_2D");
        suffix_features_.add("POSS_PRON_3D");
        suffix_features_.add("POSS_PRON_1P");
        suffix_features_.add("POSS_PRON_2MP");
        suffix_features_.add("POSS_PRON_2FP");
        suffix_features_.add("POSS_PRON_3MP");
        suffix_features_.add("POSS_PRON_3FP");
        suffix_features_.add("IVSUFF_DO:1S");
        suffix_features_.add("IVSUFF_DO:2MS");
        suffix_features_.add("IVSUFF_DO:2FS");
        suffix_features_.add("IVSUFF_DO:3MS");
        suffix_features_.add("IVSUFF_DO:3FS");
        suffix_features_.add("IVSUFF_DO:2D");
        suffix_features_.add("IVSUFF_DO:3D");
        suffix_features_.add("IVSUFF_DO:1P");
        suffix_features_.add("IVSUFF_DO:2MP");
        suffix_features_.add("IVSUFF_DO:2FP");
        suffix_features_.add("IVSUFF_DO:3MP");
        suffix_features_.add("IVSUFF_DO:3FP");
        suffix_features_.add("IVSUFF_MOOD:I");
        suffix_features_.add("IVSUFF_SUBJ:2FS_MOOD:I");
        suffix_features_.add("IVSUFF_SUBJ:D_MOOD:I");
        suffix_features_.add("IVSUFF_SUBJ:3D_MOOD:I");
        suffix_features_.add("IVSUFF_SUBJ:MP_MOOD:I");
        suffix_features_.add("IVSUFF_MOOD:S");
        suffix_features_.add("IVSUFF_SUBJ:2FS_MOOD:SJ");
        suffix_features_.add("IVSUFF_SUBJ:D_MOOD:SJ");
        suffix_features_.add("IVSUFF_SUBJ:MP_MOOD:SJ");
        suffix_features_.add("IVSUFF_SUBJ:3MP_MOOD:SJ");
        suffix_features_.add("IVSUFF_SUBJ:FP");
        suffix_features_.add("PVSUFF_DO:1S");
        suffix_features_.add("PVSUFF_DO:2MS");
        suffix_features_.add("PVSUFF_DO:2FS");
        suffix_features_.add("PVSUFF_DO:3MS");
        suffix_features_.add("PVSUFF_DO:3FS");
        suffix_features_.add("PVSUFF_DO:2D");
        suffix_features_.add("PVSUFF_DO:3D");
        suffix_features_.add("PVSUFF_DO:1P");
        suffix_features_.add("PVSUFF_DO:2MP");
        suffix_features_.add("PVSUFF_DO:2FP");
        suffix_features_.add("PVSUFF_DO:3MP");
        suffix_features_.add("PVSUFF_DO:3FP");
        suffix_features_.add("PVSUFF_SUBJ:1S");
        suffix_features_.add("PVSUFF_SUBJ:2MS");
        suffix_features_.add("PVSUFF_SUBJ:2FS");
        suffix_features_.add("PVSUFF_SUBJ:3MS");
        suffix_features_.add("PVSUFF_SUBJ:3FS");
        suffix_features_.add("PVSUFF_SUBJ:2MD");
        suffix_features_.add("PVSUFF_SUBJ:2FD");
        suffix_features_.add("PVSUFF_SUBJ:3MD");
        suffix_features_.add("PVSUFF_SUBJ:3FD");
        suffix_features_.add("PVSUFF_SUBJ:1P");
        suffix_features_.add("PVSUFF_SUBJ:2MP");
        suffix_features_.add("PVSUFF_SUBJ:2FP");
        suffix_features_.add("PVSUFF_SUBJ:3MP");
        suffix_features_.add("PVSUFF_SUBJ:3FP");
        suffix_features_.add("CVSUFF_DO:1S");
        suffix_features_.add("CVSUFF_DO:3MS");
        suffix_features_.add("CVSUFF_DO:3FS");
        suffix_features_.add("CVSUFF_DO:3D");
        suffix_features_.add("CVSUFF_DO:1P");
        suffix_features_.add("CVSUFF_DO:3MP");
        suffix_features_.add("CVSUFF_DO:3FP");
        suffix_features_.add("CVSUFF_SUBJ:2MS");
        suffix_features_.add("CVSUFF_SUBJ:2FS");
        suffix_features_.add("CVSUFF_SUBJ:2MP");
    }
}

