/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.config;

import com.saxonica.config.ProfessionalConfiguration;
import com.saxonica.config.pe.ConfigurationReaderPE;
import com.saxonica.ee.bytecode.ByteCodeMonitor;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.config.DynamicLoaderEE;
import com.saxonica.ee.config.MultithreadingFactory;
import com.saxonica.ee.config.SlotManagerEE;
import com.saxonica.ee.config.StandardSchemaResolver;
import com.saxonica.ee.config.StyleNodeFactoryEE;
import com.saxonica.ee.config.TypeHierarchyEE;
import com.saxonica.ee.extfn.VendorFunctionSetEE;
import com.saxonica.ee.extfn.js.IXSLElementFactory;
import com.saxonica.ee.optim.MultithreadedFocusTrackingIterator;
import com.saxonica.ee.optim.OptimizerEE;
import com.saxonica.ee.optim.QuickXPathParser;
import com.saxonica.ee.optim.SearchableValue;
import com.saxonica.ee.optim.StaticQueryContextEE;
import com.saxonica.ee.optim.XQueryExpressionEE;
import com.saxonica.ee.schema.AttributeDecl;
import com.saxonica.ee.schema.AttributeGroupDecl;
import com.saxonica.ee.schema.ElementDecl;
import com.saxonica.ee.schema.IdentityConstraint;
import com.saxonica.ee.schema.ModelGroupDefinition;
import com.saxonica.ee.schema.Notation;
import com.saxonica.ee.schema.PreparedSchema;
import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.SchemaModelLoader;
import com.saxonica.ee.schema.SchemaModelSerializer;
import com.saxonica.ee.schema.SingleNamespaceSchema;
import com.saxonica.ee.schema.TypeReference;
import com.saxonica.ee.schema.UserComplexType;
import com.saxonica.ee.schema.UserDefinedType;
import com.saxonica.ee.schema.UserSimpleType;
import com.saxonica.ee.schema.UserUnionType;
import com.saxonica.ee.schema.sdoc.SchemaDocument;
import com.saxonica.ee.schema.sdoc.SchemaReader;
import com.saxonica.ee.schema.sdoc.XMLNamespaceSchema;
import com.saxonica.ee.schema.sdoc.XSINamespaceSchema;
import com.saxonica.ee.stream.AccumulatorRegistryEE;
import com.saxonica.ee.stream.ContentDetector;
import com.saxonica.ee.stream.ManualGroupIterator;
import com.saxonica.ee.stream.ManualRegexIterator;
import com.saxonica.ee.stream.Posture;
import com.saxonica.ee.stream.PostureAndSweep;
import com.saxonica.ee.stream.Projector;
import com.saxonica.ee.stream.StreamInstr;
import com.saxonica.ee.stream.Streamability;
import com.saxonica.ee.stream.StreamableUserFunction;
import com.saxonica.ee.stream.feed.DecomposingFeed;
import com.saxonica.ee.stream.om.FleetingNode;
import com.saxonica.ee.stream.watch.AccumulatorWatch;
import com.saxonica.ee.stream.watch.ApplyTemplatesAction;
import com.saxonica.ee.stream.watch.Trigger;
import com.saxonica.ee.stream.watch.WatchManager;
import com.saxonica.ee.trans.ContextItemStaticInfoEE;
import com.saxonica.ee.trans.ExpressionPresenterToJson;
import com.saxonica.ee.trans.ModeEE;
import com.saxonica.ee.trans.Outcome;
import com.saxonica.ee.trans.PackageLoaderEE;
import com.saxonica.ee.trans.SaxonElementFactoryEE;
import com.saxonica.ee.trans.StylesheetPackageEE;
import com.saxonica.ee.trans.TemplateRuleEE;
import com.saxonica.ee.trans.ThreadManagerEE;
import com.saxonica.ee.update.PendingUpdateListImpl;
import com.saxonica.ee.update.XQueryParserExtensionEE;
import com.saxonica.ee.validate.AssertionTreeBuilder;
import com.saxonica.ee.validate.ConstraintChecker;
import com.saxonica.ee.validate.ContentValidator;
import com.saxonica.ee.validate.EntityValidator;
import com.saxonica.ee.validate.IdValidator;
import com.saxonica.ee.validate.InvalidityReportGeneratorEE;
import com.saxonica.ee.validate.SkipValidator;
import com.saxonica.ee.validate.StartTagBufferEE;
import com.saxonica.ee.validate.ValidationContext;
import com.saxonica.ee.validate.ValidationStack;
import com.saxonica.ee.validate.XSIAttributeHandler;
import com.saxonica.expr.MemoFunction;
import com.saxonica.functions.extfn.EXPathFileFunctionSet;
import com.saxonica.ptree.PTreeURIResolver;
import com.saxonica.trans.ModePE;
import com.saxonica.xsltextn.style.Saxon6ElementFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.event.CopyInformee;
import net.sf.saxon.event.DocumentValidator;
import net.sf.saxon.event.FilterFactory;
import net.sf.saxon.event.LocationCopier;
import net.sf.saxon.event.PathMaintainer;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.StartTagBuffer;
import net.sf.saxon.event.TeeOutputter;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.PackageData;
import net.sf.saxon.expr.PendingUpdateList;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.expr.accum.Accumulator;
import net.sf.saxon.expr.accum.AccumulatorRegistry;
import net.sf.saxon.expr.instruct.DummyNamespaceResolver;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.GlobalParam;
import net.sf.saxon.expr.instruct.ParameterSet;
import net.sf.saxon.expr.instruct.ResultDocument;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.expr.parser.Optimizer;
import net.sf.saxon.expr.parser.OptimizerOptions;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.RetainedStaticContext;
import net.sf.saxon.expr.parser.XPathParser;
import net.sf.saxon.expr.sort.GroupIterator;
import net.sf.saxon.functions.CallableFunction;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.functions.MathFunctionSet;
import net.sf.saxon.functions.registry.ExsltCommonFunctionSet;
import net.sf.saxon.functions.registry.OnDemandFunctionSet;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.lib.InvalidityHandlerWrappingErrorListener;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.lib.SchemaURIResolver;
import net.sf.saxon.lib.StandardEntityResolver;
import net.sf.saxon.lib.StaticQueryContextFactory;
import net.sf.saxon.lib.UnfailingErrorListener;
import net.sf.saxon.ma.arrays.ArrayFunctionSet;
import net.sf.saxon.ma.map.MapFunctionSet;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.FocusTrackingIterator;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.IgnorableSpaceStrippingRule;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SpaceStrippingRule;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTestPattern;
import net.sf.saxon.query.QueryModule;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.query.XQueryExpression;
import net.sf.saxon.query.XQueryParser;
import net.sf.saxon.regex.RegexIterator;
import net.sf.saxon.regex.RegularExpression;
import net.sf.saxon.serialize.JSONEmitter;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.StyleNodeFactory;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.style.XSLTemplate;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.CompilerInfo;
import net.sf.saxon.trans.FunctionStreamability;
import net.sf.saxon.trans.LicenseException;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.SimpleMode;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ManualIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.BuiltInType;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.MissingComponentException;
import net.sf.saxon.type.SchemaComponent;
import net.sf.saxon.type.SchemaDeclaration;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.type.ValidationParams;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.StringValue;
import org.xml.sax.InputSource;

public final class EnterpriseConfiguration
extends ProfessionalConfiguration {
    private int licensedFeatures = 0;
    private HashMap<String, Integer> namespaceStatus = new HashMap();
    private int[] occurrenceLimits = new int[]{100, 250};
    private SchemaURIResolver schemaURIResolver = null;
    private final SchemaURIResolver standardSchemaResolver = new StandardSchemaResolver(this);
    private transient PreparedSchema superSchema = new PreparedSchema(this);
    private String debugByteCodeDirectory = "Saxon-bytecode";
    private int resultDocumentThreadsLimit = Runtime.getRuntime().availableProcessors();
    private int thresholdForCompilingTypes = 100;
    private int thresholdForInliningFunctions = 100;
    private int maxCompiledClasses = 10000;
    private int streamability = -1;
    private ConcurrentHashMap<String, RegularExpression> regexCache = new ConcurrentHashMap();
    private long regexAttempts = 0L;
    private MultithreadingFactory multithreadingFactory = new MultithreadingFactory(this);
    private ByteCodeMonitor byteCodeMonitor;

    public EnterpriseConfiguration() {
        this.setDynamicLoader(new DynamicLoaderEE());
        this.internalSetBooleanProperty(Feature.ALLOW_MULTITHREADING, true);
        this.internalSetBooleanProperty(Feature.GENERATE_BYTE_CODE, true);
        this.setStaticQueryContextFactory(new StaticQueryContextFactory(){

            @Override
            public StaticQueryContext newStaticQueryContext(Configuration config, boolean copyFromDefault) {
                return new StaticQueryContextEE(EnterpriseConfiguration.this, copyFromDefault);
            }
        });
        this.optimizerOptions = OptimizerOptions.FULL_EE_OPTIMIZATION;
        this.defaultXsltCompilerInfo.setOptimizerOptions(this.optimizerOptions);
    }

    @Override
    protected StaticQueryContext makeStaticQueryContext(boolean copyFromDefault) {
        StaticQueryContext sqc = super.makeStaticQueryContext(copyFromDefault);
        if (this.defaultStaticQueryContext != null) {
            sqc.setSchemaAware(this.defaultStaticQueryContext.isSchemaAware());
        }
        return sqc;
    }

    @Override
    public String getEditionCode() {
        return "EE";
    }

    @Override
    public <T> void setConfigurationProperty(Feature<T> feature, T value) {
        switch (feature.code) {
            case 33: {
                if (value instanceof Boolean) {
                    this.internalSetBooleanProperty(Feature.GENERATE_BYTE_CODE, value);
                    break;
                }
                if ("true".equals(value) || "on".equals(value) || "yes".equals(value) || "1".equals(value)) {
                    this.internalSetBooleanProperty(Feature.GENERATE_BYTE_CODE, Boolean.TRUE);
                    this.byteCodeThreshold = 0;
                    break;
                }
                if ("false".equals(value) || "off".equals(value) || "no".equals(value) || "0".equals(value)) {
                    this.internalSetBooleanProperty(Feature.GENERATE_BYTE_CODE, Boolean.FALSE);
                    break;
                }
                if (value instanceof Integer) {
                    this.internalSetBooleanProperty(Feature.GENERATE_BYTE_CODE, Boolean.TRUE);
                    this.byteCodeThreshold = (Integer)value;
                    break;
                }
                this.internalSetBooleanProperty(Feature.GENERATE_BYTE_CODE, Boolean.TRUE);
                try {
                    this.byteCodeThreshold = Integer.parseInt(value.toString());
                    break;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Value of " + feature.name + " must be a boolean or an integer");
                }
            }
            case 123: {
                int val = this.requireInteger(feature.name, value);
                if (val <= 0) {
                    this.internalSetBooleanProperty(Feature.GENERATE_BYTE_CODE, Boolean.FALSE);
                    break;
                }
                this.internalSetBooleanProperty(Feature.GENERATE_BYTE_CODE, Boolean.TRUE);
                this.byteCodeThreshold = val;
                break;
            }
            case 16: {
                this.debugByteCodeDirectory = value.toString();
                break;
            }
            case 47: {
                String val = value.toString();
                int comma = val.indexOf(44);
                if (comma < 1) {
                    throw new IllegalArgumentException("Value of http://saxon.sf.net/feature/occurrenceLimitsmust be two integers, comma-separated");
                }
                int min = Integer.parseInt(val.substring(0, comma));
                int max = Integer.parseInt(val.substring(comma + 1));
                this.setOccurrenceLimits(min, max);
                break;
            }
            case 56: {
                this.resultDocumentThreadsLimit = this.requireInteger(feature.name, value);
                break;
            }
            case 58: {
                if (!(value instanceof SchemaURIResolver)) {
                    throw new IllegalArgumentException("SCHEMA_URI_RESOLVER value must be an instance of net.sf.saxon.lib.SchemaURIResolver");
                }
                this.setSchemaURIResolver((SchemaURIResolver)value);
                break;
            }
            case 59: {
                this.setSchemaURIResolver((SchemaURIResolver)this.instantiateClassName(feature.name, value, SchemaURIResolver.class));
                break;
            }
            case 68: {
                int ival;
                String s;
                switch (s = this.requireString(feature.name, value)) {
                    case "off": {
                        ival = 0;
                        break;
                    }
                    case "standard": {
                        ival = 1;
                        break;
                    }
                    case "extended": {
                        throw new IllegalArgumentException("The value STREAMABILITY = 'extended' is no longer recognized");
                    }
                    default: {
                        throw new IllegalArgumentException("Unrecognized value STREAMABILITY = '" + value + "': must be 'off' or 'standard'");
                    }
                }
                this.setStreamability(ival);
                break;
            }
            case 76: {
                this.thresholdForCompilingTypes = this.requireInteger(feature.name, value);
                break;
            }
            case 122: {
                this.thresholdForInliningFunctions = this.requireInteger(feature.name, value);
                break;
            }
            case 40: {
                this.maxCompiledClasses = this.requireInteger(feature.name, value);
                break;
            }
            default: {
                super.setConfigurationProperty(feature, value);
            }
        }
    }

    @Override
    protected Configuration readConfigurationFile(Source source) throws XPathException {
        return new ConfigurationReaderPE().makeConfiguration(source);
    }

    @Override
    public <T> T getConfigurationProperty(Feature<T> feature) {
        if (booleanFeatures.contains(feature)) {
            return (T)Boolean.valueOf(this.getBooleanProperty(feature));
        }
        switch (feature.code) {
            case 16: {
                return (T)this.debugByteCodeDirectory;
            }
            case 47: {
                return (T)(this.occurrenceLimits[0] + "," + this.occurrenceLimits[1]);
            }
            case 76: {
                return (T)Integer.valueOf(this.thresholdForCompilingTypes);
            }
            case 122: {
                return (T)Integer.valueOf(this.thresholdForInliningFunctions);
            }
            case 40: {
                return (T)Integer.valueOf(this.maxCompiledClasses);
            }
            case 56: {
                return (T)Integer.valueOf(this.resultDocumentThreadsLimit);
            }
            case 58: {
                return (T)this.getSchemaURIResolver();
            }
            case 59: {
                return (T)this.getSchemaURIResolver().getClass().getName();
            }
            case 68: {
                switch (this.streamability) {
                    case 0: {
                        return (T)"off";
                    }
                    case 1: {
                        return (T)"standard";
                    }
                }
                return (T)"standard";
            }
        }
        return super.getConfigurationProperty(feature);
    }

    @Override
    public void checkLicensedFeature(int feature, String name, int localLicenseId) throws LicenseException {
        if (localLicenseId >= 0 && this.isFeatureAllowedBySecondaryLicense(localLicenseId, feature)) {
            return;
        }
        if (this.isLicenseNotFound()) {
            try {
                this.forceLoadLicense();
            }
            catch (Exception err) {
                int reason = err instanceof LicenseException ? ((LicenseException)err).getReason() : 5;
                String msg = err.getMessage() + ". A license is needed to use " + name;
                throw new LicenseException(msg, reason);
            }
        }
        if (!this.isLicenseFound()) {
            this.loadLicense();
        }
        this.reportIfMissingLicenseFeature(feature, name);
    }

    @Override
    protected void setLicensedFeatures() {
        this.licensedFeatures = 8;
        if ("yes".equals(this.getFeature("SAV"))) {
            this.licensedFeatures |= 1;
        }
        if ("yes".equals(this.getFeature("SAQ"))) {
            this.licensedFeatures |= 4;
        }
        if ("yes".equals(this.getFeature("SAT"))) {
            this.licensedFeatures |= 2;
        }
    }

    @Override
    protected boolean testFeature(int feature) {
        return (this.licensedFeatures & feature) != 0;
    }

    @Override
    protected void needEnterpriseEdition() {
        throw new UnsupportedOperationException("This operation requires a valid Saxon-EE license file");
    }

    @Override
    public StyleNodeFactory makeStyleNodeFactory(Compilation compilation) {
        int feature;
        int locLic;
        PackageData pack = compilation.getPackageData();
        if (pack != null && !this.isFeatureAllowedBySecondaryLicense(locLic = pack.getLocalLicenseId(), feature = 1) && !this.isLicensedFeature(feature)) {
            return super.makeStyleNodeFactory(compilation);
        }
        return new StyleNodeFactoryEE(this, compilation);
    }

    @Override
    public StylesheetPackage makeStylesheetPackage() {
        return this.isLicensedFeature(2) ? new StylesheetPackageEE(this) : new StylesheetPackage(this);
    }

    @Override
    public AccumulatorRegistry makeAccumulatorRegistry() {
        return new AccumulatorRegistryEE();
    }

    @Override
    public FunctionLibraryList getBuiltInExtensionLibraryList() {
        if (!this.isLicensedFeature(1)) {
            return super.getBuiltInExtensionLibraryList();
        }
        if (this.builtInExtensionLibraryList == null) {
            this.vendorFunctionSet = new VendorFunctionSetEE(this);
            this.builtInExtensionLibraryList = new FunctionLibraryList();
            this.builtInExtensionLibraryList.addFunctionLibrary(this.vendorFunctionSet);
            this.builtInExtensionLibraryList.addFunctionLibrary(MathFunctionSet.getInstance());
            this.builtInExtensionLibraryList.addFunctionLibrary(MapFunctionSet.getInstance());
            this.builtInExtensionLibraryList.addFunctionLibrary(ArrayFunctionSet.getInstance());
            this.builtInExtensionLibraryList.addFunctionLibrary(ExsltCommonFunctionSet.getInstance());
            if (this.getBooleanProperty(Feature.ALLOW_EXTERNAL_FUNCTIONS)) {
                this.builtInExtensionLibraryList.addFunctionLibrary(EXPathFileFunctionSet.getInstance());
                OnDemandFunctionSet sql = new OnDemandFunctionSet(this, "http://saxon.sf.net/sql", "com.saxonica.functions.sql.SQLFunctionSet");
                this.builtInExtensionLibraryList.addFunctionLibrary(sql);
            }
        }
        return this.builtInExtensionLibraryList;
    }

    @Override
    public UserFunction newUserFunction(boolean memoFunction, FunctionStreamability streamability) {
        if (memoFunction) {
            return new MemoFunction();
        }
        if (streamability != FunctionStreamability.UNCLASSIFIED) {
            return new StreamableUserFunction();
        }
        return new UserFunction();
    }

    @Override
    public TypeHierarchy getTypeHierarchy() {
        if (this.typeHierarchy == null) {
            this.typeHierarchy = new TypeHierarchyEE(this);
        }
        return this.typeHierarchy;
    }

    @Override
    public void setParameterizedURIResolver() {
        PTreeURIResolver resolver = new PTreeURIResolver();
        this.setURIResolver(resolver);
    }

    public void setSchemaURIResolver(SchemaURIResolver resolver) {
        this.schemaURIResolver = resolver;
        resolver.setConfiguration(this);
    }

    @Override
    public InvalidityReportGeneratorEE createValidityReporter() {
        return new InvalidityReportGeneratorEE(this);
    }

    @Override
    public PackageLoaderEE makePackageLoader() {
        return new PackageLoaderEE(this);
    }

    public SchemaCompiler newSchemaCompiler() {
        SchemaCompiler compiler = new SchemaCompiler(this);
        compiler.setLanguageVersion(this.xsdVersion);
        return compiler;
    }

    public void setOccurrenceLimits(int minimum, int maximum) {
        if (minimum < 1 || minimum >= maximum) {
            throw new IllegalArgumentException("Invalid occurrence limits: min<1 or max<min");
        }
        this.occurrenceLimits = new int[]{minimum, maximum};
    }

    public int[] getOccurrenceLimits() {
        return this.occurrenceLimits;
    }

    public SchemaURIResolver getSchemaURIResolver() {
        SchemaURIResolver r = this.schemaURIResolver;
        if (r == null) {
            r = this.standardSchemaResolver;
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String readSchema(PipelineConfiguration pipe, String baseURI, String schemaLocation, String expected) throws SchemaException {
        PreparedSchema preparedSchema = this.superSchema;
        synchronized (preparedSchema) {
            int status = this.getNamespaceStatus(expected);
            if (status == 1 || status == 3 && this.getConfigurationProperty(Feature.MULTIPLE_SCHEMA_IMPORTS).booleanValue()) {
                SchemaCompiler schemaCompiler = this.newSchemaCompiler();
                if (pipe.getErrorListener() != null) {
                    schemaCompiler.setErrorListener(pipe.getErrorListener());
                }
                return schemaCompiler.readSchema(pipe, baseURI, schemaLocation, expected);
            }
            return expected;
        }
    }

    @Override
    public void readMultipleSchemas(PipelineConfiguration pipe, String baseURI, Collection<String> schemaLocations, String expected) throws SchemaException {
        this.newSchemaCompiler().readMultipleSchemas(pipe, baseURI, schemaLocations, expected);
    }

    @Override
    public String readInlineSchema(NodeInfo root, String expected, ErrorListener errorListener) throws SchemaException {
        return this.newSchemaCompiler().readInlineSchema(root, expected, errorListener);
    }

    @Override
    public void addSchemaSource(Source schemaSource, ErrorListener errorListener) throws SchemaException {
        SchemaDocument schemadoc;
        if (schemaSource instanceof SAXSource && this.getBooleanProperty(Feature.IGNORE_SAX_SOURCE_PARSER)) {
            ((SAXSource)schemaSource).setXMLReader(null);
        }
        SchemaCompiler compiler = this.newSchemaCompiler();
        if (errorListener != null) {
            compiler.setErrorListener(errorListener);
        }
        PipelineConfiguration pipe = this.makePipelineConfiguration();
        pipe.setErrorListener(errorListener == null ? this.getErrorListener() : errorListener);
        pipe.setHostLanguage(52);
        try {
            schemadoc = SchemaReader.read(schemaSource, compiler, pipe, null);
        }
        catch (UncheckedXPathException e) {
            XPathException xe = e.getXPathException();
            if (xe instanceof SchemaException) {
                throw (SchemaException)xe;
            }
            throw new SchemaException(xe);
        }
        if (schemadoc.isCompiledSchemaDocument()) {
            try {
                this.importComponents(schemadoc.getDocument());
            }
            catch (XPathException e) {
                throw new SchemaException(e);
            }
        } else {
            compiler.validate(schemadoc);
            this.setNamespaceStatus(schemadoc.getTargetNamespace(), 3);
        }
    }

    public synchronized void addSchema(PreparedSchema pschema) throws SchemaException {
        this.checkLicensedFeature(1, "schema processing", pschema.getLocalLicenseId());
        if (pschema == this.superSchema) {
            return;
        }
        if (pschema instanceof SingleNamespaceSchema) {
            String targetNamespace = ((SingleNamespaceSchema)pschema).getTargetNamespace();
            this.setNamespaceStatus(targetNamespace, 3);
        } else {
            for (String ns : pschema.getTargetNamespaces()) {
                this.setNamespaceStatus(ns, 3);
            }
        }
        pschema.copyTo(this.superSchema, this.newSchemaCompiler());
        this.superSchema.setLocalLicenseId(pschema.getLocalLicenseId());
    }

    public synchronized void addSurrogateSchema(String namespace) {
        this.checkLicensedFeature(1, "schema processing", -1);
        this.setNamespaceStatus(namespace, 2);
    }

    @Override
    public void addSchemaForBuiltInNamespace(String namespace) {
        if (this.getNamespaceStatus(namespace) != 1) {
            return;
        }
        switch (namespace) {
            case "http://www.w3.org/XML/1998/namespace": {
                this.addSchemaForXmlNamespace();
                break;
            }
            case "http://www.w3.org/2001/XMLSchema-instance": {
                this.addSchemaForXsiNamespace();
                break;
            }
            case "http://www.w3.org/2005/xpath-functions": {
                InputSource is = StandardEntityResolver.fetch("xpath-functions.scm", this);
                if (is == null) {
                    throw new IllegalStateException("Failed to read internal copy of xpath-functions.scm");
                }
                try {
                    this.addSchemaSource(new StreamSource(is.getByteStream()), this.getErrorListener());
                    break;
                }
                catch (SchemaException e) {
                    throw new IllegalStateException("Failed to load internal copy of xpath-functions.scm");
                }
            }
            default: {
                throw new IllegalArgumentException(namespace);
            }
        }
    }

    private synchronized void addSchemaForXmlNamespace() {
        if (this.getNamespaceStatus("http://www.w3.org/XML/1998/namespace") == 1) {
            try {
                this.addSchema(XMLNamespaceSchema.buildSchema(this));
            }
            catch (SchemaException err) {
                throw new AssertionError((Object)err);
            }
            this.setNamespaceStatus("http://www.w3.org/XML/1998/namespace", 3);
        }
    }

    private synchronized void addSchemaForXsiNamespace() {
        if (this.getNamespaceStatus("http://www.w3.org/2001/XMLSchema-instance") == 1) {
            try {
                this.addSchema(XSINamespaceSchema.buildSchema(this));
            }
            catch (SchemaException err) {
                throw new AssertionError((Object)err);
            }
            this.setNamespaceStatus("http://www.w3.org/2001/XMLSchema-instance", 3);
        }
    }

    public synchronized int getNamespaceStatus(String namespace) {
        Integer s = this.namespaceStatus.get(namespace);
        if (s == null) {
            return 1;
        }
        return s;
    }

    public synchronized void setNamespaceStatus(String namespace, int status) {
        if (status == 1) {
            this.namespaceStatus.remove(namespace);
        } else {
            this.namespaceStatus.put(namespace, status);
        }
    }

    @Override
    public boolean isSchemaAvailable(String targetNamespace) {
        return this.getNamespaceStatus(targetNamespace) != 1;
    }

    public synchronized void removeSchema(String namespace) {
        this.namespaceStatus.remove(namespace);
    }

    @Override
    public synchronized Set<String> getImportedNamespaces() {
        return this.namespaceStatus.keySet();
    }

    public PreparedSchema getSuperSchema() {
        return this.superSchema;
    }

    @Override
    public void sealNamespace(String namespace) {
        if (!namespace.equals("http://ns.saxonica.com/anonymous-type")) {
            this.setNamespaceStatus(namespace, 4);
        }
    }

    public boolean isSealedNamespace(String namespace) {
        return this.getNamespaceStatus(namespace) == 4;
    }

    @Override
    public Collection<GlobalParam> getDeclaredSchemaParameters() {
        return this.getSuperSchema().getGlobalParams();
    }

    @Override
    public Iterator<? extends SchemaType> getExtensionsOfType(SchemaType type) {
        if (type instanceof UserDefinedType) {
            return ((UserDefinedType)type).getExtensionTypes().iterator();
        }
        return this.getSuperSchema().getExtensionsOfBuiltInType(type.getFingerprint()).iterator();
    }

    @Override
    public void importComponents(Source source) throws XPathException {
        try {
            SchemaModelLoader loader = new SchemaModelLoader(this);
            PreparedSchema schema = loader.load(source);
            this.addSchema(schema);
            schema.copyTo(this.superSchema, this.newSchemaCompiler());
            for (String ns : schema.getTargetNamespaces()) {
                this.setNamespaceStatus(ns, 3);
            }
        }
        catch (SchemaException e) {
            throw new XPathException(e);
        }
    }

    @Override
    public void exportComponents(Receiver out) throws XPathException {
        SchemaModelSerializer serializer = new SchemaModelSerializer(this, out);
        serializer.serialize();
    }

    @Override
    public void clearSchemaCache() {
        this.superSchema = new PreparedSchema(this);
        this.namespaceStatus = new HashMap();
    }

    @Override
    public Function getSchemaAsFunctionItem() {
        Callable schemaFunction = (context, arguments) -> {
            String key;
            switch (key = arguments[0].head().getStringValue()) {
                case "class": {
                    return new StringValue("Schema");
                }
                case "type definitions": {
                    ArrayList<Function> list = new ArrayList<Function>();
                    Iterator<SchemaType> iter = this.getSuperSchema().iterateTypes();
                    while (iter.hasNext()) {
                        list.add(iter.next().getComponentAsFunction());
                    }
                    return SequenceExtent.makeSequenceExtent(list);
                }
                case "attribute declarations": {
                    ArrayList<Function> list = new ArrayList<Function>();
                    Iterator<AttributeDecl> iter = this.getSuperSchema().iterateAttributeDeclarations();
                    while (iter.hasNext()) {
                        list.add(iter.next().getComponentAsFunction());
                    }
                    return SequenceExtent.makeSequenceExtent(list);
                }
                case "element declarations": {
                    ArrayList<Function> list = new ArrayList<Function>();
                    Iterator<ElementDecl> iter = this.getSuperSchema().iterateElementDeclarations();
                    while (iter.hasNext()) {
                        list.add(iter.next().getComponentAsFunction());
                    }
                    return SequenceExtent.makeSequenceExtent(list);
                }
                case "attribute group definitions": {
                    ArrayList<Function> list = new ArrayList<Function>();
                    Iterator<AttributeGroupDecl> iter = this.getSuperSchema().iterateAttributeGroups();
                    while (iter.hasNext()) {
                        list.add(iter.next().getComponentAsFunction());
                    }
                    return SequenceExtent.makeSequenceExtent(list);
                }
                case "model group definitions": {
                    ArrayList<Function> list = new ArrayList<Function>();
                    Iterator<ModelGroupDefinition> iter = this.getSuperSchema().iterateModelGroups();
                    while (iter.hasNext()) {
                        list.add(iter.next().getComponentAsFunction());
                    }
                    return SequenceExtent.makeSequenceExtent(list);
                }
                case "notation declarations": {
                    ArrayList<Function> list = new ArrayList<Function>();
                    Iterator<Notation> iter = this.getSuperSchema().iterateNotations();
                    while (iter.hasNext()) {
                        list.add(iter.next().getComponentAsFunction());
                    }
                    return SequenceExtent.makeSequenceExtent(list);
                }
                case "identity-constraint definitions": {
                    ArrayList<Function> list = new ArrayList<Function>();
                    Iterator<IdentityConstraint> iter = this.getSuperSchema().iterateIdentityConstraints();
                    while (iter.hasNext()) {
                        list.add(iter.next().getComponentAsFunction());
                    }
                    return SequenceExtent.makeSequenceExtent(list);
                }
            }
            return EmptySequence.getInstance();
        };
        return new CallableFunction(1, schemaFunction, SchemaComponent.COMPONENT_FUNCTION_TYPE);
    }

    @Override
    public Function getSchemaComponentAsFunctionItem(String kind, QNameValue name) throws XPathException {
        if (kind.equals("type definition")) {
            SchemaType type = this.getSchemaType(name.getStructuredQName());
            return type == null ? null : type.getComponentAsFunction();
        }
        StructuredQName nn = name.getStructuredQName();
        switch (kind) {
            case "attribute declaration": {
                AttributeDecl decl = (AttributeDecl)this.getAttributeDeclaration(nn);
                return decl == null ? null : decl.getComponentAsFunction();
            }
            case "element declaration": {
                ElementDecl decl = (ElementDecl)this.getElementDeclaration(nn);
                return decl == null ? null : decl.getComponentAsFunction();
            }
            case "attribute group definition": {
                AttributeGroupDecl decl = this.getSuperSchema().getAttributeGroup(nn);
                return decl == null ? null : decl.getComponentAsFunction();
            }
            case "model group definition": {
                ModelGroupDefinition decl = this.getSuperSchema().getGroup(nn);
                return decl == null ? null : decl.getComponentAsFunction();
            }
            case "notation declarations": {
                Notation decl = this.getSuperSchema().getNotation(nn);
                return decl == null ? null : decl.getComponentAsFunction();
            }
            case "identity-constraint definitions": {
                IdentityConstraint decl = this.getSuperSchema().getIdentityConstraint(nn);
                return decl == null ? null : decl.getComponentAsFunction();
            }
        }
        throw new XPathException("Unknown component kind " + kind);
    }

    @Override
    public SchemaDeclaration getElementDeclaration(int fingerprint) {
        return this.superSchema.getElementDecl(fingerprint);
    }

    @Override
    public SchemaDeclaration getElementDeclaration(StructuredQName qName) {
        return this.superSchema.getElementDecl(qName);
    }

    @Override
    public SchemaDeclaration getAttributeDeclaration(int fingerprint) {
        return this.superSchema.getAttributeDecl(fingerprint);
    }

    @Override
    public SchemaDeclaration getAttributeDeclaration(StructuredQName attributeName) {
        return this.superSchema.getAttributeDecl(attributeName);
    }

    @Override
    public SchemaType getSchemaType(StructuredQName name) {
        SchemaType t;
        if (name.hasURI("http://www.w3.org/2001/XMLSchema") && (t = BuiltInType.getSchemaTypeByLocalName(name.getLocalPart())) != null) {
            return t;
        }
        return this.superSchema.getType(name);
    }

    @Override
    public UserUnionType makeUserUnionType(List<AtomicType> memberTypes) {
        ArrayList<TypeReference> memberRefs = new ArrayList<TypeReference>(memberTypes.size());
        for (AtomicType at : memberTypes) {
            TypeReference ref = new TypeReference(at.getFingerprint(), this, ExplicitLocation.UNKNOWN_LOCATION);
            memberRefs.add(ref);
        }
        UserUnionType uut = new UserUnionType(this);
        FastStringBuffer fsb = new FastStringBuffer(256);
        String sep = "";
        for (AtomicType at : memberTypes) {
            fsb.append(sep);
            sep = "-";
            fsb.append(at.getName());
        }
        StructuredQName name = new StructuredQName("anon", "http://ns.saxonica.com/anonymous-type", fsb.toString());
        uut.setTypeName(name, this.getNamePool().allocateFingerprint(name.getURI(), name.getLocalPart()));
        uut.setMemberTypeReferences(memberRefs);
        return uut;
    }

    @Override
    public boolean isDeclaredNotation(String uri, String local) {
        return this.superSchema.getNotation(new StructuredQName("", uri, local)) != null;
    }

    @Override
    public void checkTypeDerivationIsOK(SchemaType derived, SchemaType base, int block) throws SchemaException {
        if (derived.isSimpleType()) {
            String s = UserSimpleType.isTypeDerivationOK((SimpleType)derived, base, block);
            if (s != null) {
                throw new SchemaException(s);
            }
        } else {
            UserComplexType.checkTypeDerivation((ComplexType)derived, base, block);
        }
    }

    @Override
    public void prepareValidationReporting(XPathContext context, ParseOptions options) {
    }

    @Override
    public Receiver getDocumentValidator(Receiver receiver, String systemId, ParseOptions validationOptions, Location initiatingLocation) {
        int validationMode = validationOptions.getSchemaValidationMode();
        SpaceStrippingRule stripRules = validationOptions.getSpaceStrippingRule();
        SchemaType schemaType = validationOptions.getTopLevelType();
        StructuredQName topLevelElementName = validationOptions.getTopLevelElement();
        ValidationParams params = validationOptions.getValidationParams();
        PipelineConfiguration pipe = receiver.getPipelineConfiguration();
        if (validationMode == 1 || validationMode == 2 || schemaType != null) {
            int hostLanguage;
            Receiver destination = receiver;
            if (stripRules == null) {
                stripRules = this.getParseOptions().getSpaceStrippingRule();
            }
            if (stripRules == IgnorableSpaceStrippingRule.getInstance()) {
                destination = stripRules.makeStripper(destination);
            }
            ValidationContext vc = new ValidationContext(this.getConversionRules());
            vc.setInitiatingLocation(initiatingLocation);
            vc.setErrorLimit(validationOptions.getValidationErrorLimit());
            if (pipe.getController() == null) {
                pipe.setController(new Controller(this));
                pipe.getController().getExecutable().setSchemaAware(true);
            }
            vc.setController(pipe.getController());
            vc.setValidationParams(params);
            if (validationOptions.isCheckEntityReferences()) {
                EntityValidator ev = new EntityValidator(destination);
                ev.setValidationContext(vc);
                destination = ev;
            }
            this.allocateInvalidityHandler(validationOptions, vc);
            IdValidator idval = new IdValidator(destination);
            idval.setValidationContext(vc);
            ConstraintChecker checker = new ConstraintChecker(pipe);
            checker.setValidationContext(vc);
            destination = new TeeOutputter(idval, checker);
            destination = this.allocateAssertionTreeBuilder(destination, pipe, vc);
            ValidationStack val = new ValidationStack(destination, validationMode, schemaType);
            val.setPipelineConfiguration(pipe);
            val.setValidationContext(vc);
            vc.setConstraintChecker(checker);
            if (topLevelElementName != null) {
                val.setTopLevelElement(new FingerprintedQName(topLevelElementName.getPrefix(), topLevelElementName.getURI(), topLevelElementName.getLocalPart()));
            }
            if ((hostLanguage = pipe.getHostLanguage()) == 50) {
                if (schemaType != null) {
                    vc.setErrorCode("XTTE1540");
                } else if (validationMode == 1) {
                    vc.setErrorCode("XTTE1510");
                } else {
                    vc.setErrorCode("XTTE1515");
                }
            } else if (hostLanguage == 51) {
                vc.setErrorCode("XQDY0027");
            } else if (hostLanguage == 52) {
                vc.setErrorCode(null);
            }
            XSIAttributeHandler xsi = new XSIAttributeHandler(val);
            xsi.setSystemId(systemId);
            StartTagBufferEE stb = new StartTagBufferEE(xsi);
            vc.setStartTagBuffer(stb);
            xsi.setValidationContext(vc);
            checker.setStartTagBuffer(stb);
            PathMaintainer pathMaintainer = new PathMaintainer(stb);
            pipe.setComponent(PathMaintainer.class.getName(), pathMaintainer);
            DocumentValidator dv = new DocumentValidator(pathMaintainer, hostLanguage == 50 ? "XTTE1550" : "XQDY0061");
            LocationCopier copier = new LocationCopier(true);
            pipe.setComponent(CopyInformee.class.getName(), copier);
            vc.startValidation(systemId);
            return dv;
        }
        if (validationMode == 4) {
            SkipValidator a = new SkipValidator(receiver);
            ValidationContext vc = new ValidationContext(this.getConversionRules());
            a.setValidationContext(vc);
            a.setSystemId(systemId);
            return a;
        }
        return receiver;
    }

    private void allocateInvalidityHandler(ParseOptions validationOptions, ValidationContext vc) {
        if (validationOptions.getInvalidityHandler() == null) {
            UnfailingErrorListener listener = validationOptions.getErrorListener();
            if (listener == null) {
                Controller controller = vc.getController();
                listener = controller != null ? controller.getErrorListener() : this.getErrorListener();
            }
            vc.setInvalidityHandler(new InvalidityHandlerWrappingErrorListener(listener));
        } else {
            vc.setInvalidityHandler(validationOptions.getInvalidityHandler());
        }
    }

    @Override
    public Receiver getElementValidator(Receiver receiver, ParseOptions options, Location location) throws XPathException {
        int validation = options.getSchemaValidationMode();
        SchemaType schemaType = options.getTopLevelType();
        StructuredQName elemName = options.getTopLevelElement();
        if (validation == 4) {
            if (receiver.usesTypeAnnotations()) {
                return new SkipValidator(receiver);
            }
            return receiver;
        }
        Receiver destination = receiver;
        PipelineConfiguration pipe = receiver.getPipelineConfiguration();
        pipe.setRecoverFromValidationErrors(this.isValidationWarnings() || options.isContinueAfterValidationErrors());
        ValidationContext vc = new ValidationContext(this.getConversionRules());
        vc.setErrorLimit(options.getValidationErrorLimit());
        vc.setController(pipe.getController());
        vc.setValidationParams(options.getValidationParams());
        vc.setInitiatingLocation(location);
        this.allocateInvalidityHandler(options, vc);
        ConstraintChecker checker = new ConstraintChecker(pipe);
        checker.setValidationContext(vc);
        destination = new TeeOutputter(destination, checker);
        vc.setConstraintChecker(checker);
        destination = this.allocateAssertionTreeBuilder(destination, pipe, vc);
        ContentValidator contentValidator = null;
        if (validation == 8) {
            ArrayList<ValidationFailure> failures = new ArrayList<ValidationFailure>(1);
            contentValidator = ContentValidator.makeValidatorForType(null, schemaType, pipe, destination, failures);
            if (!failures.isEmpty()) {
                throw ((ValidationFailure)failures.get(0)).makeException();
            }
            assert (contentValidator != null);
            contentValidator.setContainingElement(options.getTopLevelElement(), location);
            contentValidator.setValidationContext(vc);
        } else if (validation != 3) {
            ElementDecl decl = null;
            if (elemName == null) {
                throw new IllegalArgumentException("When validating an element, either a type or an element name must be supplied");
            }
            decl = (ElementDecl)this.getElementDeclaration(elemName);
            if (decl == null || !decl.hasTypeAlternatives()) {
                ArrayList<ValidationFailure> failures = new ArrayList<ValidationFailure>(1);
                contentValidator = ContentValidator.makeValidator(decl, elemName, location, vc, schemaType, validation, pipe, destination, failures);
                if (!failures.isEmpty()) {
                    throw ((ValidationFailure)failures.get(0)).makeException();
                }
            }
        }
        ValidationStack vs = new ValidationStack(destination, 1, null);
        vs.setValidationContext(vc);
        vs.setPipelineConfiguration(pipe);
        int hostLanguage = pipe.getHostLanguage();
        if (hostLanguage == 50) {
            if (validation == 8) {
                vc.setErrorCode("XTTE1540");
            } else if (validation == 1) {
                vc.setErrorCode("XTTE1510");
            } else {
                vc.setErrorCode("XTTE1515");
            }
        } else if (hostLanguage == 51) {
            vc.setErrorCode("XQDY0027");
        } else if (hostLanguage == 52) {
            vc.setErrorCode(null);
        }
        if (contentValidator != null) {
            vs.setInitialValidator(contentValidator);
        }
        XSIAttributeHandler xsi = new XSIAttributeHandler(vs);
        StartTagBufferEE startTagBuffer = new StartTagBufferEE(xsi);
        vc.setStartTagBuffer(startTagBuffer);
        xsi.setValidationContext(vc);
        checker.setStartTagBuffer(startTagBuffer);
        destination = startTagBuffer;
        vc.startValidation(location.getSystemId());
        return destination;
    }

    private Receiver allocateAssertionTreeBuilder(Receiver destination, PipelineConfiguration pipe, ValidationContext vc) {
        if (this.xsdVersion == 11) {
            boolean retainComments = this.getBooleanProperty(Feature.ASSERTIONS_CAN_SEE_COMMENTS);
            AssertionTreeBuilder atb = new AssertionTreeBuilder(destination, retainComments);
            atb.setPipelineConfiguration(pipe);
            pipe.setComponent(AssertionTreeBuilder.class.getName(), atb);
            destination = atb;
            vc.setAssertionTreeBuilder(atb);
        }
        return destination;
    }

    @Override
    public SimpleType validateAttribute(StructuredQName nodeName, CharSequence value, int validation) throws ValidationException, MissingComponentException {
        if (this.isLicenseNotFound()) {
            return BuiltInAtomicType.UNTYPED_ATOMIC;
        }
        AttributeDecl decl = (AttributeDecl)this.getAttributeDeclaration(nodeName);
        if (decl == null) {
            if (validation == 1) {
                ValidationFailure ve = new ValidationFailure("No global attribute declaration found for attribute " + nodeName.getDisplayName());
                ve.setErrorCode("XTTE1512");
                throw ve.makeException();
            }
            return BuiltInAtomicType.UNTYPED_ATOMIC;
        }
        SimpleType type = decl.getSimpleType();
        if (type.isNamespaceSensitive()) {
            ValidationFailure err = new ValidationFailure("Cannot create a parentless attribute whose type is namespace-sensitive (such as xs:QName)");
            err.setSchemaType(type);
            err.setErrorCode("XTTE1545");
            throw err.makeException();
        }
        ValidationFailure err = type.validateContent(value, DummyNamespaceResolver.getInstance(), this.getConversionRules());
        if (err != null) {
            err.setSchemaType(type);
            err.setErrorCode(validation == 1 ? "XTTE1510" : "XTTE1515");
            throw err.makeException();
        }
        return type;
    }

    @Override
    public Receiver getAnnotationStripper(Receiver destination) {
        return new SkipValidator(destination);
    }

    @Override
    public XPathParser newExpressionParser(String language, boolean updating, int languageVersion) throws XPathException {
        if (updating && !this.isLicensedFeature(4)) {
            throw new IllegalArgumentException("XQuery Update requires a Saxon-EE license");
        }
        if ("XQ".equals(language)) {
            if (languageVersion == 31 || languageVersion == 30 || languageVersion == 10) {
                XQueryParser parser = new XQueryParser();
                if (this.isLicensedFeature(4)) {
                    parser.setParserExtension(new XQueryParserExtensionEE(updating));
                }
                return parser;
            }
            throw new IllegalArgumentException("Unknown XQuery version " + languageVersion);
        }
        XPathParser parser = super.newExpressionParser(language, updating, languageVersion);
        if (languageVersion >= 30) {
            parser.setAccelerator(new QuickXPathParser());
        }
        return parser;
    }

    @Override
    public ExpressionPresenter newExpressionExporter(String target, OutputStream destination, StylesheetPackage rootPackage) throws XPathException {
        if (!this.isLicensedFeature(2)) {
            throw new XPathException("Stylesheet export requires a Saxon-EE license");
        }
        ExpressionPresenter presenter = new ExpressionPresenter();
        ExpressionPresenter.ExportOptions options = new ExpressionPresenter.ExportOptions();
        options.rootPackage = rootPackage;
        presenter.setOptions(options);
        switch (target) {
            case "JS": {
                options.target = "JS";
                options.targetVersion = 1;
                presenter.init((Configuration)this, new StreamResult(destination), true);
                break;
            }
            case "JS2": {
                options.target = "JS";
                options.targetVersion = 2;
                PipelineConfiguration pipe = this.makePipelineConfiguration();
                JSONEmitter writer = new JSONEmitter(pipe, new StreamResult(destination), new Properties());
                presenter.init((Configuration)this, new ExpressionPresenterToJson(writer, pipe), true);
                break;
            }
            default: {
                options.target = target;
                options.targetVersion = 1;
                presenter.init((Configuration)this, new StreamResult(destination), true);
            }
        }
        return presenter;
    }

    @Override
    public PendingUpdateList newPendingUpdateList() {
        return new PendingUpdateListImpl(this);
    }

    @Override
    public PipelineConfiguration makePipelineConfiguration() {
        PipelineConfiguration pipe = super.makePipelineConfiguration();
        pipe.setSchemaURIResolver(this.getSchemaURIResolver());
        return pipe;
    }

    @Override
    public FilterFactory makeDocumentProjector(PathMap.PathMapRoot map) {
        this.checkLicensedFeature(4, "document projection", -1);
        return next -> new Projector(map, next);
    }

    @Override
    public FilterFactory makeDocumentProjector(XQueryExpression exp) {
        PathMap map;
        PathMap.PathMapRoot contextRoot;
        if (exp instanceof XQueryExpressionEE && (contextRoot = (map = ((XQueryExpressionEE)exp).getPathMap()).getContextDocumentRoot()) != null && !contextRoot.hasUnknownDependencies()) {
            return this.makeDocumentProjector(contextRoot);
        }
        return null;
    }

    @Override
    public java.util.function.Function<SequenceIterator<?>, FocusTrackingIterator<?>> getFocusTrackerFactory(Executable exec, boolean multithreaded) {
        if (multithreaded || this.getBooleanProperty(Feature.ALLOW_MULTITHREADING) && exec.createsSecondaryResult() && this.isLicensedFeature(2)) {
            return MultithreadedFocusTrackingIterator::new;
        }
        return FocusTrackingIterator::new;
    }

    public void setStreamability(int streamability) {
        if (streamability != 0) {
            this.checkLicensedFeature(2, "streaming", -1);
        }
        if (streamability != 1 && streamability != 0) {
            throw new IllegalArgumentException("The optional streamability='extended' is no longer recognized");
        }
        this.streamability = streamability;
    }

    @Override
    public int getStreamability() {
        if (this.streamability == -1) {
            this.streamability = this.isLicensedFeature(2) || this.isLicensedFeature(4) ? 1 : 0;
        }
        return this.streamability;
    }

    @Override
    public Receiver makeStreamingTransformer(XPathContext context, Mode mode, ParameterSet ordinaryParams, ParameterSet tunnelParams) throws XPathException {
        Set<? extends Accumulator> modeAccs;
        this.checkLicensedFeature(2, "streaming", -1);
        PipelineConfiguration pipe = context.getController().makePipelineConfiguration();
        AccumulatorRegistryEE am = (AccumulatorRegistryEE)((PreparedStylesheet)context.getController().getExecutable()).getTopLevelPackage().getAccumulatorRegistry();
        Set<Object> accumulators = null;
        if (mode instanceof ModeEE && (modeAccs = ((ModeEE)mode).getAccumulators()) != null) {
            accumulators = modeAccs;
        }
        if (accumulators == null) {
            accumulators = Collections.emptySet();
        }
        WatchManager wm = new WatchManager(pipe);
        wm.setXPathContext(context);
        if (am != null) {
            Map<Accumulator, AccumulatorWatch> watchMap = AccumulatorRegistryEE.registerSelectedAccumulators(wm, accumulators);
            wm.setAccumulatorWatchMap(watchMap);
        }
        StartTagBuffer stb = new StartTagBuffer(wm);
        wm.setStartTagBuffer(stb);
        Receiver out = context.getReceiver();
        DecomposingFeed feed = new DecomposingFeed(out);
        ApplyTemplatesAction docWatch = new ApplyTemplatesAction(null, feed, context);
        docWatch.setMode(mode.getDeclaringComponent());
        docWatch.setWatchManager(wm);
        docWatch.setActualParams(ordinaryParams);
        docWatch.setTunnelParams(tunnelParams);
        Trigger watch = new Trigger(new NodeTestPattern(NodeKindTest.DOCUMENT), docWatch, context);
        wm.addWatch(watch, true);
        stb.setUnderlyingReceiver(wm);
        return new ContentDetector(stb);
    }

    @Override
    public Expression makeStreamInstruction(Expression hrefExp, Expression body, boolean streaming, ParseOptions options, PackageData packageData, Location location, RetainedStaticContext rsc) throws XPathException {
        if (streaming && this.isLicensedFeature(2)) {
            StreamInstr si = new StreamInstr(hrefExp, body, options);
            si.setLocation(location);
            si.setRetainedStaticContext(rsc);
            if (this.getBooleanProperty(Feature.STRICT_STREAMABILITY)) {
                ArrayList<String> reasons = new ArrayList<String>();
                si.checkStreamability(reasons, this.getStreamability(), true);
                ExpressionTool.clearStreamabilityData(si);
            }
            if (packageData != null) {
                return si.prepareForStreaming(packageData);
            }
            return si;
        }
        return super.makeStreamInstruction(hrefExp, body, streaming, options, packageData, location, rsc);
    }

    @Override
    public void checkStrictStreamability(XSLTemplate template, Expression body) throws XPathException {
        ContextItemStaticInfoEE info = (ContextItemStaticInfoEE)this.makeContextItemStaticInfo(template.getMatch().getItemType(), false);
        info.setContextPostureStriding();
        ArrayList<String> reasons = new ArrayList<String>();
        PostureAndSweep s = Streamability.getStreamability(body, info, reasons);
        if (s.getPosture() != Posture.GROUNDED) {
            StringBuilder message = new StringBuilder("Template rule is not guaranteed-streamable");
            for (String r : reasons) {
                message.append("\n  *  ").append(r);
            }
            template.compileError(message.toString(), "XTSE3430");
        }
        ExpressionTool.clearStreamabilityData(body);
    }

    @Override
    public boolean isStreamedNode(NodeInfo node) {
        return node instanceof FleetingNode;
    }

    @Override
    public OptimizerOptions getOptimizerOptions() {
        return this.optimizerOptions.intersect(OptimizerOptions.FULL_EE_OPTIMIZATION);
    }

    @Override
    public Optimizer obtainOptimizer() {
        if (!this.isLicensedFeature(1)) {
            return super.obtainOptimizer();
        }
        if (this.optimizer == null) {
            this.optimizer = new OptimizerEE(this);
            this.optimizer.setOptimizerOptions(this.optimizerOptions.intersect(OptimizerOptions.FULL_EE_OPTIMIZATION));
        }
        return this.optimizer;
    }

    @Override
    public Optimizer obtainOptimizer(OptimizerOptions options) {
        if (!this.isLicensedFeature(1)) {
            return super.obtainOptimizer(options);
        }
        OptimizerEE optimizer = new OptimizerEE(this);
        optimizer.setOptimizerOptions(options.intersect(OptimizerOptions.FULL_EE_OPTIMIZATION));
        return optimizer;
    }

    @Override
    public boolean isGenerateByteCode(int hostLanguage) {
        return this.getBooleanProperty(Feature.GENERATE_BYTE_CODE) && this.isLicensedFeature(hostLanguage == 50 ? 2 : 4);
    }

    @Override
    public boolean isDeferredByteCode(int hostLanguage) {
        return this.byteCodeThreshold > 0 && this.isLicensedFeature(hostLanguage == 50 ? 2 : 4);
    }

    @Override
    public boolean isJITEnabled() {
        return this.optimizerOptions.isSet(1024) && this.isLicensedFeature(2);
    }

    @Override
    public XQueryExpression makeXQueryExpression(Expression exp, QueryModule mainModule, boolean streaming) throws XPathException {
        return new XQueryExpressionEE(exp, mainModule, streaming);
    }

    @Override
    public RegularExpression compileRegularExpression(CharSequence regex, String flags, String hostLanguage, List<String> warnings) throws XPathException {
        if (this.optimizerOptions.isSet(4096)) {
            ++this.regexAttempts;
            FastStringBuffer buff = new FastStringBuffer(regex.length() + flags.length() + hostLanguage.length() + 1);
            buff.append(hostLanguage);
            buff.append(flags);
            buff.append('=');
            buff.append(regex);
            String key = buff.toString();
            RegularExpression re = this.regexCache.get(key);
            if (re == null) {
                re = super.compileRegularExpression(regex, flags, hostLanguage, warnings);
                this.regexCache.put(key, re);
                if (this.regexCache.size() == 1000 && this.regexAttempts < 5000L) {
                    this.optimizerOptions = new OptimizerOptions(this.optimizerOptions.getOptions() & 0xFFFFEFFF);
                    this.regexCache.clear();
                }
            }
            return re;
        }
        return super.compileRegularExpression(regex, flags, hostLanguage, warnings);
    }

    @Override
    public SlotManager makeSlotManager() {
        if (this.getDebugger() != null) {
            return super.makeSlotManager();
        }
        if (this.isLicensedFeature(1)) {
            return new SlotManagerEE();
        }
        return new SlotManager();
    }

    public int getResultDocumentThreadsLimit() {
        return this.resultDocumentThreadsLimit;
    }

    @Override
    public void processResultDocument(ResultDocument instruction, Expression content, XPathContext context) throws XPathException {
        RegexIterator regexItr;
        GroupIterator groupItr;
        if (this.resultDocumentThreadsLimit <= 1 || !this.getBooleanProperty(Feature.ALLOW_MULTITHREADING) || !instruction.isAsynchronous() || !this.isLicensedFeature(2) || instruction.getHref() == null || context.getContextItem() instanceof FleetingNode || context.getThreadManager() == null) {
            super.processResultDocument(instruction, content, context);
            return;
        }
        ThreadManagerEE manager = (ThreadManagerEE)context.getThreadManager();
        XPathContextMajor c3 = XPathContextMajor.newThreadContext((XPathContextMinor)context);
        c3.setOrigin(instruction);
        if (context.getCurrentIterator() != null) {
            ManualIterator manualIterator = new ManualIterator(context.getContextItem(), context.getCurrentIterator().position());
            LastPositionFinder positionFinder = context::getLast;
            manualIterator.setLastPositionFinder(positionFinder);
            c3.setCurrentIterator(manualIterator);
        }
        if ((groupItr = context.getCurrentGroupIterator()) != null) {
            ManualGroupIterator manualGroupIterator = groupItr.getSnapShot(context);
            c3.setCurrentGroupIterator(manualGroupIterator);
        }
        if ((regexItr = context.getCurrentRegexIterator()) != null) {
            ManualRegexIterator manualRegexIterator = new ManualRegexIterator(regexItr);
            c3.setCurrentRegexIterator(manualRegexIterator);
        }
        java.util.concurrent.Callable<Outcome> task = () -> {
            try {
                instruction.processInstruction(content, c3);
                return new Outcome<Boolean>(true);
            }
            catch (Exception e) {
                return new Outcome(e);
            }
        };
        manager.getCompletionService().submit(task);
    }

    public MultithreadingFactory getMultithreadingFactory() {
        return this.multithreadingFactory;
    }

    public void setMultithreadingFactory(MultithreadingFactory factory) {
        this.multithreadingFactory = factory;
    }

    @Override
    public <F extends Item<?>, T extends Item<?>> SequenceIterator<T> getMultithreadedItemMappingIterator(SequenceIterator<F> base, ItemMappingFunction<F, T> action) throws XPathException {
        if (this.isLicensedFeature(1) && this.getBooleanProperty(Feature.ALLOW_MULTITHREADING)) {
            return this.multithreadingFactory.makeMultithreadedItemMappingIterator(base, action);
        }
        return super.getMultithreadedItemMappingIterator(base, action);
    }

    @Override
    public Sequence<?> makeClosure(Expression expression, int ref, XPathContext context) throws XPathException {
        if (ref == 10000) {
            return SearchableValue.makeSearchableValue(expression.iterate(context));
        }
        return super.makeClosure(expression, ref, context);
    }

    @Override
    public GroundedValue<?> makeSequenceExtent(Expression expression, int ref, XPathContext context) throws XPathException {
        if (ref == 10000) {
            return SearchableValue.makeSearchableValue(expression.iterate(context));
        }
        return expression.iterate(context).materialize();
    }

    @Override
    public void declareBuiltInExtensionElementNamespaces() {
        try {
            this.setExtensionElementNamespace("http://saxon.sf.net/", SaxonElementFactoryEE.class.getName());
            this.setExtensionElementNamespace("http://icl.com/saxon", Saxon6ElementFactory.class.getName());
            this.setExtensionElementNamespace("http://saxonica.com/ns/interactiveXSLT", IXSLElementFactory.class.getName());
        }
        catch (XPathException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    @Override
    public ContextItemStaticInfo makeContextItemStaticInfo(ItemType itemType, boolean maybeUndefined) {
        if (this.isLicensedFeature(2) || this.isLicensedFeature(4)) {
            ContextItemStaticInfoEE cit = new ContextItemStaticInfoEE(itemType, maybeUndefined);
            cit.setStrictStreamabilityRules(this.getBooleanProperty(Feature.STRICT_STREAMABILITY));
            return cit;
        }
        return super.makeContextItemStaticInfo(itemType, maybeUndefined);
    }

    @Override
    public ContextItemStaticInfo getDefaultContextItemStaticInfo() {
        return ContextItemStaticInfoEE.DEFAULT;
    }

    @Override
    public SimpleMode makeMode(StructuredQName modeName, CompilerInfo compilerInfo) {
        if (this.isLicensedFeature(2)) {
            return new ModeEE(modeName, compilerInfo);
        }
        return new ModePE(modeName);
    }

    @Override
    public TemplateRuleEE makeTemplateRule() {
        return new TemplateRuleEE();
    }

    @Override
    public XPathContextMajor.ThreadManager makeThreadManager() {
        if (this.getBooleanProperty(Feature.ALLOW_MULTITHREADING)) {
            return this.multithreadingFactory.makeThreadManager();
        }
        return null;
    }

    @Override
    public CompilerInfo makeCompilerInfo() {
        return super.makeCompilerInfo();
    }

    @Override
    public CompilerService makeCompilerService(int hostLanguage) {
        return new CompilerService(this, hostLanguage);
    }

    public ByteCodeMonitor obtainByteCodeMonitor() {
        if (this.byteCodeMonitor == null) {
            this.byteCodeMonitor = new ByteCodeMonitor();
        }
        return this.byteCodeMonitor;
    }

    @Override
    public void createByteCodeReport(String fileName) {
        try {
            PrintWriter w = new PrintWriter(new File(fileName));
            if (this.byteCodeMonitor != null) {
                this.byteCodeMonitor.report(w);
            } else {
                w.println("<no-hot-spot-byte-code-generated/>");
            }
            w.close();
        }
        catch (FileNotFoundException e) {
            System.err.println("Unable to produce bytecode monitoring report: " + e.getMessage());
        }
    }
}

