/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.optim;

import com.saxonica.ee.stream.PostureAndSweep;
import com.saxonica.ee.stream.StreamInstr;
import com.saxonica.ee.stream.Streamability;
import com.saxonica.xsltextn.instruct.DoInstr;
import java.util.IdentityHashMap;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.GlobalVariableReference;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.TryCatch;
import net.sf.saxon.expr.instruct.GlobalVariable;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RetainedStaticContext;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.lib.Logger;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.GlobalVariableManager;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceType;

public class GlobalExtractor {
    private Expression root;
    private GlobalVariableManager globalVariableManager;
    private ExpressionVisitor visitor;
    private IdentityHashMap<Expression, String> ineligibles = new IdentityHashMap();
    private boolean tracing;
    public static final int COST_THRESHOLD = 3;

    public GlobalExtractor(Expression root, GlobalVariableManager globalVariableManager, ExpressionVisitor visitor) {
        this.root = root;
        this.globalVariableManager = globalVariableManager;
        this.visitor = visitor;
        this.tracing = visitor.getConfiguration().getBooleanProperty(Feature.TRACE_OPTIMIZER_DECISIONS);
    }

    public Expression extractGlobals() throws XPathException {
        this.markIneligibleExpressions(this.root, this.visitor.isOptimizeForStreaming());
        return this.processTree(this.root);
    }

    private double markIneligibleExpressions(Expression expr, boolean forStreaming) {
        if (expr instanceof LetExpression && ((LetExpression)expr).isNeedsLazyEvaluation()) {
            this.markSubtreeIneligible(expr);
            return 100.0;
        }
        if (expr instanceof DoInstr) {
            this.markSubtreeIneligible(expr);
        } else if (!expr.isLiftable(forStreaming) || expr instanceof StreamInstr) {
            this.markAncestorsIneligible(expr);
        } else if ((expr.getDependencies() & 0xFFFFFBFF) != 0) {
            this.ineligibles.put(expr, "this");
        } else if (expr instanceof TryCatch) {
            this.markSubtreeIneligible(expr);
            return 100.0;
        }
        double cost = expr.getCost();
        for (Operand o : expr.operands()) {
            double subcost = this.markIneligibleExpressions(o.getChildExpression(), forStreaming);
            if (!(subcost > cost)) continue;
            cost = subcost;
        }
        if (cost < 3.0) {
            this.markSubtreeIneligible(expr);
        }
        return cost;
    }

    private void markAncestorsIneligible(Expression expr) {
        for (Expression parent = expr; parent != null; parent = parent.getParentExpression()) {
            if (this.ineligibles.get(parent) != null) continue;
            this.ineligibles.put(parent, "this");
        }
    }

    private void markSubtreeIneligible(Expression expr) {
        this.ineligibles.put(expr, "all");
    }

    private Expression processTree(Expression expr) throws XPathException {
        String label = this.ineligibles.get(expr);
        if (label == null) {
            return this.promoteToGlobal(expr);
        }
        if (label.equals("all")) {
            return expr;
        }
        if (label.equals("this")) {
            for (Operand o : expr.operands()) {
                o.setChildExpression(this.processTree(o.getChildExpression()));
            }
            return expr;
        }
        throw new IllegalStateException();
    }

    private Expression promoteToGlobal(Expression expr) throws XPathException {
        GlobalVariable v = this.globalVariableManager.getEquivalentVariable(expr);
        if (v != null) {
            GlobalVariableReference ref = new GlobalVariableReference(v);
            SequenceType type = SequenceType.makeSequenceType(expr.getItemType(), expr.getCardinality());
            ref.setStaticType(type, null, expr.getSpecialProperties() | 0x800000);
            ref.setRetainedStaticContext(this.visitor.getStaticContext().makeRetainedStaticContext());
            return ref;
        }
        RetainedStaticContext rsc = expr.getRetainedStaticContext();
        GlobalVariable gvd = new GlobalVariable();
        gvd.setPackageData(rsc.getPackageData());
        gvd.setSystemId(expr.getLocation().getSystemId());
        gvd.setLineNumber(expr.getLocation().getLineNumber());
        gvd.setRequiredType(SequenceType.makeSequenceType(expr.getItemType(), expr.getCardinality()));
        gvd.setSelectExpression(expr);
        expr.setRetainedStaticContext(rsc);
        StructuredQName varName = new StructuredQName("vv", "http://saxon.sf.net/generated-variable", "gg" + gvd.hashCode());
        gvd.setVariableQName(varName);
        this.globalVariableManager.addGlobalVariable(gvd);
        GlobalVariableReference ref = new GlobalVariableReference(gvd);
        Streamability.setPostureAndSweep(ref, PostureAndSweep.GROUNDED_AND_MOTIONLESS);
        ref.setRetainedStaticContext(this.visitor.getStaticContext().makeRetainedStaticContext());
        gvd.registerReference(ref);
        gvd.typeCheck(this.visitor);
        SlotManager localSlotManager = this.visitor.getConfiguration().makeSlotManager();
        int slots = ExpressionTool.allocateSlots(expr, 0, localSlotManager);
        if (slots > 0) {
            gvd.setContainsLocals(localSlotManager);
        }
        gvd.init(expr, varName);
        if (this.tracing) {
            Logger err = this.visitor.getConfiguration().getLogger();
            err.info("OPT : At line " + expr.getLocation().getLineNumber() + " of " + expr.getLocation().getSystemId());
            err.info("OPT : Extracted global variable " + varName.getDisplayName() + " := " + expr.toString());
        }
        return ref;
    }
}

