/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema;

import com.saxonica.ee.schema.DigitsFacet;
import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.TotalDigitsFacet;
import com.saxonica.ee.schema.UserSimpleType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.ValidationException;

public class FractionDigitsFacet
extends DigitsFacet {
    @Override
    public String getName() {
        return "fractionDigits";
    }

    @Override
    public void setValue(String value) throws SchemaException {
        int val;
        try {
            val = Integer.parseInt(value);
        }
        catch (NumberFormatException err) {
            throw new SchemaException("Value of fractionDigits must be an integer");
        }
        if (val < 0) {
            throw new SchemaException("Value of fractionDigits must not be negative");
        }
        this.setNumericValue(val);
    }

    @Override
    public void checkFacetRestriction(UserSimpleType type, SimpleType base, SchemaCompiler compiler) throws SchemaException, ValidationException {
        UserSimpleType ubase;
        DigitsFacet f;
        super.checkFacetRestriction(type, base, compiler);
        int primitive = ((AtomicType)base).getPrimitiveType();
        if (primitive == 533 && this.getNumericValue() != 0) {
            throw new SchemaException("The fractionDigits facet on an integer type must be zero");
        }
        TotalDigitsFacet total = (TotalDigitsFacet)type.getFacet(TotalDigitsFacet.class);
        if (total != null && total.getNumericValue() < this.getNumericValue()) {
            throw new SchemaException("The fractionDigits facet exceeds the totalDigits");
        }
        if (base instanceof UserSimpleType && (f = (DigitsFacet)(ubase = (UserSimpleType)base).getFacet(FractionDigitsFacet.class)) != null) {
            if (this.getNumericValue() > f.getNumericValue()) {
                throw new SchemaException("The fractionDigits facet must not exceed the value on the base type");
            }
            if (f.isFixed() && this.getNumericValue() != f.getNumericValue()) {
                throw new SchemaException("The fractionDigits facet is fixed in the base type and cannot be varied");
            }
        }
    }
}

