/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.trans;

import com.saxonica.ee.stream.Streamability;
import com.saxonica.ee.stream.Sweep;
import com.saxonica.ee.trans.TemplateRuleEE;
import java.util.ArrayList;
import net.sf.saxon.expr.ErrorExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.instruct.TemplateRule;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.XSLTemplate;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.SimpleMode;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.rules.RuleManager;

public class TemplateRuleInitializer {
    private Compilation compilation;
    private XSLTemplate xslTemplate;
    private ComponentDeclaration decl;
    private StructuredQName modeName;
    private boolean firstTime = true;

    public TemplateRuleInitializer(Compilation comp, ComponentDeclaration decl, StructuredQName modeName) {
        this.compilation = comp;
        this.decl = decl;
        this.modeName = modeName;
        this.xslTemplate = (XSLTemplate)decl.getSourceElement();
    }

    public synchronized void init() throws XPathException {
        if (this.firstTime) {
            TemplateRule rule = this.xslTemplate.getTemplateRulesByMode().get(this.modeName);
            try {
                this.xslTemplate.jitCompile(this.compilation, this.decl);
                ExpressionVisitor visitor = new ExpressionVisitor(this.compilation.getConfiguration());
                visitor.setStaticContext(this.xslTemplate.getStaticContext());
                ContextItemStaticInfo cisi = new ContextItemStaticInfo(this.xslTemplate.getContextItemTypeForTemplateRule(), false);
                RuleManager mgr = this.compilation.getPrincipalStylesheetModule().getRuleManager();
                Mode m = mgr.obtainMode(this.modeName, false);
                visitor.setOptimizeForStreaming(m.isDeclaredStreamable());
                Expression body = rule.getBody().typeCheck(visitor, cisi);
                rule.setBody(ExpressionTool.optimizeComponentBody(body, this.compilation, visitor, cisi, false));
                SimpleMode.allocateBindingSlotsRecursive(this.xslTemplate.getPackageData(), m, rule.getBody(), m.getDeclaringComponent().getComponentBindings());
                ExpressionTool.allocateSlots(rule.getBody(), rule.getStackFrameMap().getNumberOfVariables(), rule.getStackFrameMap());
                if (m.isDeclaredStreamable()) {
                    ArrayList<String> reasons = new ArrayList<String>();
                    if (!((TemplateRuleEE)rule).isActuallyStreamable(reasons)) {
                        String message = "Template rule is not streamable";
                        for (String reason : reasons) {
                            message = message + "\n  * " + reason;
                        }
                        throw new XPathException(message, "XTSE3430", rule);
                    }
                    if (Streamability.getSweep(rule.getBody()) == Sweep.CONSUMING) {
                        ((TemplateRuleEE)rule).makeInversion();
                    }
                }
            }
            catch (XPathException e) {
                rule.setBody(new ErrorExpression(e));
                this.firstTime = false;
                throw e;
            }
            this.firstTime = false;
        }
    }
}

