/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.extfn;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.ee.extfn.ExperimentalXPathCompiler;
import com.saxonica.expr.HofParserExtension;
import java.util.ArrayList;
import net.sf.saxon.expr.parser.XPathParser;
import net.sf.saxon.ma.arrays.ArrayItem;
import net.sf.saxon.ma.arrays.SimpleArrayItem;
import net.sf.saxon.ma.map.DictionaryMap;
import net.sf.saxon.ma.map.KeyValuePair;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.serialize.charcode.UTF16CharacterSet;
import net.sf.saxon.sxpath.IndependentContext;
import net.sf.saxon.trans.Err;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

public class ExperimentalSequenceTypeMarshaller {
    private String input;
    private int position = 0;

    public static StringValue unmarshal(MapItem type) {
        StringBuilder out = new StringBuilder();
        StringValue indicator = (StringValue)type.get(new StringValue("o"));
        out.append(indicator == null ? "1" : indicator.getStringValue());
        StringValue alphaCode = (StringValue)type.get(new StringValue("p"));
        out.append(alphaCode == null ? "" : alphaCode.getStringValue());
        out.append(" ");
        block19: for (KeyValuePair kvp : type.keyValuePairs()) {
            String key;
            switch (key = kvp.key.getStringValue()) {
                case "o": 
                case "p": {
                    continue block19;
                }
                case "n": 
                case "c": 
                case "t": {
                    out.append(key);
                    out.append(((StringValue)kvp.value).getStringValue());
                    out.append(" ");
                    continue block19;
                }
                case "k": 
                case "r": 
                case "v": 
                case "e": {
                    out.append(key);
                    out.append('[');
                    out.append(ExperimentalSequenceTypeMarshaller.unmarshal((MapItem)kvp.value).getStringValue());
                    out.append(']');
                    out.append(" ");
                    continue block19;
                }
                case "a": 
                case "u": {
                    out.append(key);
                    out.append('[');
                    ArrayItem types = (ArrayItem)kvp.value;
                    boolean first = true;
                    for (GroundedValue<?> t : types.members()) {
                        if (first) {
                            first = false;
                        } else {
                            out.append(",");
                        }
                        out.append(ExperimentalSequenceTypeMarshaller.unmarshal((MapItem)t).getStringValue());
                    }
                    out.append(']');
                    out.append(" ");
                    continue block19;
                }
            }
            throw new IllegalStateException("Unexpected key '" + key + "'");
        }
        return new StringValue(out.toString());
    }

    public static MapItem marshal(StringValue type) {
        String input = type.getStringValue();
        return new ExperimentalSequenceTypeMarshaller(input).parseType();
    }

    private ExperimentalSequenceTypeMarshaller(String input) {
        this.input = input;
    }

    private int next() {
        if (this.position >= this.input.length()) {
            return -1;
        }
        return this.input.charAt(this.position++);
    }

    private void expect(char c) {
        int d = this.next();
        if (d != c) {
            throw new IllegalStateException("Expected '" + c + "', found '" + d + "'");
        }
    }

    private int nextU() {
        char c;
        if (this.position >= this.input.length()) {
            return -1;
        }
        if (UTF16CharacterSet.isHighSurrogate(c = this.input.charAt(this.position++))) {
            char d = this.input.charAt(this.position++);
            return UTF16CharacterSet.combinePair(c, d);
        }
        return c;
    }

    private String readUntil(char delimiter) {
        StringBuilder sb = new StringBuilder();
        while (this.position < this.input.length()) {
            char c = this.input.charAt(this.position);
            if (c == delimiter) {
                return sb.toString();
            }
            sb.append(c);
            ++this.position;
        }
        return sb.toString();
    }

    private MapItem parseType() {
        DictionaryMap map = new DictionaryMap();
        int indicator = this.next();
        map.initialPut("o", new StringValue("" + (char)indicator));
        int sp = this.input.indexOf(32, this.position);
        if (sp == -1) {
            sp = this.input.length();
        }
        map.initialPut("p", new StringValue(this.input.substring(this.position, sp)));
        this.position = sp + 1;
        block7: while (this.position < this.input.length()) {
            char c = this.input.charAt(this.position);
            switch (c) {
                case ',': 
                case ']': {
                    return map;
                }
                case ' ': {
                    ++this.position;
                    continue block7;
                }
                case 'c': 
                case 'n': 
                case 't': {
                    ++this.position;
                    sp = this.input.indexOf(32, this.position);
                    if (sp == -1) {
                        sp = this.input.length();
                    }
                    map.initialPut("" + c, new StringValue(this.input.substring(this.position, sp)));
                    this.position = sp + 1;
                    continue block7;
                }
                case 'e': 
                case 'k': 
                case 'r': 
                case 'v': {
                    ++this.position;
                    this.expect('[');
                    MapItem nestedType = this.parseType();
                    this.expect(']');
                    map.initialPut("" + c, nestedType);
                    ++this.position;
                    continue block7;
                }
                case 'a': 
                case 'u': {
                    ++this.position;
                    this.expect('[');
                    ArrayList nestedTypes = new ArrayList();
                    if (this.input.charAt(this.position) == ']') {
                        ++this.position;
                        map.initialPut("" + c, new SimpleArrayItem(nestedTypes));
                        continue block7;
                    }
                    while (true) {
                        nestedTypes.add(this.parseType());
                        if (this.input.charAt(this.position) != ',') break;
                        ++this.position;
                    }
                    this.expect(']');
                    map.initialPut("" + c, new SimpleArrayItem(nestedTypes));
                    continue block7;
                }
            }
            throw new IllegalStateException("Expected one of n|c|t|k|r|v|a|u, found '" + c + "'");
        }
        return map;
    }

    public static void main(String[] args) throws Exception {
        String[] testCases;
        EnterpriseConfiguration config = new EnterpriseConfiguration();
        IndependentContext ic = new IndependentContext(config);
        ic.declareNamespace("foo", "http://foo.com/");
        XPathParser parser = new XPathParser();
        parser.setParserExtension(new HofParserExtension());
        parser.setLanguage(0, 31);
        for (String s : testCases = new String[]{"item()", "item()*", "xs:anyAtomicType?", "xs:string*", "xs:integer+", "node()", "element(foo)", "element(foo:bar)", "xs:numeric*", "xs:dayTimeDuration", "map(*)", "map(xs:string, node()*)", "array(*)", "array(array(xs:integer*))", "empty-sequence()", "function(*)", "function(xs:int, xs:int) as xs:date", "function(xs:int) as (function() as xs:date*)*", "document-node(element(foo, xs:integer))?"}) {
            SequenceType t = parser.parseSequenceType(s, ic);
            MapItem map = ExperimentalXPathCompiler.makeMap(t);
            String json = Err.depict(map).toString();
            String lex = ExperimentalSequenceTypeMarshaller.unmarshal(map).getStringValue();
            MapItem map2 = ExperimentalSequenceTypeMarshaller.marshal(new StringValue(lex));
            String json2 = Err.depict(map2).toString();
            String lex2 = ExperimentalSequenceTypeMarshaller.unmarshal(map2).getStringValue();
            System.out.println(s + " => " + json + " => " + lex + " => " + json2 + " => " + lex2);
        }
    }
}

