/*
 * Decompiled with CFR 0.152.
 */
package experimental.ising;

import experimental.ising.FeatureExtractor;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.javatuples.Pair;

public class UnaryFeatureExtractor
extends FeatureExtractor {
    private int maxPrefix;
    private int maxSuffix;
    private Map<Pair<Integer, String>, Integer> prefixFeatures;
    private Map<Pair<Integer, String>, Integer> suffixFeatures;
    private Map<Integer, String> int2Features;
    private int numFeatures = 0;
    private int startFeature;
    private int totalNumVariables;

    public UnaryFeatureExtractor(int maxPrefix, int maxSuffix) {
        this.setMaxPrefix(maxPrefix);
        this.setMaxSuffix(maxSuffix);
        this.prefixFeatures = new HashMap<Pair<Integer, String>, Integer>();
        this.suffixFeatures = new HashMap<Pair<Integer, String>, Integer>();
        this.int2Features = new HashMap<Integer, String>();
        this.setNumFeatures(0);
    }

    public void extract(String word) {
        Pair key;
        int v;
        int i;
        for (i = 0; i < this.maxPrefix; ++i) {
            if (i > word.length()) continue;
            String prefix = word.substring(0, i);
            for (v = 0; v < this.totalNumVariables; ++v) {
                key = new Pair((Object)v, (Object)prefix);
                if (this.prefixFeatures.containsKey(key)) continue;
                this.prefixFeatures.put((Pair<Integer, String>)key, this.numFeatures);
                this.int2Features.put(this.numFeatures, key + "\t POS");
                this.int2Features.put(this.numFeatures + 1, key + "\t NEG");
                this.numFeatures += 2;
            }
        }
        for (i = 0; i < this.maxSuffix; ++i) {
            if (word.length() - i < 0) continue;
            String suffix = word.substring(word.length() - i, word.length());
            for (v = 0; v < this.totalNumVariables; ++v) {
                key = new Pair((Object)v, (Object)suffix);
                if (this.suffixFeatures.containsKey(key)) continue;
                this.suffixFeatures.put((Pair<Integer, String>)key, this.numFeatures);
                this.int2Features.put(this.numFeatures, key + "\t POS");
                this.int2Features.put(this.numFeatures + 1, key + "\t NEG");
                this.numFeatures += 2;
            }
        }
    }

    public Pair<List<Integer>, List<Integer>> getFeatures(int variableId, String word) {
        int feat;
        Pair key;
        int i;
        LinkedList<Integer> featuresPos = new LinkedList<Integer>();
        LinkedList<Integer> featuresNeg = new LinkedList<Integer>();
        for (i = 0; i < this.maxPrefix; ++i) {
            if (i > word.length()) continue;
            String prefix = word.substring(0, i);
            key = new Pair((Object)variableId, (Object)prefix);
            feat = this.prefixFeatures.get(key);
            featuresPos.add(feat);
            featuresNeg.add(feat + 1);
        }
        for (i = 0; i < this.maxSuffix; ++i) {
            if (word.length() - i < 0) continue;
            String suffix = word.substring(word.length() - i, word.length());
            key = new Pair((Object)variableId, (Object)suffix);
            feat = this.suffixFeatures.get(key);
            featuresPos.add(feat);
            featuresNeg.add(feat + 1);
        }
        return new Pair(featuresPos, featuresNeg);
    }

    public int getStartFeature() {
        return this.startFeature;
    }

    public void setStartFeature(int startFeature) {
        this.startFeature = startFeature;
    }

    public int getTotalNumVariables() {
        return this.totalNumVariables;
    }

    public void setTotalNumVariables(int totalNumVariables) {
        this.totalNumVariables = totalNumVariables;
    }

    public int getMaxSuffix() {
        return this.maxSuffix;
    }

    public void setMaxSuffix(int maxSuffix) {
        this.maxSuffix = maxSuffix;
    }

    public int getMaxPrefix() {
        return this.maxPrefix;
    }

    public void setMaxPrefix(int maxPrefix) {
        this.maxPrefix = maxPrefix;
    }

    public int getNumFeatures() {
        return this.numFeatures;
    }

    public void setNumFeatures(int numFeatures) {
        this.numFeatures = numFeatures;
    }

    public Map<Integer, String> getInt2Feature() {
        return this.int2Features;
    }
}

