/*
 * Decompiled with CFR 0.152.
 */
package marmot.morph.mapper.latin;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import marmot.morph.mapper.MorphTag;
import marmot.morph.mapper.latin.ItMorphTag;
import marmot.morph.mapper.latin.LdtMorphTag;
import marmot.util.FileUtils;

public class ItLdtMapper {
    public MorphTag convert(ItMorphTag it_tag) {
        LdtMorphTag tag = new LdtMorphTag();
        if (it_tag.case_number == ItMorphTag.CaseNumber.G) {
            return tag;
        }
        this.setPerson(tag, it_tag);
        this.setNumber(tag, it_tag);
        this.setTense(tag, it_tag);
        this.setMoodAndVoice(tag, it_tag);
        this.setGender(tag, it_tag);
        this.setCase(tag, it_tag);
        this.setDegree(tag, it_tag);
        return tag;
    }

    private void setDegree(LdtMorphTag ldt_tag, ItMorphTag it_tag) {
        switch (it_tag.participials_degree_) {
            case Two: {
                ldt_tag.degree_ = LdtMorphTag.Degree.c;
                break;
            }
            case Three: {
                ldt_tag.degree_ = LdtMorphTag.Degree.s;
                break;
            }
            case Undef: 
            case One: {
                ldt_tag.degree_ = LdtMorphTag.Degree.Undef;
            }
        }
    }

    private void setCase(LdtMorphTag ldt_tag, ItMorphTag it_tag) {
        switch (it_tag.case_number) {
            case A: 
            case J: {
                ldt_tag.case_ = LdtMorphTag.Case.n;
                break;
            }
            case B: 
            case K: {
                ldt_tag.case_ = LdtMorphTag.Case.g;
                break;
            }
            case C: 
            case L: {
                ldt_tag.case_ = LdtMorphTag.Case.d;
                break;
            }
            case D: 
            case M: {
                ldt_tag.case_ = LdtMorphTag.Case.a;
                break;
            }
            case E: 
            case N: {
                ldt_tag.case_ = LdtMorphTag.Case.v;
                break;
            }
            case F: 
            case O: {
                ldt_tag.case_ = LdtMorphTag.Case.b;
                break;
            }
            default: {
                ldt_tag.case_ = LdtMorphTag.Case.Undef;
            }
        }
    }

    public Set<LdtMorphTag.Pos> getPosCandidates(LdtMorphTag ldt_tag, ItMorphTag it_tag) {
        HashSet<LdtMorphTag.Pos> candidates = new HashSet<LdtMorphTag.Pos>();
        if (it_tag.case_number == ItMorphTag.CaseNumber.G) {
            candidates.add(LdtMorphTag.Pos.d);
            return candidates;
        }
        switch (it_tag.flexional_type_) {
            case One: {
                if (it_tag.nominals_degree_ == ItMorphTag.NominalsDegree.One || it_tag.nominals_degree_ == ItMorphTag.NominalsDegree.Undef) {
                    candidates.add(LdtMorphTag.Pos.n);
                    candidates.add(LdtMorphTag.Pos.a);
                    candidates.add(LdtMorphTag.Pos.m);
                    candidates.add(LdtMorphTag.Pos.p);
                    break;
                }
                candidates.add(LdtMorphTag.Pos.a);
                break;
            }
            case Two: {
                candidates.add(LdtMorphTag.Pos.t);
                break;
            }
            case Three: {
                candidates.add(LdtMorphTag.Pos.v);
                break;
            }
            case Four: {
                if (it_tag.flexional_category_ == ItMorphTag.FlexionalCategory.O) {
                    candidates.add(LdtMorphTag.Pos.c);
                    candidates.add(LdtMorphTag.Pos.d);
                    break;
                }
                candidates.add(LdtMorphTag.Pos.r);
                break;
            }
            case Five: {
                if (it_tag.flexional_category_ != ItMorphTag.FlexionalCategory.G) break;
                candidates.add(LdtMorphTag.Pos.m);
                break;
            }
        }
        return candidates;
    }

    private void setGender(LdtMorphTag ldt_tag, ItMorphTag it_tag) {
        switch (it_tag.gender_number_person_) {
            case One: {
                ldt_tag.gender_ = LdtMorphTag.Gender.m;
                break;
            }
            case Two: {
                ldt_tag.gender_ = LdtMorphTag.Gender.f;
                break;
            }
            case Three: {
                ldt_tag.gender_ = LdtMorphTag.Gender.n;
                break;
            }
            default: {
                ldt_tag.gender_ = LdtMorphTag.Gender.Undef;
            }
        }
    }

    private void setMoodAndVoice(LdtMorphTag ldt_tag, ItMorphTag it_tag) {
        switch (it_tag.mood_) {
            case A: {
                ldt_tag.voice_ = LdtMorphTag.Voice.a;
                ldt_tag.mood_ = LdtMorphTag.Mood.i;
                break;
            }
            case J: {
                ldt_tag.voice_ = LdtMorphTag.Voice.p;
                ldt_tag.mood_ = LdtMorphTag.Mood.i;
                break;
            }
            case B: {
                ldt_tag.voice_ = LdtMorphTag.Voice.a;
                ldt_tag.mood_ = LdtMorphTag.Mood.s;
                break;
            }
            case K: {
                ldt_tag.voice_ = LdtMorphTag.Voice.p;
                ldt_tag.mood_ = LdtMorphTag.Mood.s;
                break;
            }
            case C: {
                ldt_tag.voice_ = LdtMorphTag.Voice.a;
                ldt_tag.mood_ = LdtMorphTag.Mood.m;
                break;
            }
            case L: {
                ldt_tag.voice_ = LdtMorphTag.Voice.p;
                ldt_tag.mood_ = LdtMorphTag.Mood.m;
                break;
            }
            case D: {
                ldt_tag.voice_ = LdtMorphTag.Voice.a;
                ldt_tag.mood_ = LdtMorphTag.Mood.p;
                break;
            }
            case M: {
                ldt_tag.voice_ = LdtMorphTag.Voice.p;
                ldt_tag.mood_ = LdtMorphTag.Mood.p;
                break;
            }
            case E: {
                ldt_tag.voice_ = LdtMorphTag.Voice.a;
                ldt_tag.mood_ = LdtMorphTag.Mood.d;
                break;
            }
            case N: {
                ldt_tag.voice_ = LdtMorphTag.Voice.p;
                ldt_tag.mood_ = LdtMorphTag.Mood.d;
                break;
            }
            case O: {
                ldt_tag.voice_ = LdtMorphTag.Voice.p;
                ldt_tag.mood_ = LdtMorphTag.Mood.g;
                break;
            }
            case G: {
                ldt_tag.voice_ = LdtMorphTag.Voice.a;
                ldt_tag.mood_ = LdtMorphTag.Mood.u;
                break;
            }
            case P: {
                ldt_tag.voice_ = LdtMorphTag.Voice.p;
                ldt_tag.mood_ = LdtMorphTag.Mood.u;
                break;
            }
            case H: {
                ldt_tag.voice_ = LdtMorphTag.Voice.a;
                ldt_tag.mood_ = LdtMorphTag.Mood.n;
                break;
            }
            case Q: {
                ldt_tag.voice_ = LdtMorphTag.Voice.p;
                ldt_tag.mood_ = LdtMorphTag.Mood.n;
                break;
            }
            case Undef: {
                ldt_tag.voice_ = LdtMorphTag.Voice.Undef;
                ldt_tag.mood_ = LdtMorphTag.Mood.Undef;
            }
        }
    }

    private void setTense(LdtMorphTag ldt_tag, ItMorphTag it_tag) {
        switch (it_tag.tense_) {
            case One: {
                ldt_tag.tense_ = LdtMorphTag.Tense.p;
                break;
            }
            case Two: {
                ldt_tag.tense_ = LdtMorphTag.Tense.i;
                break;
            }
            case Three: {
                ldt_tag.tense_ = LdtMorphTag.Tense.f;
                break;
            }
            case Four: {
                ldt_tag.tense_ = LdtMorphTag.Tense.r;
                break;
            }
            case Five: {
                ldt_tag.tense_ = LdtMorphTag.Tense.l;
                break;
            }
            case Six: {
                ldt_tag.tense_ = LdtMorphTag.Tense.t;
                break;
            }
            default: {
                ldt_tag.tense_ = LdtMorphTag.Tense.Undef;
            }
        }
    }

    private void setNumber(LdtMorphTag ldt_tag, ItMorphTag it_tag) {
        block0 : switch (it_tag.gender_number_person_) {
            case Four: 
            case Five: 
            case Six: {
                ldt_tag.number_ = LdtMorphTag.Number.s;
                break;
            }
            case Seven: 
            case Eight: 
            case Nine: {
                ldt_tag.number_ = LdtMorphTag.Number.p;
                break;
            }
            default: {
                switch (it_tag.case_number) {
                    case A: 
                    case B: 
                    case C: 
                    case D: 
                    case E: 
                    case F: {
                        ldt_tag.number_ = LdtMorphTag.Number.s;
                        break block0;
                    }
                    case J: 
                    case K: 
                    case L: 
                    case M: 
                    case N: 
                    case O: {
                        ldt_tag.number_ = LdtMorphTag.Number.p;
                        break block0;
                    }
                }
                ldt_tag.number_ = LdtMorphTag.Number.Undef;
            }
        }
    }

    private void setPerson(LdtMorphTag ldt_tag, ItMorphTag it_tag) {
        switch (it_tag.gender_number_person_) {
            case Four: 
            case Seven: {
                ldt_tag.person_ = LdtMorphTag.Person.first;
                break;
            }
            case Five: 
            case Eight: {
                ldt_tag.person_ = LdtMorphTag.Person.second;
                break;
            }
            case Six: 
            case Nine: {
                ldt_tag.person_ = LdtMorphTag.Person.third;
                break;
            }
            default: {
                ldt_tag.person_ = LdtMorphTag.Person.Undef;
            }
        }
    }

    public static void main(String[] args2) throws IOException {
        BufferedReader reader = FileUtils.openFile("/mount/projekte/sfb-732/d4/users/muellets/treebanks/latin/ldt-1.5/tagwords.txt");
        HashMap<String, Set> ldt_word_map = new HashMap<String, Set>();
        HashMap<String, Integer> ldt_tag_vocab = new HashMap<String, Integer>();
        HashMap<String, Set> ldt_morph_pos_map = new HashMap<String, Set>();
        while (reader.ready()) {
            String line = reader.readLine().trim();
            if (line.isEmpty()) continue;
            String[] tokens = line.split("\\s+");
            int count2 = Integer.parseInt(tokens[0]);
            String form = tokens[1];
            String pos = tokens[2];
            String morph = tokens[3];
            Set tags = ldt_morph_pos_map.computeIfAbsent(morph, k -> new HashSet());
            tags.add(pos);
            tags = ldt_word_map.computeIfAbsent(morph, k -> new HashSet());
            tags.add(form);
            Integer word_count = (Integer)ldt_tag_vocab.get(morph);
            if (word_count == null) {
                word_count = 0;
            }
            word_count = word_count + count2;
            ldt_tag_vocab.put(morph, word_count);
        }
        reader.close();
        reader = FileUtils.openFile("/mount/projekte/sfb-732/d4/users/muellets/treebanks/latin/ittb/tagwords.txt");
        ItLdtMapper mapper = new ItLdtMapper();
        ItMorphTag.VERBOSE = false;
        HashMap<String, Set> it_word_map = new HashMap<String, Set>();
        HashSet<String> set = new HashSet<String>();
        while (reader.ready()) {
            String line = reader.readLine().trim();
            if (line.isEmpty()) continue;
            String[] tokens = line.split("\\s+");
            String form = tokens[1];
            String it_tag_string = tokens[2] + " " + tokens[3] + " " + tokens[4];
            ItMorphTag it_tag = (ItMorphTag)ItMorphTag.parseString(it_tag_string);
            LdtMorphTag ldt_tag = (LdtMorphTag)mapper.convert(it_tag);
            String tag = ldt_tag.toString().substring(1);
            Set tags = it_word_map.computeIfAbsent(form, k -> new HashSet());
            tags.add(tag + "#" + tokens[4]);
            set.add(tag);
        }
        int total = 0;
        int unseen = 0;
        HashMap<String, Integer> confusion_map = new HashMap<String, Integer>();
        for (Map.Entry entry : ldt_word_map.entrySet()) {
            String[] tags;
            String tag = (String)entry.getKey();
            int count3 = (Integer)ldt_tag_vocab.get(tag);
            total += count3;
            if (set.contains(tag)) continue;
            HashSet tag_set = new HashSet();
            for (String form : (Set)entry.getValue()) {
                tags = (String[])it_word_map.get(form);
                if (tags == null) continue;
                tag_set.addAll(tags);
            }
            for (String compound_tag : tag_set) {
                tags = compound_tag.split("#");
                if (ItLdtMapper.distance(tag, tags[0], confusion_map) >= 2) continue;
            }
            unseen += count3;
        }
        for (Map.Entry entry : confusion_map.entrySet()) {
            System.err.format("%s %d\n", entry.getKey(), entry.getValue());
        }
        System.err.format("%d / %d = %g", unseen, total, (double)unseen * 100.0 / (double)total);
        reader.close();
    }

    private static int distance(String tag, String string, Map<String, Integer> map2) {
        assert (tag.length() == string.length());
        int dist = 0;
        for (int index = 0; index < tag.length(); ++index) {
            if (tag.charAt(index) == string.charAt(index)) continue;
            String siganture = String.format("%d %c %c", index + 2, Character.valueOf(tag.charAt(index)), Character.valueOf(string.charAt(index)));
            Integer count2 = map2.get(siganture);
            if (count2 == null) {
                count2 = 0;
            }
            map2.put(siganture, count2 + 1);
            ++dist;
        }
        return dist;
    }
}

